/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class ExternalProcessRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] command, Consumer<? super String> onStdOut, Consumer<? super String> onStdErr) {
        Process process = new ProcessBuilder(command).start();
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try (InputStreamReader outStream = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
             InputStreamReader errStream = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
             Scanner stdOut = new Scanner(outStream);
             Scanner stdErr = new Scanner(errStream);){
            Future<?> handleStdOut = executorService.submit(() -> {
                while (stdOut.hasNextLine()) {
                    onStdOut.accept(stdOut.nextLine());
                }
            });
            Future<?> handleStdErr = executorService.submit(() -> {
                while (stdErr.hasNextLine()) {
                    onStdErr.accept(stdErr.nextLine());
                }
            });
            handleStdOut.get();
            handleStdErr.get();
        }
        finally {
            executorService.shutdown();
        }
        return process.waitFor();
    }
}

