/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.callback.Warning;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.sqlscript.FlywaySqlScriptException;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;
import org.flywaydb.core.internal.util.AsciiTable;
import org.flywaydb.core.internal.util.StringUtils;

public class DefaultSqlScriptExecutor
implements SqlScriptExecutor {
    private static final Log LOG = LogFactory.getLog(DefaultSqlScriptExecutor.class);
    protected final JdbcTemplate jdbcTemplate;
    private static final int MAX_BATCH_SIZE = 100;
    private final boolean batch;

    public DefaultSqlScriptExecutor(JdbcTemplate jdbcTemplate, CallbackExecutor callbackExecutor, boolean undo, boolean batch, boolean outputQueryResults, StatementInterceptor statementInterceptor) {
        this.jdbcTemplate = jdbcTemplate;
        this.batch = batch;
    }

    @Override
    public void execute(SqlScript sqlScript, Configuration config) {
        ArrayList<SqlStatement> batchStatements = new ArrayList<SqlStatement>();
        try (SqlStatementIterator sqlStatementIterator = sqlScript.getSqlStatements();){
            SqlStatement sqlStatement;
            while ((sqlStatement = (SqlStatement)sqlStatementIterator.next()) != null) {
                if (this.batch) {
                    if (sqlStatement.isBatchable()) {
                        this.logStatementExecution(sqlStatement);
                        batchStatements.add(sqlStatement);
                        if (batchStatements.size() < 100) continue;
                        this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements, config);
                        batchStatements = new ArrayList();
                        continue;
                    }
                    this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements, config);
                    batchStatements = new ArrayList();
                    this.executeStatement(this.jdbcTemplate, sqlScript, sqlStatement, config);
                    continue;
                }
                this.executeStatement(this.jdbcTemplate, sqlScript, sqlStatement, config);
            }
        }
        if (this.batch) {
            this.executeBatch(this.jdbcTemplate, sqlScript, batchStatements, config);
        }
    }

    protected void logStatementExecution(SqlStatement sqlStatement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + (this.batch && sqlStatement.isBatchable() ? "batchable " : "") + "SQL: " + sqlStatement.getSql());
        }
    }

    private void executeBatch(JdbcTemplate jdbcTemplate, SqlScript sqlScript, List<SqlStatement> batchStatements, Configuration config) {
        if (batchStatements.isEmpty()) {
            return;
        }
        LOG.debug("Sending batch of " + batchStatements.size() + " statements to database ...");
        ArrayList<String> sqlBatch = new ArrayList<String>();
        for (SqlStatement sqlStatement : batchStatements) {
            sqlBatch.add(sqlStatement.getSql());
        }
        Results results = jdbcTemplate.executeBatch(sqlBatch, config);
        if (results.getException() != null) {
            this.handleException(results, sqlScript, batchStatements.get(0), config);
            for (int i = 0; i < results.getResults().size(); ++i) {
                SqlStatement sqlStatement = batchStatements.get(i);
                long updateCount = results.getResults().get(i).getUpdateCount();
                if (updateCount == -3L) {
                    this.handleException(results, sqlScript, batchStatements.get(i), config);
                    continue;
                }
                if (updateCount == -2L) continue;
                this.handleUpdateCount(updateCount);
            }
            return;
        }
        for (int i = 0; i < results.getResults().size(); ++i) {
            SqlStatement sqlStatement = batchStatements.get(i);
        }
        this.handleResults(results);
    }

    protected void executeStatement(JdbcTemplate jdbcTemplate, SqlScript sqlScript, SqlStatement sqlStatement, Configuration config) {
        this.logStatementExecution(sqlStatement);
        String sql = sqlStatement.getSql() + sqlStatement.getDelimiter();
        Results results = sqlStatement.execute(jdbcTemplate);
        if (results.getException() != null) {
            this.printWarnings(results);
            this.handleException(results, sqlScript, sqlStatement, config);
            return;
        }
        this.printWarnings(results);
        this.handleResults(results);
    }

    protected void handleResults(Results results) {
        for (Result result : results.getResults()) {
            long updateCount = result.getUpdateCount();
            if (updateCount != -1L) {
                this.handleUpdateCount(updateCount);
            }
            this.outputQueryResult(result);
        }
    }

    protected void outputQueryResult(Result result) {
        if (result.getColumns() != null && !result.getColumns().isEmpty()) {
            LOG.info(new AsciiTable(result.getColumns(), result.getData(), true, "", "No rows returned").render());
        }
    }

    private void handleUpdateCount(long updateCount) {
        LOG.debug(updateCount + "row" + StringUtils.pluralizeSuffix(updateCount) + " affected");
    }

    protected void handleException(Results results, SqlScript sqlScript, SqlStatement sqlStatement, Configuration config) {
        throw new FlywaySqlScriptException(sqlScript.getResource(), sqlStatement, results.getException());
    }

    private void printWarnings(Results results) {
        for (Warning warning : results.getWarnings()) {
            if ("00000".equals(warning.getState())) {
                LOG.info("DB: " + warning.getMessage());
                continue;
            }
            LOG.warn("DB: " + warning.getMessage() + " (SQL State: " + warning.getState() + " - Error Code: " + warning.getCode() + ")");
        }
    }
}

