/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.sql.SQLException;
import java.util.function.BiFunction;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.experimental.DatabaseSupport;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;

public interface ExperimentalDatabase
extends Plugin,
AutoCloseable {
    public DatabaseSupport supportsUrl(String var1);

    public boolean supportsDdlTransactions();

    public void initialize(ResolvedEnvironment var1, Configuration var2) throws SQLException;

    public void doExecute(String var1);

    public MetaData getDatabaseMetaData();

    public void createSchemaHistoryTable(String var1);

    public boolean schemaHistoryTableExists(String var1);

    public SchemaHistoryModel getSchemaHistoryModel(String var1);

    public void appendSchemaHistoryItem(SchemaHistoryItem var1, String var2);

    default public String doQuote(String identifier) {
        return this.getOpenQuote() + identifier + this.getCloseQuote();
    }

    default public String getOpenQuote() {
        return "\"";
    }

    default public String getCloseQuote() {
        return "\"";
    }

    default public String quote(String ... identifiers) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String identifier : identifiers) {
            if (!first) {
                result.append(".");
            }
            first = false;
            result.append(this.doQuote(identifier));
        }
        return result.toString();
    }

    public String getCurrentSchema();

    public Boolean allSchemasEmpty(String[] var1);

    public boolean isSchemaExists(String var1);

    public void createSchemas(String ... var1);

    public String getDatabaseType();

    public BiFunction<Configuration, ParsingContext, Parser> getParser();

    public void addToBatch(String var1);

    public void doExecuteBatch();

    public String getCurrentUser();

    public void startTransaction();

    public void commitTransaction();

    public void rollbackTransaction();
}

