/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;

public final class MigrationVersion
implements Comparable<MigrationVersion> {
    public static final MigrationVersion EMPTY = new MigrationVersion(null, "<< Empty Schema >>");
    public static final MigrationVersion LATEST = new MigrationVersion(BigInteger.valueOf(-1L), "<< Latest Version >>");
    public static final MigrationVersion CURRENT = new MigrationVersion(BigInteger.valueOf(-2L), "<< Current Version >>");
    public static final MigrationVersion NEXT = new MigrationVersion(BigInteger.valueOf(-3L), "<< Next Version >>");
    private static final Pattern SPLIT_REGEX = Pattern.compile("\\.(?=\\d)");
    private final List<BigInteger> versionParts;
    private final String displayText;
    private final String rawVersion;

    public static MigrationVersion fromVersion(String version) {
        if ("current".equalsIgnoreCase(version)) {
            return CURRENT;
        }
        if ("next".equalsIgnoreCase(version)) {
            return NEXT;
        }
        if ("latest".equalsIgnoreCase(version) || LATEST.getVersion().equals(version)) {
            return LATEST;
        }
        if (version == null) {
            return EMPTY;
        }
        return new MigrationVersion(version);
    }

    private MigrationVersion(String version) {
        String normalizedVersion = version.replace('_', '.');
        this.versionParts = this.tokenize(normalizedVersion);
        this.displayText = normalizedVersion;
        this.rawVersion = version;
    }

    private MigrationVersion(BigInteger version, String displayText) {
        this.versionParts = new ArrayList<BigInteger>();
        this.versionParts.add(version);
        this.displayText = displayText;
        this.rawVersion = displayText;
    }

    public String toString() {
        return this.displayText;
    }

    public String getVersion() {
        if (this.equals(EMPTY)) {
            return null;
        }
        if (this.equals(LATEST)) {
            return Long.toString(Long.MAX_VALUE);
        }
        return this.displayText;
    }

    public String getName() {
        if (this.equals(EMPTY)) {
            return null;
        }
        if (this.equals(LATEST)) {
            return "latest";
        }
        if (this.equals(CURRENT)) {
            return "current";
        }
        if (this.equals(NEXT)) {
            return "next";
        }
        return this.displayText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationVersion version1 = (MigrationVersion)o;
        return this.compareTo(version1) == 0;
    }

    public int hashCode() {
        return this.versionParts == null ? 0 : this.versionParts.hashCode();
    }

    public boolean isAtLeast(String otherVersion) {
        return this.compareTo(MigrationVersion.fromVersion(otherVersion)) >= 0;
    }

    public boolean isNewerThan(String otherVersion) {
        return this.compareTo(MigrationVersion.fromVersion(otherVersion)) > 0;
    }

    public boolean isNewerThan(MigrationVersion otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    public boolean isMajorNewerThan(String otherVersion) {
        return this.getMajor().compareTo(MigrationVersion.fromVersion(otherVersion).getMajor()) > 0;
    }

    public BigInteger getMajor() {
        return this.versionParts.get(0);
    }

    public String getMajorAsString() {
        return this.versionParts.get(0).toString();
    }

    public String getMinorAsString() {
        if (this.versionParts.size() == 1) {
            return "0";
        }
        return this.versionParts.get(1).toString();
    }

    @Override
    public int compareTo(MigrationVersion o) {
        if (o == null) {
            return 1;
        }
        if (this == EMPTY) {
            if (o == EMPTY) {
                return 0;
            }
            return -1;
        }
        if (this == CURRENT) {
            return o == CURRENT ? 0 : -1;
        }
        if (this == LATEST) {
            if (o == LATEST) {
                return 0;
            }
            return 1;
        }
        if (o == EMPTY) {
            return 1;
        }
        if (o == CURRENT) {
            return 1;
        }
        if (o == LATEST) {
            return -1;
        }
        List<BigInteger> parts1 = this.versionParts;
        List<BigInteger> parts2 = o.versionParts;
        int largestNumberOfParts = Math.max(parts1.size(), parts2.size());
        for (int i = 0; i < largestNumberOfParts; ++i) {
            int compared = this.getOrZero(parts1, i).compareTo(this.getOrZero(parts2, i));
            if (compared == 0) continue;
            return compared;
        }
        return 0;
    }

    private BigInteger getOrZero(List<BigInteger> elements, int i) {
        return i < elements.size() ? elements.get(i) : BigInteger.ZERO;
    }

    private List<BigInteger> tokenize(String versionStr) {
        ArrayList<BigInteger> parts = new ArrayList<BigInteger>();
        for (String part : SPLIT_REGEX.split(versionStr)) {
            parts.add(this.toBigInteger(versionStr, part));
        }
        for (int i = parts.size() - 1; i > 0 && ((BigInteger)parts.get(i)).equals(BigInteger.ZERO); --i) {
            parts.remove(i);
        }
        return parts;
    }

    private BigInteger toBigInteger(String versionStr, String part) {
        try {
            return new BigInteger(part);
        }
        catch (NumberFormatException e) {
            throw new FlywayException("Version may only contain 0..9 and . (dot). Invalid version: " + versionStr);
        }
    }

    public String getRawVersion() {
        return this.rawVersion;
    }
}

