/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.File;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.FileUtils;

public class JsonUtils {
    public static String jsonToFile(String filename, Object json) {
        File file = new File(filename);
        FileUtils.createDirIfNotExists(file);
        try {
            JsonMapper mapper = JsonUtils.getJsonMapper();
            mapper.writeValue(file, json);
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            throw new FlywayException("Unable to write JSON to file: " + e.getMessage());
        }
    }

    public static String toJson(Object object) {
        try {
            return JsonUtils.getJsonMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new FlywayException("Unable to serialize object to JSON", e);
        }
    }

    public static JsonMapper getJsonMapper() {
        JsonMapper mapper = new JsonMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(SerializationFeature.WRITE_DATES_WITH_ZONE_ID, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static <T> List<T> toList(String json) {
        try {
            return (List)JsonUtils.getJsonMapper().readValue(json, new TypeReference<List<T>>(){});
        }
        catch (JsonProcessingException e) {
            throw new FlywayException("Unable to parse JSON: " + json, e);
        }
    }

    public static String getFromJson(String json, String key) {
        try {
            return JsonUtils.getJsonMapper().readTree(json).get(key).asText();
        }
        catch (JsonProcessingException e) {
            return "";
        }
    }

    public static JsonArray parseJsonArray(String json) {
        return JsonParser.parseString((String)json).getAsJsonArray();
    }

    public static <T> T parseJson(String json, Class<T> clazz) {
        try {
            return (T)JsonUtils.getJsonMapper().readValue(json, clazz);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to parse JSON: " + e.getMessage());
        }
    }

    public static <T> T parseJson(String json, TypeReference<T> typeReference) {
        try {
            return (T)JsonUtils.getJsonMapper().readValue(json, typeReference);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to parse JSON: " + e.getMessage());
        }
    }

    private JsonUtils() {
    }
}

