/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.sql.SQLException;
import org.flywaydb.core.experimental.DatabaseSupport;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;

public interface ExperimentalDatabase
extends Plugin,
AutoCloseable {
    public DatabaseSupport supportsUrl(String var1);

    public void initialize(ResolvedEnvironment var1) throws SQLException;

    public MetaData getDatabaseMetaData();

    public void createSchemaHistoryTable(String var1);

    public boolean schemaHistoryTableExists(String var1);

    public SchemaHistoryModel getSchemaHistoryModel(String var1);

    default public String doQuote(String identifier) {
        return this.getOpenQuote() + identifier + this.getCloseQuote();
    }

    default public String getOpenQuote() {
        return "\"";
    }

    default public String getCloseQuote() {
        return "\"";
    }

    default public String quote(String ... identifiers) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String identifier : identifiers) {
            if (!first) {
                result.append(".");
            }
            first = false;
            result.append(this.doQuote(identifier));
        }
        return result.toString();
    }

    public String getCurrentSchema();

    public Boolean allSchemasEmpty();
}

