/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.experimental.ExperimentalMigrationScanner;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;

public class ExperimentalMigrationScannerManager {
    private final List<? extends ExperimentalMigrationScanner> scanners;

    public ExperimentalMigrationScannerManager(List<? extends ExperimentalMigrationScanner> scanners) {
        this.scanners = scanners;
    }

    public Collection<LoadableResourceMetadata> scan(Configuration configuration) {
        List<LoadableResourceMetadata> resources = Arrays.stream(configuration.getLocations()).flatMap(location -> this.scan((Location)location, configuration).stream()).map(resource -> ExperimentalMigrationScannerManager.getLoadableResourceMetadata(resource, configuration)).toList();
        HashSet resourceSet = new HashSet();
        resources.forEach(resource -> {
            if (resourceSet.contains(resource)) {
                LoadableResourceMetadata first = resourceSet.stream().filter(loadableResourceMetadata -> loadableResourceMetadata.equals(resource)).findFirst().get();
                if (first.version() != null) {
                    throw new FlywayException(String.format("Found more than one migration with version %s\nOffenders:\n-> %s \n-> %s", resource.version(), resource.loadableResource().getAbsolutePath(), first.loadableResource().getAbsolutePath()), CoreErrorCode.DUPLICATE_VERSIONED_MIGRATION);
                }
                throw new FlywayException(String.format("Found more than one repeatable migration with description '%s'\nOffenders:\n-> %s \n-> %s ", resource.description(), resource.loadableResource().getAbsolutePath(), first.loadableResource().getAbsolutePath()), CoreErrorCode.DUPLICATE_REPEATABLE_MIGRATION);
            }
            resourceSet.add(resource);
        });
        return resources;
    }

    private static LoadableResourceMetadata getLoadableResourceMetadata(LoadableResource resource, Configuration configuration) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        ResourceName resourceName = resourceNameParser.parse(resource.getFilename());
        return new LoadableResourceMetadata(resourceName.getVersion(), resourceName.getDescription(), resourceName.getPrefix(), resource);
    }

    private Collection<LoadableResource> scan(Location location, Configuration configuration) {
        return this.scanners.stream().flatMap(scanner -> scanner.scan(location, configuration).stream()).toList();
    }
}

