/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.output;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.api.output.MigrateOutput;
import org.flywaydb.core.api.output.MigrationKey;
import org.flywaydb.core.internal.info.MigrationInfoImpl;

public class MigrateResult
extends HtmlResult {
    public static final String COMMAND = "migrate";
    public String initialSchemaVersion;
    public String targetSchemaVersion;
    public String schemaName;
    public List<MigrateOutput> migrations;
    public int migrationsExecuted;
    public boolean success;
    public String flywayVersion;
    public String database;
    public List<String> warnings = new ArrayList<String>();
    public String databaseType;
    private transient Map<MigrationKey, MigrateOutput> pendingMigrations = new HashMap<MigrationKey, MigrateOutput>();
    private transient Map<MigrationKey, MigrateOutput> failedMigrations = new HashMap<MigrationKey, MigrateOutput>();
    private transient Map<MigrationKey, MigrateOutput> successfulMigrations = new HashMap<MigrationKey, MigrateOutput>();

    public MigrateResult(String flywayVersion, String database, String schemaName, String databaseType) {
        super(LocalDateTime.now(), COMMAND);
        this.flywayVersion = flywayVersion;
        this.database = database;
        this.schemaName = schemaName;
        this.migrations = new ArrayList<MigrateOutput>();
        this.success = true;
        this.databaseType = databaseType;
    }

    MigrateResult(MigrateResult migrateResult) {
        super(migrateResult.getTimestamp(), migrateResult.getOperation());
        this.flywayVersion = migrateResult.flywayVersion;
        this.database = migrateResult.database;
        this.schemaName = migrateResult.schemaName;
        this.migrations = migrateResult.migrations;
        this.success = migrateResult.success;
        this.migrationsExecuted = migrateResult.migrationsExecuted;
        this.initialSchemaVersion = migrateResult.initialSchemaVersion;
        this.pendingMigrations = migrateResult.pendingMigrations;
        this.failedMigrations = migrateResult.failedMigrations;
        this.successfulMigrations = migrateResult.successfulMigrations;
        this.targetSchemaVersion = migrateResult.targetSchemaVersion;
        this.warnings = migrateResult.warnings;
        this.databaseType = migrateResult.databaseType;
    }

    public void putSuccessfulMigration(MigrationInfo migrationInfo, int executionTime) {
        MigrationKey key = new MigrationKey(migrationInfo);
        MigrateOutput migrateOutput = CommandResultFactory.createMigrateOutput(migrationInfo, executionTime);
        this.successfulMigrations.put(key, migrateOutput);
        this.pendingMigrations.remove(key);
    }

    public void putPendingMigration(MigrationInfo migrationInfo) {
        this.pendingMigrations.put(new MigrationKey(migrationInfo), CommandResultFactory.createMigrateOutput(migrationInfo, 0));
    }

    public void putFailedMigration(MigrationInfo migrationInfo, int executionTime) {
        MigrationKey key = new MigrationKey(migrationInfo);
        this.failedMigrations.put(key, CommandResultFactory.createMigrateOutput(migrationInfo, executionTime));
        this.pendingMigrations.remove(key);
    }

    public List<MigrateOutput> getPendingMigrations() {
        return List.copyOf(this.pendingMigrations.values());
    }

    public List<MigrateOutput> getSuccessfulMigrations() {
        return List.copyOf(this.successfulMigrations.values());
    }

    public List<MigrateOutput> getFailedMigrations() {
        return List.copyOf(this.failedMigrations.values());
    }

    public void addWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warning);
    }

    public long getTotalMigrationTime() {
        if (this.migrations == null) {
            return 0L;
        }
        return this.migrations.stream().filter(Objects::nonNull).mapToLong(migrateOutput -> migrateOutput.executionTime).sum();
    }

    public void markAsRolledBack(List<MigrationInfoImpl> rolledBackMigrations) {
        for (MigrationInfoImpl migrationInfo : rolledBackMigrations) {
            MigrationKey key = new MigrationKey(migrationInfo);
            if (this.failedMigrations.containsKey(key)) {
                this.failedMigrations.get((Object)key).rolledBack = true;
            }
            if (!this.successfulMigrations.containsKey(key)) continue;
            this.successfulMigrations.get((Object)key).rolledBack = true;
        }
    }
}

