/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;

public class PropertyResolverContextImpl
implements PropertyResolverContext {
    private final Map<String, PropertyResolver> resolvers;
    private final Map<String, Map<String, Object>> resolverProperties;
    private final String environmentName;
    private final String workingDirectory;
    private static final CharsetEncoder ASCII_ENCODER = StandardCharsets.US_ASCII.newEncoder();
    private static final Pattern RESOLVER_REGEX_PATTERN = Pattern.compile("\\${1,2}\\{[^.]+\\.[^.]+\\}");
    private static final Pattern VERBATIM_REGEX_PATTERN = Pattern.compile("\\!\\{.*\\}");

    public PropertyResolverContextImpl(String environmentName, String workingDirectory, Map<String, PropertyResolver> resolvers, Map<String, Map<String, Object>> resolverProperties) {
        this.environmentName = environmentName;
        this.workingDirectory = workingDirectory;
        this.resolvers = resolvers;
        this.resolverProperties = resolverProperties;
    }

    @Override
    public String resolvePropertyString(String resolverName, String propertyName, ProgressLogger progress) {
        String string;
        if (this.resolverProperties == null) {
            return null;
        }
        Map<String, Object> properties = this.resolverProperties.get(resolverName);
        if (properties == null) {
            return null;
        }
        Object value = properties.get(propertyName);
        if (value instanceof String) {
            String valueString = (String)value;
            string = this.resolveValue(valueString, progress);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public List<String> resolvePropertyStringList(String resolverName, String propertyName, ProgressLogger progress) {
        if (this.resolverProperties == null) {
            return null;
        }
        Map<String, Object> properties = this.resolverProperties.get(resolverName);
        if (properties == null) {
            return null;
        }
        Object propertyValue = properties.get(propertyName);
        if (!(propertyValue instanceof List)) {
            return null;
        }
        return ((List)propertyValue).stream().filter(v -> v instanceof String).map(v -> this.resolveValue((String)v, progress)).toList();
    }

    @Override
    public Integer getPropertyInteger(String resolverName, String propertyName) {
        Integer i;
        if (this.resolverProperties == null) {
            return null;
        }
        Map<String, Object> properties = this.resolverProperties.get(resolverName);
        if (properties == null) {
            return null;
        }
        Object propertyValue = properties.get(propertyName);
        return propertyValue instanceof Integer ? (i = (Integer)propertyValue) : null;
    }

    @Override
    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            return System.getProperty("user.dir");
        }
        return this.workingDirectory;
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public String resolveValue(String value, ProgressLogger progress) {
        if (value == null) {
            return null;
        }
        if (this.isVerbatim(value)) {
            return value.substring(2, value.length() - 1);
        }
        return RESOLVER_REGEX_PATTERN.matcher(value.strip()).replaceAll(m -> this.parseResolverSyntax((MatchResult)m, progress));
    }

    private boolean isVerbatim(String value) {
        return VERBATIM_REGEX_PATTERN.matcher(value.strip()).matches();
    }

    private String parseResolverSyntax(MatchResult resolverMatchResult, ProgressLogger progress) {
        String resolverMatch = resolverMatchResult.group();
        if (resolverMatch.startsWith("$$")) {
            return "\\" + resolverMatch.substring(1);
        }
        String resolverName = resolverMatch.substring(2, resolverMatch.indexOf(".")).strip();
        if (!this.resolvers.containsKey(resolverName)) {
            throw new FlywayException("Unknown resolver '" + resolverName + "' for environment " + this.environmentName, ErrorCode.CONFIGURATION);
        }
        if (resolverMatch.contains(":")) {
            String resolverParam = resolverMatch.substring(resolverMatch.indexOf(".") + 1, resolverMatch.indexOf(":")).strip();
            String filter = resolverMatch.substring(resolverMatch.indexOf(":") + 1, resolverMatch.length() - 1).strip();
            return PropertyResolverContextImpl.filter(this.resolvers.get(resolverName).resolve(resolverParam, this, progress), filter);
        }
        String resolverParam = resolverMatch.substring(resolverMatch.indexOf(".") + 1, resolverMatch.length() - 1).strip();
        return this.resolvers.get(resolverName).resolve(resolverParam, this, progress);
    }

    static String filter(String str, String filter) {
        return str.chars().filter(c -> PropertyResolverContextImpl.isAllowed((char)c, filter)).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static boolean isAllowed(char c, String filter) {
        return filter.contains("D") && Character.isDigit(c) || filter.contains("A") && Character.isLetter(c) || filter.contains("a") && Character.isLetter(c) && ASCII_ENCODER.canEncode(c) || filter.contains("d") && Character.isDigit(c) && ASCII_ENCODER.canEncode(c);
    }
}

