/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.ProgressLoggerEmpty;
import org.flywaydb.core.ProgressLoggerJson;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.extensibility.ConfigurationProvider;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.FlywayModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentProvisioner;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.jdbc.DriverDataSource;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.scanner.ClasspathClassScanner;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.MergeUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class ClassicConfiguration
implements Configuration {
    private static final Log LOG = LogFactory.getLog(ClassicConfiguration.class);
    private static final Pattern ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN = Pattern.compile("\"([^\"]*)\"");
    private static final Pattern ANY_WORD_BETWEEN_TWO_DOTS_PATTERN = Pattern.compile("\\.(.*?)\\.");
    public static final String TEMP_ENVIRONMENT_NAME = "tempConfigEnvironment";
    private ConfigurationModel modernConfig = ConfigurationModel.defaults();
    private final Map<String, ResolvedEnvironment> resolvedEnvironments = new HashMap<String, ResolvedEnvironment>();
    private DataSource dataSource;
    private String workingDirectory;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private DatabaseType databaseType;
    private EnvironmentResolver environmentResolver;
    private ResourceProvider resourceProvider = null;
    private ClassProvider<JavaMigration> javaMigrationClassProvider = null;
    private JavaMigration[] javaMigrations = new JavaMigration[0];
    private MigrationResolver[] resolvers = new MigrationResolver[0];
    private OutputStream dryRunOutput;
    private final List<Callback> callbacks = new ArrayList<Callback>();
    private final ClasspathClassScanner classScanner;
    private PluginRegister pluginRegister = new PluginRegister();

    public void setDefaultSchema(String defaultSchema) {
        this.getModernFlyway().setDefaultSchema(defaultSchema);
    }

    @Override
    public String getDefaultSchema() {
        return this.getModernFlyway().getDefaultSchema();
    }

    private EnvironmentModel getCurrentUnresolvedEnvironment() {
        String envName = this.modernConfig.getFlyway().getEnvironment();
        if (!StringUtils.hasText(envName)) {
            envName = "default";
        }
        if (!this.getModernConfig().getEnvironments().containsKey(envName)) {
            throw new FlywayException("Environment '" + envName + "' not found. Check that this environment exists in your configuration.");
        }
        return this.getModernConfig().getEnvironments().get(envName);
    }

    public ResolvedEnvironment getCurrentResolvedEnvironment() {
        return this.getCurrentResolvedEnvironment(null);
    }

    public ResolvedEnvironment getCurrentResolvedEnvironment(ProgressLogger progress) {
        String envProvisionMode;
        ProvisionerMode provisionerMode;
        ResolvedEnvironment resolved;
        String envName = this.modernConfig.getFlyway().getEnvironment();
        if (!StringUtils.hasText(envName)) {
            envName = "default";
        }
        if ((resolved = this.getResolvedEnvironment(envName, provisionerMode = StringUtils.hasText(envProvisionMode = this.modernConfig.getFlyway().getEnvironmentProvisionMode()) ? ProvisionerMode.fromString(envProvisionMode) : ProvisionerMode.Provision, progress)) == null) {
            throw new FlywayException("Environment '" + envName + "' not found. Check that this environment exists in your configuration.");
        }
        return resolved;
    }

    public ResolvedEnvironment getResolvedEnvironment(String envName) {
        return this.getResolvedEnvironment(envName, ProvisionerMode.Provision, null);
    }

    public ResolvedEnvironment getResolvedEnvironment(String envName, ProvisionerMode provisionerMode, ProgressLogger progress) {
        if (this.environmentResolver == null) {
            this.environmentResolver = new EnvironmentResolver(this.pluginRegister.getLicensedPlugins(PropertyResolver.class, this).stream().collect(Collectors.toMap(PropertyResolver::getName, x -> x)), this.pluginRegister.getLicensedPlugins(EnvironmentProvisioner.class, this).stream().collect(Collectors.toMap(EnvironmentProvisioner::getName, x -> x)));
        }
        if (!this.resolvedEnvironments.containsKey(envName) && this.getModernConfig().getEnvironments().containsKey(envName)) {
            EnvironmentModel unresolved = this.getModernConfig().getEnvironments().get(envName);
            ResolvedEnvironment resolved = this.environmentResolver.resolve(envName, unresolved, provisionerMode, this.getWorkingDirectory(), progress == null ? this.createProgress("environment") : progress);
            this.resolvedEnvironments.put(envName, resolved);
        }
        return this.resolvedEnvironments.get(envName);
    }

    private FlywayModel getModernFlyway() {
        return this.modernConfig.getFlyway();
    }

    @Override
    public String[] getSchemas() {
        return this.getCurrentResolvedEnvironment().getSchemas().toArray(new String[0]);
    }

    @Override
    public boolean isReportEnabled() {
        return this.modernConfig.getFlyway().getReportEnabled() != null && this.modernConfig.getFlyway().getReportEnabled() != false;
    }

    @Override
    public Charset getEncoding() {
        return Charset.forName(this.getModernFlyway().getEncoding());
    }

    @Override
    public boolean isDetectEncoding() {
        return this.getModernFlyway().getDetectEncoding();
    }

    @Override
    public String getReportFilename() {
        return this.getModernFlyway().getReportFilename();
    }

    @Override
    public Map<String, ResolvedEnvironment> getCachedResolvedEnvironments() {
        return Map.copyOf(this.resolvedEnvironments);
    }

    public ClassicConfiguration(ConfigurationModel modernConfig) {
        this.classScanner = new ClasspathClassScanner(this.classLoader);
        this.modernConfig = modernConfig;
    }

    public ClassicConfiguration() {
        this.classScanner = new ClasspathClassScanner(this.classLoader);
    }

    public ClassicConfiguration(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
        this.classScanner = new ClasspathClassScanner(this.classLoader);
    }

    public ClassicConfiguration(Configuration configuration) {
        this(configuration.getClassLoader());
        this.configure(configuration);
    }

    @Override
    public Callback[] getCallbacks() {
        this.loadUnloadedCallbacks();
        return this.callbacks.toArray(new Callback[0]);
    }

    @Override
    public MigrationResolver[] getResolvers() {
        if (this.getModernFlyway().getMigrationResolvers() != null) {
            ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>(Arrays.asList(this.resolvers));
            migrationResolvers.addAll(Arrays.stream((MigrationResolver[])this.getModernFlyway().getMigrationResolvers().stream().filter(p -> Arrays.stream(this.resolvers).noneMatch(r -> r.getClass().getCanonicalName().equals(p))).map(p -> ClassUtils.instantiate(p, this.classLoader)).toArray(MigrationResolver[]::new)).toList());
            this.setResolvers(migrationResolvers.toArray(new MigrationResolver[0]));
        }
        return this.resolvers;
    }

    @Override
    public String getUrl() {
        return this.getCurrentResolvedEnvironment().getUrl();
    }

    @Override
    public String getUser() {
        return this.getCurrentResolvedEnvironment().getUser();
    }

    @Override
    public String getPassword() {
        return this.getCurrentResolvedEnvironment().getPassword();
    }

    @Override
    public Location[] getLocations() {
        Locations locations = new Locations(this.getModernFlyway().getLocations().toArray(new String[0]));
        return locations.getLocations().toArray(new Location[0]);
    }

    @Override
    public boolean isBaselineOnMigrate() {
        return this.getModernFlyway().getBaselineOnMigrate();
    }

    @Override
    public boolean isSkipExecutingMigrations() {
        return this.getModernFlyway().getSkipExecutingMigrations();
    }

    @Override
    public boolean isOutOfOrder() {
        return this.getModernFlyway().getOutOfOrder();
    }

    @Override
    public ValidatePattern[] getIgnoreMigrationPatterns() {
        Object[] ignoreMigrationPatterns = this.getModernFlyway().getIgnoreMigrationPatterns().toArray(new String[0]);
        if (Arrays.equals(ignoreMigrationPatterns, new String[]{""})) {
            return new ValidatePattern[0];
        }
        return (ValidatePattern[])Arrays.stream(ignoreMigrationPatterns).map(ValidatePattern::fromPattern).toArray(ValidatePattern[]::new);
    }

    @Override
    public boolean isValidateMigrationNaming() {
        return this.getModernFlyway().getValidateMigrationNaming();
    }

    @Override
    public boolean isValidateOnMigrate() {
        return this.getModernFlyway().getValidateOnMigrate();
    }

    @Override
    public boolean isCleanOnValidationError() {
        return this.getModernFlyway().getCleanOnValidationError();
    }

    @Override
    public boolean isCleanDisabled() {
        return this.getModernFlyway().getCleanDisabled();
    }

    @Override
    public boolean isMixed() {
        return this.getModernFlyway().getMixed();
    }

    @Override
    public boolean isGroup() {
        return this.getModernFlyway().getGroup();
    }

    @Override
    public String getInstalledBy() {
        return this.getModernFlyway().getInstalledBy();
    }

    @Override
    public String[] getErrorOverrides() {
        return this.getModernFlyway().getErrorOverrides().toArray(new String[0]);
    }

    @Override
    public OutputStream getDryRunOutput() {
        String dryRunOutputFileName;
        if (this.dryRunOutput == null && !StringUtils.hasText(dryRunOutputFileName = this.modernConfig.getFlyway().getDryRunOutput())) {
            return null;
        }
        return this.dryRunOutput;
    }

    @Override
    public boolean isStream() {
        return this.getModernFlyway().getStream();
    }

    @Override
    public boolean isBatch() {
        return this.getModernFlyway().getBatch();
    }

    @Override
    public String getKerberosConfigFile() {
        return this.getModernFlyway().getKerberosConfigFile();
    }

    @Override
    public boolean isOutputQueryResults() {
        return this.getModernFlyway().getOutputQueryResults();
    }

    @Override
    public boolean isCreateSchemas() {
        return this.getModernFlyway().getCreateSchemas();
    }

    @Override
    public int getLockRetryCount() {
        return this.getModernFlyway().getLockRetryCount();
    }

    @Override
    public Map<String, String> getJdbcProperties() {
        return this.getCurrentResolvedEnvironment().getJdbcProperties();
    }

    @Override
    public boolean isFailOnMissingLocations() {
        return this.getModernFlyway().getFailOnMissingLocations();
    }

    @Override
    public String[] getLoggers() {
        return this.getModernFlyway().getLoggers().toArray(new String[0]);
    }

    @Override
    public int getConnectRetries() {
        return this.getCurrentResolvedEnvironment().getConnectRetries();
    }

    @Override
    public int getConnectRetriesInterval() {
        return this.getCurrentResolvedEnvironment().getConnectRetriesInterval();
    }

    @Override
    public String getInitSql() {
        return this.getCurrentResolvedEnvironment().getInitSql();
    }

    @Override
    public MigrationVersion getBaselineVersion() {
        return MigrationVersion.fromVersion(this.getModernFlyway().getBaselineVersion() != null ? this.getModernFlyway().getBaselineVersion() : "1");
    }

    @Override
    public String getBaselineDescription() {
        return this.getModernFlyway().getBaselineDescription();
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.getModernFlyway().getSkipDefaultResolvers();
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.getModernFlyway().getSkipDefaultCallbacks();
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.getModernFlyway().getSqlMigrationPrefix();
    }

    @Override
    public boolean isExecuteInTransaction() {
        return this.getModernFlyway().getExecuteInTransaction();
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.getModernFlyway().getRepeatableSqlMigrationPrefix();
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.getModernFlyway().getSqlMigrationSeparator();
    }

    @Override
    public String[] getSqlMigrationSuffixes() {
        return this.getModernFlyway().getSqlMigrationSuffixes().toArray(new String[0]);
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.getModernFlyway().getPlaceholderReplacement();
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.getModernFlyway().getPlaceholderSuffix();
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.getModernFlyway().getPlaceholderPrefix();
    }

    @Override
    public String getPlaceholderSeparator() {
        return this.getModernFlyway().getPlaceholderSeparator();
    }

    @Override
    public String getScriptPlaceholderSuffix() {
        return this.getModernFlyway().getScriptPlaceholderSuffix();
    }

    @Override
    public String getScriptPlaceholderPrefix() {
        return this.getModernFlyway().getScriptPlaceholderPrefix();
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.getModernFlyway().getPlaceholders();
    }

    @Override
    public MigrationVersion getTarget() {
        String target = this.getModernFlyway().getTarget();
        if (target.endsWith("?")) {
            throw new FlywayTeamsUpgradeRequiredException("failOnMissingTarget");
        }
        this.getModernFlyway().setFailOnMissingTarget(true);
        return MigrationVersion.fromVersion(target);
    }

    @Override
    public boolean isFailOnMissingTarget() {
        return this.getModernFlyway().getFailOnMissingTarget();
    }

    @Override
    public MigrationPattern[] getCherryPick() {
        MigrationPattern[] cherryPick = null;
        ConfigurationExtension cherryPickConfig = (ConfigurationExtension)this.pluginRegister.getLicensedPlugin("CherryPickConfigurationExtension", this);
        if (cherryPickConfig == null) {
            LOG.debug("CherryPickConfigurationExtension not found");
            return null;
        }
        List cherryPickList = (List)ClassUtils.getFieldValue(cherryPickConfig, "cherryPick");
        if (cherryPickList != null) {
            cherryPick = (MigrationPattern[])cherryPickList.stream().map(MigrationPattern::new).toArray(MigrationPattern[]::new);
        }
        MigrationPattern[] migrationPatternArray = cherryPick = cherryPick != null && cherryPick.length == 0 ? null : cherryPick;
        if (cherryPick == null) {
            return null;
        }
        HashSet<String> cherryPickValues = new HashSet<String>();
        ArrayList<String> duplicateValues = new ArrayList<String>();
        StringBuilder migrationPatternsString = new StringBuilder();
        for (MigrationPattern migrationPattern : cherryPick) {
            String migrationPatternString = migrationPattern.toString();
            migrationPatternsString.append(migrationPatternString).append(" ");
            if (cherryPickValues.contains(migrationPatternString)) {
                duplicateValues.add(migrationPatternString);
            }
            cherryPickValues.add(migrationPatternString);
        }
        if (!duplicateValues.isEmpty()) {
            throw new FlywayException("Duplicate values not allowed in migration patterns. Duplication detected in: \n" + migrationPatternsString);
        }
        return cherryPick;
    }

    @Override
    public String getTable() {
        return this.getModernFlyway().getTable();
    }

    @Override
    public String getTablespace() {
        return this.getModernFlyway().getTablespace();
    }

    public void setDryRunOutput(OutputStream dryRunOutput) {
        throw new FlywayTeamsUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutputAsFile(File dryRunOutput) {
        throw new FlywayTeamsUpgradeRequiredException("dryRunOutput");
    }

    private OutputStream getDryRunOutputAsFile(File dryRunOutput) {
        throw new FlywayTeamsUpgradeRequiredException("dryRunOutput");
    }

    public void setDryRunOutputAsFileName(String dryRunOutputFileName) {
        throw new FlywayTeamsUpgradeRequiredException("dryRunOutput");
    }

    public void setErrorOverrides(String ... errorOverrides) {
        throw new FlywayTeamsUpgradeRequiredException("errorOverrides");
    }

    public void setInstalledBy(String installedBy) {
        if ("".equals(installedBy)) {
            installedBy = null;
        }
        this.getModernFlyway().setInstalledBy(installedBy);
    }

    public void setLoggers(String ... loggers) {
        this.getModernFlyway().setLoggers(Arrays.stream(loggers).collect(Collectors.toList()));
    }

    public void setIgnoreMigrationPatterns(String ... ignoreMigrationPatterns) {
        this.getModernFlyway().setIgnoreMigrationPatterns(Arrays.stream(ignoreMigrationPatterns).collect(Collectors.toList()));
    }

    public void setIgnoreMigrationPatterns(ValidatePattern ... ignoreMigrationPatterns) {
        this.getModernFlyway().setIgnoreMigrationPatterns(Arrays.stream(ignoreMigrationPatterns).map(ValidatePattern::toString).collect(Collectors.toList()));
    }

    public void setLocationsAsStrings(String ... locations) {
        this.getModernFlyway().setLocations(Arrays.stream(locations).collect(Collectors.toList()));
    }

    public void setLocations(Location ... locations) {
        this.getModernFlyway().setLocations(Arrays.stream(locations).map(Location::getDescriptor).collect(Collectors.toList()));
    }

    public void setDetectEncoding(boolean detectEncoding) {
        throw new FlywayTeamsUpgradeRequiredException("detectEncoding");
    }

    public void setReportFilename(String reportFilename) {
        this.getModernFlyway().setReportFilename(reportFilename);
    }

    public void setEnvironment(String environment) {
        if (!this.modernConfig.getEnvironments().containsKey(environment)) {
            throw new FlywayException("Environment '" + environment + "' not found");
        }
        this.getModernFlyway().setEnvironment(environment);
    }

    public void setExecuteInTransaction(boolean executeInTransaction) {
        this.getModernFlyway().setExecuteInTransaction(executeInTransaction);
    }

    public void setEncodingAsString(String encoding) {
        this.getModernFlyway().setEncoding(encoding);
    }

    public void setTargetAsString(String target) {
        this.getModernFlyway().setTarget(target);
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        if (!StringUtils.hasLength(placeholderPrefix)) {
            throw new FlywayException("placeholderPrefix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setPlaceholderPrefix(placeholderPrefix);
    }

    public void setScriptPlaceholderPrefix(String scriptPlaceholderPrefix) {
        if (!StringUtils.hasLength(scriptPlaceholderPrefix)) {
            throw new FlywayException("scriptPlaceholderPrefix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setScriptPlaceholderPrefix(scriptPlaceholderPrefix);
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        if (!StringUtils.hasLength(placeholderSuffix)) {
            throw new FlywayException("placeholderSuffix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setPlaceholderSuffix(placeholderSuffix);
    }

    public void setPlaceholderSeparator(String placeholderSeparator) {
        if (!StringUtils.hasLength(placeholderSeparator)) {
            throw new FlywayException("placeholderSeparator cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setPlaceholderSeparator(placeholderSeparator);
    }

    public void setScriptPlaceholderSuffix(String scriptPlaceholderSuffix) {
        if (!StringUtils.hasLength(scriptPlaceholderSuffix)) {
            throw new FlywayException("scriptPlaceholderSuffix cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setScriptPlaceholderSuffix(scriptPlaceholderSuffix);
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.getModernFlyway().setSqlMigrationPrefix(sqlMigrationPrefix);
    }

    public void setJavaMigrations(JavaMigration ... javaMigrations) {
        if (javaMigrations == null) {
            throw new FlywayException("javaMigrations cannot be null", ErrorCode.CONFIGURATION);
        }
        this.javaMigrations = javaMigrations;
    }

    public void setStream(boolean stream) {
        throw new FlywayTeamsUpgradeRequiredException("stream");
    }

    public void setBatch(boolean batch) {
        throw new FlywayTeamsUpgradeRequiredException("batch");
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        if (!StringUtils.hasLength(sqlMigrationSeparator)) {
            throw new FlywayException("sqlMigrationSeparator cannot be empty!", ErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setSqlMigrationSeparator(sqlMigrationSeparator);
    }

    public void setSqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.getModernFlyway().setSqlMigrationSuffixes(Arrays.stream(sqlMigrationSuffixes).collect(Collectors.toList()));
    }

    public void setDataSource(String url, String user, String password) {
        this.getCurrentUnresolvedEnvironment().setUrl(url);
        this.getCurrentUnresolvedEnvironment().setUser(user);
        this.getCurrentUnresolvedEnvironment().setPassword(password);
        this.resolvedEnvironments.clear();
        this.databaseType = StringUtils.hasText(url) ? DatabaseTypeRegister.getDatabaseTypeForUrl(url) : null;
        this.dataSource = new DriverDataSource(this.classLoader, null, url, user, password, this);
        this.licenseGuardJdbcUrl(url);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        try (Connection connection = dataSource.getConnection();){
            this.databaseType = dataSource != null ? DatabaseTypeRegister.getDatabaseTypeForConnection(connection) : null;
        }
        catch (SQLException e) {
            this.databaseType = null;
        }
    }

    public void setConnectRetries(int connectRetries) {
        if (connectRetries < 0) {
            throw new FlywayException("Invalid number of connectRetries (must be 0 or greater): " + connectRetries, ErrorCode.CONFIGURATION);
        }
        this.getCurrentUnresolvedEnvironment().setConnectRetries(connectRetries);
        this.resolvedEnvironments.clear();
    }

    public void setConnectRetriesInterval(int connectRetriesInterval) {
        if (connectRetriesInterval < 0) {
            throw new FlywayException("Invalid number for connectRetriesInterval (must be 0 or greater): " + connectRetriesInterval, ErrorCode.CONFIGURATION);
        }
        this.getCurrentUnresolvedEnvironment().setConnectRetriesInterval(connectRetriesInterval);
        this.resolvedEnvironments.clear();
    }

    public void setBaselineVersionAsString(String baselineVersion) {
        this.setBaselineVersion(baselineVersion);
    }

    public void setSkipExecutingMigrations(boolean skipExecutingMigrations) {
        this.getModernFlyway().setSkipExecutingMigrations(skipExecutingMigrations);
    }

    public void setCallbacks(Callback ... callbacks) {
        this.callbacks.clear();
        this.callbacks.addAll(Arrays.asList(callbacks));
    }

    public void setCallbacksAsClassNames(String ... callbacks) {
        this.getModernFlyway().setCallbacks(Arrays.stream(callbacks).collect(Collectors.toList()));
    }

    private void loadUnloadedCallbacks() {
        for (String callback : this.getModernFlyway().getCallbacks()) {
            List<Callback> newCallbacks = this.loadCallbackPath(callback);
            this.callbacks.addAll(newCallbacks.stream().filter(this::callbackNotLoadedYet).toList());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Callback> loadCallbackPath(String callbackPath) {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        Object o = null;
        try {
            o = ClassUtils.instantiate(callbackPath, this.classLoader);
        }
        catch (FlywayException flywayException) {
            // empty catch block
        }
        if (o != null) {
            if (!(o instanceof Callback)) throw new FlywayException("Invalid callback: " + callbackPath + " (must implement org.flywaydb.core.api.callback.Callback)", ErrorCode.CONFIGURATION);
            callbacks.add(o);
            return callbacks;
        } else {
            callbacks.addAll(this.loadCallbackLocation(callbackPath, true));
        }
        return callbacks;
    }

    private boolean callbackNotLoadedYet(Callback callback) {
        return this.callbacks.stream().noneMatch(c -> c.getClass().getCanonicalName().equals(callback.getClass().getCanonicalName()));
    }

    public List<Callback> loadCallbackLocation(String path, boolean errorOnNotFound) {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        List<String> callbackClasses = this.classScanner.scanForType(path, Callback.class, errorOnNotFound);
        for (String callback : callbackClasses) {
            Class<Callback> callbackClass;
            try {
                callbackClass = ClassUtils.loadClass(Callback.class, callback, this.classLoader);
            }
            catch (Throwable e) {
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                LOG.warn("Skipping " + Callback.class + ": " + ClassUtils.formatThrowable(e) + (String)(rootCause == e ? "" : " caused by " + ClassUtils.formatThrowable(rootCause) + " at " + ExceptionUtils.getThrowLocation(rootCause)));
                callbackClass = null;
            }
            if (callbackClass == null) continue;
            Callback callbackObj = (Callback)ClassUtils.instantiate(callback, this.classLoader);
            callbacks.add(callbackObj);
        }
        return callbacks;
    }

    public void setResolvers(MigrationResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    public void setResolversAsClassNames(String ... resolvers) {
        this.getModernFlyway().setMigrationResolvers(Arrays.stream(resolvers).collect(Collectors.toList()));
    }

    public void setKerberosConfigFile(String kerberosConfigFile) {
        throw new FlywayTeamsUpgradeRequiredException("kerberosConfigFile");
    }

    public void setShouldCreateSchemas(boolean createSchemas) {
        this.getModernFlyway().setCreateSchemas(createSchemas);
    }

    public void setOutputQueryResults(boolean outputQueryResults) {
        throw new FlywayTeamsUpgradeRequiredException("outputQueryResults");
    }

    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        this.getCurrentUnresolvedEnvironment().setJdbcProperties(jdbcProperties);
        this.resolvedEnvironments.clear();
    }

    public void configure(Configuration configuration) {
        this.setModernConfig(ConfigurationModel.clone(configuration.getModernConfig()));
        this.setWorkingDirectory(configuration.getWorkingDirectory());
        this.setJavaMigrations(configuration.getJavaMigrations());
        this.setResourceProvider(configuration.getResourceProvider());
        this.setJavaMigrationClassProvider(configuration.getJavaMigrationClassProvider());
        this.setCallbacks(configuration.getCallbacks());
        this.setResolvers((MigrationResolver[])configuration.getResolvers().clone());
        this.getModernFlyway().setMigrationResolvers(null);
        this.resolvedEnvironments.putAll(configuration.getCachedResolvedEnvironments());
        this.dataSource = configuration.getDataSource();
        this.databaseType = configuration.getDatabaseType();
        this.pluginRegister = configuration.getPluginRegister().getCopy();
        this.configureFromConfigurationProviders(this);
    }

    public void configure(Properties properties) {
        this.configure(ConfigUtils.propertiesToMap(properties));
    }

    public void setUrl(String url) {
        this.dataSource = null;
        this.getCurrentUnresolvedEnvironment().setUrl(url);
        this.databaseType = StringUtils.hasText(url) ? DatabaseTypeRegister.getDatabaseTypeForUrl(url) : null;
        this.resolvedEnvironments.clear();
        this.licenseGuardJdbcUrl(url);
    }

    public void setUser(String user) {
        this.dataSource = null;
        this.getCurrentUnresolvedEnvironment().setUser(user);
        this.resolvedEnvironments.clear();
    }

    public void setPassword(String password) {
        this.dataSource = null;
        this.getCurrentUnresolvedEnvironment().setPassword(password);
        this.resolvedEnvironments.clear();
    }

    public void setDriver(String driver) {
        this.dataSource = null;
        this.getCurrentUnresolvedEnvironment().setDriver(driver);
        this.resolvedEnvironments.clear();
    }

    public void configure(Map<String, String> props) {
        Boolean failOnMissingLocationsProp;
        String ignoreMigrationPatternsProp;
        String kerberosConfigFile;
        Boolean createSchemasProp;
        Boolean batchProp;
        Boolean streamProp;
        String errorOverridesProp;
        String dryRunOutputProp;
        String installedByProp;
        Boolean groupProp;
        Boolean skipDefaultCallbacksProp;
        String callbacksProp;
        Boolean skipDefaultResolversProp;
        String resolversProp;
        Boolean outputQueryResultsProp;
        Boolean skipExecutingMigrationsProp;
        Boolean outOfOrderProp;
        Integer lockRetryCount;
        String loggersProp;
        String targetProp;
        Boolean validateMigrationNamingProp;
        Boolean baselineOnMigrateProp;
        String baselineDescriptionProp;
        String baselineVersionProp;
        Boolean validateOnMigrateProp;
        Boolean reportEnabledProp;
        Boolean cleanDisabledProp;
        Boolean cleanOnValidationErrorProp;
        String tablespaceProp;
        String tableProp;
        String schemasProp;
        String defaultSchemaProp;
        Boolean executeInTransaction;
        Boolean detectEncoding;
        String encodingProp;
        String sqlMigrationSuffixesProp;
        String sqlMigrationSeparatorProp;
        String repeatableSqlMigrationPrefixProp;
        String sqlMigrationPrefixProp;
        String scriptPlaceholderSuffixProp;
        String scriptPlaceholderPrefixProp;
        String placeholderSeparatorProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        Boolean placeholderReplacementProp;
        String locationsProp;
        String outputType;
        String initSqlProp;
        Integer connectRetriesIntervalProp;
        Integer connectRetriesProp;
        String passwordProp;
        String userProp;
        String urlProp;
        String driverProp;
        HashMap<String, String> tempProps = new HashMap<String, String>(props);
        for (String key : props.keySet()) {
            if (!key.startsWith("environments.tempConfigEnvironment")) continue;
            tempProps.put(key.replace("environments.tempConfigEnvironment", "flyway"), props.get(key));
        }
        props = new HashMap<String, String>(tempProps);
        props.computeIfAbsent("flyway.reportFilename", k -> this.getModernConfig().getFlyway().getReportFilename());
        HashMap<String, Map<String, Object>> configExtensionsPropertyMap = new HashMap<String, Map<String, Object>>();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        String deprecatedNameSpace = "plugins";
        LinkedHashSet sortedEntrySet = new LinkedHashSet();
        sortedEntrySet.addAll(props.entrySet().stream().filter(r -> ((String)r.getKey()).contains("plugins")).collect(Collectors.toSet()));
        sortedEntrySet.addAll(props.entrySet().stream().filter(r -> !sortedEntrySet.contains(r)).collect(Collectors.toSet()));
        for (Map.Entry params : sortedEntrySet) {
            String text = (String)params.getKey();
            Matcher matcher = ANY_WORD_BETWEEN_TWO_DOTS_PATTERN.matcher(text);
            String rootNamespace = matcher.find() ? matcher.group(1) : "";
            List<ConfigurationExtension> configExtensions = this.pluginRegister.getPlugins(ConfigurationExtension.class).stream().filter(c -> c.getNamespace().isEmpty() || rootNamespace.equals(c.getNamespace()) || rootNamespace.equals("plugins")).collect(Collectors.toList());
            configExtensions.forEach(c -> {
                if (c.getNamespace().isEmpty()) {
                    String replaceNamespace = "flyway.plugins.";
                    String fixedKey = ((String)params.getKey()).replace(replaceNamespace, "");
                    ClassicConfiguration.parsePropertiesFromConfigExtension(configExtensionsPropertyMap, keysToRemove, params, fixedKey, c);
                }
            });
            configExtensions.forEach(c -> {
                Object replaceNamespace = "flyway.";
                if (StringUtils.hasText(rootNamespace) && !c.getNamespace().isEmpty()) {
                    replaceNamespace = "flyway." + rootNamespace + ".";
                }
                String fixedKey = ((String)params.getKey()).replace((CharSequence)replaceNamespace, "");
                ClassicConfiguration.parsePropertiesFromConfigExtension(configExtensionsPropertyMap, keysToRemove, params, fixedKey, c);
            });
        }
        this.determineKeysToRemoveAndRemoveFromProps(configExtensionsPropertyMap, keysToRemove, props);
        String reportFilenameProp = props.remove("flyway.reportFilename");
        if (reportFilenameProp != null) {
            this.setReportFilename(reportFilenameProp);
        }
        if ((driverProp = props.remove("flyway.driver")) != null) {
            this.setDriver(driverProp);
        }
        if ((urlProp = props.remove("flyway.url")) != null) {
            this.setUrl(urlProp);
        }
        if ((userProp = props.remove("flyway.user")) != null) {
            this.setUser(userProp);
        }
        if ((passwordProp = props.remove("flyway.password")) != null) {
            this.setPassword(passwordProp);
        }
        if ((connectRetriesProp = ConfigUtils.removeInteger(props, "flyway.connectRetries")) != null) {
            this.setConnectRetries(connectRetriesProp);
        }
        if ((connectRetriesIntervalProp = ConfigUtils.removeInteger(props, "flyway.connectRetriesInterval")) != null) {
            this.setConnectRetriesInterval(connectRetriesIntervalProp);
        }
        if ((initSqlProp = props.remove("flyway.initSql")) != null) {
            this.setInitSql(initSqlProp);
        }
        if ((outputType = props.remove("flyway.outputType")) != null) {
            this.getModernConfig().getFlyway().setOutputType(outputType);
        }
        if ((locationsProp = props.remove("flyway.locations")) != null) {
            this.setLocationsAsStrings(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((placeholderReplacementProp = ConfigUtils.removeBoolean(props, "flyway.placeholderReplacement")) != null) {
            this.setPlaceholderReplacement(placeholderReplacementProp);
        }
        if ((placeholderPrefixProp = props.remove("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = props.remove("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((placeholderSeparatorProp = props.remove("flyway.placeholderSeparator")) != null) {
            this.setPlaceholderSeparator(placeholderSeparatorProp);
        }
        if ((scriptPlaceholderPrefixProp = props.remove("flyway.scriptPlaceholderPrefix")) != null) {
            this.setScriptPlaceholderPrefix(scriptPlaceholderPrefixProp);
        }
        if ((scriptPlaceholderSuffixProp = props.remove("flyway.scriptPlaceholderSuffix")) != null) {
            this.setScriptPlaceholderSuffix(scriptPlaceholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = props.remove("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((repeatableSqlMigrationPrefixProp = props.remove("flyway.repeatableSqlMigrationPrefix")) != null) {
            this.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
        }
        if ((sqlMigrationSeparatorProp = props.remove("flyway.sqlMigrationSeparator")) != null) {
            this.setSqlMigrationSeparator(sqlMigrationSeparatorProp);
        }
        if ((sqlMigrationSuffixesProp = props.remove("flyway.sqlMigrationSuffixes")) != null) {
            this.setSqlMigrationSuffixes(StringUtils.tokenizeToStringArray(sqlMigrationSuffixesProp, ","));
        }
        if ((encodingProp = props.remove("flyway.encoding")) != null) {
            this.setEncodingAsString(encodingProp);
        }
        if ((detectEncoding = ConfigUtils.removeBoolean(props, "flyway.detectEncoding")) != null) {
            this.setDetectEncoding(detectEncoding);
        }
        if ((executeInTransaction = ConfigUtils.removeBoolean(props, "flyway.executeInTransaction")) != null) {
            this.setExecuteInTransaction(executeInTransaction);
        }
        if ((defaultSchemaProp = props.remove("flyway.defaultSchema")) != null) {
            this.setDefaultSchema(defaultSchemaProp);
        }
        if ((schemasProp = props.remove("flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = props.remove("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((tablespaceProp = props.remove("flyway.tablespace")) != null) {
            this.setTablespace(tablespaceProp);
        }
        if ((cleanOnValidationErrorProp = ConfigUtils.removeBoolean(props, "flyway.cleanOnValidationError")) != null) {
            this.setCleanOnValidationError(cleanOnValidationErrorProp);
        }
        if ((cleanDisabledProp = ConfigUtils.removeBoolean(props, "flyway.cleanDisabled")) != null) {
            this.setCleanDisabled(cleanDisabledProp);
        }
        if ((reportEnabledProp = ConfigUtils.removeBoolean(props, "flyway.reportEnabled")) != null) {
            this.setReportEnabled(reportEnabledProp);
        }
        if ((validateOnMigrateProp = ConfigUtils.removeBoolean(props, "flyway.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(validateOnMigrateProp);
        }
        if ((baselineVersionProp = props.remove("flyway.baselineVersion")) != null) {
            this.setBaselineVersion(baselineVersionProp);
        }
        if ((baselineDescriptionProp = props.remove("flyway.baselineDescription")) != null) {
            this.setBaselineDescription(baselineDescriptionProp);
        }
        if ((baselineOnMigrateProp = ConfigUtils.removeBoolean(props, "flyway.baselineOnMigrate")) != null) {
            this.setBaselineOnMigrate(baselineOnMigrateProp);
        }
        if ((validateMigrationNamingProp = ConfigUtils.removeBoolean(props, "flyway.validateMigrationNaming")) != null) {
            this.setValidateMigrationNaming(validateMigrationNamingProp);
        }
        if ((targetProp = props.remove("flyway.target")) != null) {
            this.setTargetAsString(targetProp);
        }
        if ((loggersProp = props.remove("flyway.loggers")) != null) {
            this.setLoggers(StringUtils.tokenizeToStringArray(loggersProp, ","));
        }
        if ((lockRetryCount = ConfigUtils.removeInteger(props, "flyway.lockRetryCount")) != null) {
            this.setLockRetryCount(lockRetryCount);
        }
        if ((outOfOrderProp = ConfigUtils.removeBoolean(props, "flyway.outOfOrder")) != null) {
            this.setOutOfOrder(outOfOrderProp);
        }
        if ((skipExecutingMigrationsProp = ConfigUtils.removeBoolean(props, "flyway.skipExecutingMigrations")) != null) {
            this.setSkipExecutingMigrations(skipExecutingMigrationsProp);
        }
        if ((outputQueryResultsProp = ConfigUtils.removeBoolean(props, "flyway.outputQueryResults")) != null) {
            this.setOutputQueryResults(outputQueryResultsProp);
        }
        if (StringUtils.hasLength(resolversProp = props.remove("flyway.resolvers"))) {
            this.setResolversAsClassNames(StringUtils.tokenizeToStringArray(resolversProp, ","));
        }
        if ((skipDefaultResolversProp = ConfigUtils.removeBoolean(props, "flyway.skipDefaultResolvers")) != null) {
            this.setSkipDefaultResolvers(skipDefaultResolversProp);
        }
        if (StringUtils.hasLength(callbacksProp = props.remove("flyway.callbacks"))) {
            this.setCallbacksAsClassNames(StringUtils.tokenizeToStringArray(callbacksProp, ","));
        }
        if ((skipDefaultCallbacksProp = ConfigUtils.removeBoolean(props, "flyway.skipDefaultCallbacks")) != null) {
            this.setSkipDefaultCallbacks(skipDefaultCallbacksProp);
        }
        Map<String, String> placeholdersFromProps = this.getPropertiesUnderNamespace(props, this.getPlaceholders(), "flyway.placeholders.");
        this.setPlaceholders(placeholdersFromProps);
        Boolean mixedProp = ConfigUtils.removeBoolean(props, "flyway.mixed");
        if (mixedProp != null) {
            this.setMixed(mixedProp);
        }
        if ((groupProp = ConfigUtils.removeBoolean(props, "flyway.group")) != null) {
            this.setGroup(groupProp);
        }
        if ((installedByProp = props.remove("flyway.installedBy")) != null) {
            this.setInstalledBy(installedByProp);
        }
        if ((dryRunOutputProp = props.remove("flyway.dryRunOutput")) != null) {
            this.setDryRunOutputAsFileName(dryRunOutputProp);
        }
        if ((errorOverridesProp = props.remove("flyway.errorOverrides")) != null) {
            this.setErrorOverrides(StringUtils.tokenizeToStringArray(errorOverridesProp, ","));
        }
        if ((streamProp = ConfigUtils.removeBoolean(props, "flyway.stream")) != null) {
            this.setStream(streamProp);
        }
        if ((batchProp = ConfigUtils.removeBoolean(props, "flyway.batch")) != null) {
            this.setBatch(batchProp);
        }
        if ((createSchemasProp = ConfigUtils.removeBoolean(props, "flyway.createSchemas")) != null) {
            this.setShouldCreateSchemas(createSchemasProp);
        }
        if ((kerberosConfigFile = props.remove("flyway.kerberosConfigFile")) != null) {
            this.setKerberosConfigFile(kerberosConfigFile);
        }
        if ((ignoreMigrationPatternsProp = props.remove("flyway.ignoreMigrationPatterns")) != null) {
            this.setIgnoreMigrationPatterns(StringUtils.tokenizeToStringArray(ignoreMigrationPatternsProp, ","));
        }
        if ((failOnMissingLocationsProp = ConfigUtils.removeBoolean(props, "flyway.failOnMissingLocations")) != null) {
            this.setFailOnMissingLocations(failOnMissingLocationsProp);
        }
        if (StringUtils.hasText(this.getCurrentResolvedEnvironment().getUrl()) && (this.dataSource == null || StringUtils.hasText(urlProp) || StringUtils.hasText(driverProp) || StringUtils.hasText(userProp) || StringUtils.hasText(passwordProp))) {
            Map jdbcProperties = Optional.ofNullable(this.getCurrentResolvedEnvironment().getJdbcProperties()).orElse(new HashMap());
            Map<String, String> jdbcPropertiesFromProps = this.getPropertiesUnderNamespace(props, this.getPlaceholders(), "flyway.jdbcProperties.");
            jdbcProperties.putAll(jdbcPropertiesFromProps);
            this.setDataSource(new DriverDataSource(this.classLoader, this.getCurrentResolvedEnvironment().getDriver(), this.getCurrentResolvedEnvironment().getUrl(), this.getCurrentResolvedEnvironment().getUser(), this.getCurrentResolvedEnvironment().getPassword(), this, jdbcProperties));
        }
        ConfigUtils.checkConfigurationForUnrecognisedProperties(props, "flyway.");
    }

    private static void parsePropertiesFromConfigExtension(HashMap<String, Map<String, Object>> configExtensionsPropertyMap, List<String> keysToRemove, Map.Entry<String, String> params, String fixedKey, ConfigurationExtension configExtension) {
        String rootKey;
        List fields = Arrays.stream(configExtension.getClass().getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        if (keysToRemove.contains(params.getKey()) && configExtension.isStub()) {
            return;
        }
        String string = rootKey = fixedKey.contains(".") ? fixedKey.substring(0, fixedKey.indexOf(".")) : fixedKey;
        if (fields.contains(rootKey)) {
            String[] value = params.getValue();
            if (!configExtensionsPropertyMap.containsKey(configExtension.getClass().toString())) {
                configExtensionsPropertyMap.put(configExtension.getClass().toString(), new HashMap());
            }
            if (fixedKey.contains(".")) {
                String[] path = fixedKey.split("\\.");
                Map<String, Object> currentConfigExtensionProperties = new HashMap();
                if (!configExtensionsPropertyMap.get(configExtension.getClass().toString()).containsKey(path[0])) {
                    configExtensionsPropertyMap.get(configExtension.getClass().toString()).put(path[0], currentConfigExtensionProperties);
                } else {
                    currentConfigExtensionProperties = (Map)configExtensionsPropertyMap.get(configExtension.getClass().toString()).get(path[0]);
                }
                ConfigurationExtension currentConfigExtension = configExtension;
                Field[] declaredFields = configExtension.getClass().getDeclaredFields();
                Field field = Arrays.stream(declaredFields).filter(f -> f.getName().equals(path[0])).findFirst().orElse(null);
                try {
                    currentConfigExtension = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    LOG.error("Failed to get configuration extension", e);
                }
                for (int i = 1; i < path.length; ++i) {
                    String currentPath = path[i];
                    try {
                        Field[] subFields = currentConfigExtension.getClass().getDeclaredFields();
                        field = Arrays.stream(subFields).filter(f -> f.getName().equals(currentPath)).findFirst().orElse(null);
                        if (field.getType() == List.class || field.getType() == String[].class) {
                            value = value.split(",");
                        } else {
                            currentConfigExtension = field.getType() == Boolean.class ? null : field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                    }
                    catch (Exception subFields) {
                        // empty catch block
                    }
                    if (i < path.length - 1) {
                        HashMap newValue = new HashMap();
                        currentConfigExtensionProperties.put(path[i], newValue);
                        currentConfigExtensionProperties = newValue;
                        continue;
                    }
                    currentConfigExtensionProperties.put(path[i], value);
                }
            } else {
                configExtensionsPropertyMap.get(configExtension.getClass().toString()).put(fixedKey, value);
            }
            keysToRemove.add(params.getKey());
        }
    }

    public void setFailOnMissingLocations(Boolean failOnMissingLocationsProp) {
        this.getModernFlyway().setFailOnMissingLocations(failOnMissingLocationsProp);
    }

    @Override
    public String getDriver() {
        return this.getCurrentResolvedEnvironment().getDriver();
    }

    public void setGroup(Boolean groupProp) {
        this.getModernFlyway().setGroup(groupProp);
    }

    public void setMixed(Boolean mixedProp) {
        this.getModernFlyway().setMixed(mixedProp);
    }

    public void setEncoding(Charset encoding) {
        this.getModernFlyway().setEncoding(encoding.name());
    }

    public void setPlaceholders(Map<String, String> placeholdersFromProps) {
        this.getModernFlyway().setPlaceholders(placeholdersFromProps);
    }

    public void setSkipDefaultCallbacks(Boolean skipDefaultCallbacksProp) {
        this.getModernFlyway().setSkipDefaultCallbacks(skipDefaultCallbacksProp);
    }

    public void setSkipDefaultResolvers(Boolean skipDefaultResolversProp) {
        this.getModernFlyway().setSkipDefaultResolvers(skipDefaultResolversProp);
    }

    public void setOutOfOrder(Boolean outOfOrderProp) {
        this.getModernFlyway().setOutOfOrder(outOfOrderProp);
    }

    public void setLockRetryCount(Integer lockRetryCount) {
        this.getModernFlyway().setLockRetryCount(lockRetryCount);
    }

    public void setValidateMigrationNaming(Boolean validateMigrationNamingProp) {
        this.getModernFlyway().setValidateMigrationNaming(validateMigrationNamingProp);
    }

    public void setBaselineOnMigrate(Boolean baselineOnMigrateProp) {
        this.getModernFlyway().setBaselineOnMigrate(baselineOnMigrateProp);
    }

    public void setBaselineDescription(String baselineDescriptionProp) {
        this.getModernFlyway().setBaselineDescription(baselineDescriptionProp);
    }

    public void setBaselineVersion(String baselineVersionProp) {
        this.getModernFlyway().setBaselineVersion(baselineVersionProp);
    }

    public void setBaselineVersion(MigrationVersion baselineVersion) {
        this.getModernFlyway().setBaselineVersion(baselineVersion.getVersion());
    }

    public void setValidateOnMigrate(Boolean validateOnMigrateProp) {
        this.getModernFlyway().setValidateOnMigrate(validateOnMigrateProp);
    }

    public void setCleanDisabled(Boolean cleanDisabledProp) {
        this.getModernFlyway().setCleanDisabled(cleanDisabledProp);
    }

    public void setReportEnabled(Boolean reportEnabled) {
        this.getModernFlyway().setReportEnabled(reportEnabled);
    }

    public void setCleanOnValidationError(Boolean cleanOnValidationErrorProp) {
        this.getModernFlyway().setCleanOnValidationError(cleanOnValidationErrorProp);
    }

    public void setTablespace(String tablespaceProp) {
        this.getModernFlyway().setTablespace(tablespaceProp);
    }

    public void setTable(String tableProp) {
        this.getModernFlyway().setTable(tableProp);
    }

    public void setSchemas(String[] tokenizeToStringArray) {
        List<String> schemas = Arrays.stream(tokenizeToStringArray).collect(Collectors.toList());
        this.getCurrentUnresolvedEnvironment().setSchemas(schemas);
        this.resolvedEnvironments.clear();
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefixProp) {
        this.getModernFlyway().setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
    }

    public void setPlaceholderReplacement(Boolean placeholderReplacementProp) {
        this.getModernFlyway().setPlaceholderReplacement(placeholderReplacementProp);
    }

    public void setInitSql(String initSqlProp) {
        this.getCurrentUnresolvedEnvironment().setInitSql(initSqlProp);
        this.resolvedEnvironments.clear();
    }

    private void licenseGuardJdbcUrl(String url) {
        if (!url.toLowerCase().startsWith("jdbc-secretsmanager:")) {
            return;
        }
    }

    private void determineKeysToRemoveAndRemoveFromProps(HashMap<String, Map<String, Object>> configExtensionsPropertyMap, List<String> keysToRemove, Map<String, String> props) {
        for (Map.Entry<String, Map<String, Object>> property : configExtensionsPropertyMap.entrySet()) {
            ConfigurationExtension cfg = this.pluginRegister.getPlugins(ConfigurationExtension.class).stream().filter(c -> c.getClass().toString().equals(property.getKey())).findFirst().orElse(null);
            if (cfg == null) continue;
            Map<String, Object> mpTmp = property.getValue();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                HashMap<String, String[]> mp = new HashMap<String, String[]>();
                for (Map.Entry<String, Object> entry : mpTmp.entrySet()) {
                    Field[] subFields = cfg.getClass().getDeclaredFields();
                    Field field = Arrays.stream(subFields).filter(f -> f.getName().equals(entry.getKey())).findFirst().orElse(null);
                    Object value = field.getType() == List.class || field.getType() == String[].class ? ((String)entry.getValue()).split(",") : entry.getValue();
                    mp.put(entry.getKey(), (String[])value);
                }
                ConfigurationExtension newConfigurationExtension = (ConfigurationExtension)objectMapper.convertValue(mp, cfg.getClass());
                MergeUtils.mergeModel(newConfigurationExtension, cfg);
            }
            catch (Exception e) {
                Matcher matcher = ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN.matcher(e.getMessage());
                if (!matcher.find()) continue;
                String errorProperty = matcher.group(1);
                List propsToRemove = keysToRemove.stream().filter(k -> k.endsWith(errorProperty)).collect(Collectors.toList());
                keysToRemove.removeAll(propsToRemove);
            }
        }
        props.keySet().removeAll(keysToRemove);
    }

    private void configureFromConfigurationProviders(ClassicConfiguration configuration) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (ConfigurationProvider configurationProvider : this.pluginRegister.getPlugins(ConfigurationProvider.class)) {
            ConfigurationExtension configurationExtension = (ConfigurationExtension)this.pluginRegister.getPlugin(configurationProvider.getConfigurationExtensionClass());
            try {
                config.putAll(configurationProvider.getConfiguration(configurationExtension, configuration));
            }
            catch (Exception e) {
                throw new FlywayException("Unable to read configuration from " + configurationProvider.getClass().getName() + ": " + e.getMessage());
            }
        }
        this.configure(config);
    }

    private Map<String, String> getPropertiesUnderNamespace(Map<String, String> properties, Map<String, String> current, String namespace) {
        Iterator<Map.Entry<String, String>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String propertyName = entry.getKey();
            if (!propertyName.startsWith(namespace) || propertyName.length() <= namespace.length()) continue;
            String placeholderName = propertyName.substring(namespace.length());
            String placeholderValue = entry.getValue();
            current.put(placeholderName, placeholderValue);
            iterator.remove();
        }
        return current;
    }

    public void configureUsingEnvVars() {
        this.configure(ConfigUtils.environmentVariablesToPropertyMap());
    }

    public void setTarget(MigrationVersion target) {
        if (target != null) {
            this.getModernFlyway().setTarget(target.getName());
        } else {
            this.getModernFlyway().setTarget("latest");
        }
    }

    public ProgressLogger createProgress(String operationName) {
        if (this.getModernFlyway().getOutputProgress().booleanValue() && "json".equalsIgnoreCase(this.getModernFlyway().getOutputType())) {
            return new ProgressLoggerJson(operationName);
        }
        return new ProgressLoggerEmpty();
    }

    @Override
    public ConfigurationModel getModernConfig() {
        return this.modernConfig;
    }

    public void setModernConfig(ConfigurationModel modernConfig) {
        this.modernConfig = modernConfig;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    @Override
    public ClassProvider<JavaMigration> getJavaMigrationClassProvider() {
        return this.javaMigrationClassProvider;
    }

    public void setJavaMigrationClassProvider(ClassProvider<JavaMigration> javaMigrationClassProvider) {
        this.javaMigrationClassProvider = javaMigrationClassProvider;
    }

    @Override
    public JavaMigration[] getJavaMigrations() {
        return this.javaMigrations;
    }

    @Override
    public PluginRegister getPluginRegister() {
        return this.pluginRegister;
    }

    public void setPluginRegister(PluginRegister pluginRegister) {
        this.pluginRegister = pluginRegister;
    }
}

