/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import org.flywaydb.core.api.FlywayException;

public class BooleanEvaluator {
    public static boolean evaluateExpression(String expression) {
        String[] expressions;
        while (expression.contains("(")) {
            String innermost = BooleanEvaluator.findInnermostBrackets(expression);
            expression = expression.replace("(" + innermost + ")", BooleanEvaluator.evaluateExpression(innermost) ? "true" : "false");
        }
        if (expression.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (expression.trim().equalsIgnoreCase("false")) {
            return false;
        }
        if (expression.contains("&&")) {
            expressions = expression.split("&&");
            return BooleanEvaluator.andAll(expressions);
        }
        if (expression.contains("||")) {
            expressions = expression.split("\\|\\|");
            return BooleanEvaluator.orAll(expressions);
        }
        if (expression.contains("!=")) {
            return !BooleanEvaluator.compareOperands("!=", expression);
        }
        if (expression.contains("==")) {
            return BooleanEvaluator.compareOperands("==", expression);
        }
        throw new FlywayException("Unable to parse expression: " + expression);
    }

    private static String findInnermostBrackets(String expression) {
        int openIndex = -1;
        for (int i = 0; i < expression.length(); ++i) {
            if (expression.charAt(i) == '(') {
                openIndex = i + 1;
            }
            if (expression.charAt(i) != ')') continue;
            if (openIndex == -1) {
                throw new FlywayException("Unable to parse expression: " + expression + " - unexpected )");
            }
            return expression.substring(openIndex, i);
        }
        throw new FlywayException("Unable to parse expression: " + expression + " - unexpected (");
    }

    private static boolean compareOperands(String operator, String expression) {
        String[] operands = expression.split(operator);
        if (operands.length != 2) {
            throw new FlywayException("Invalid boolean expression '" + expression + "'. ");
        }
        return operands[0].trim().equals(operands[1].trim());
    }

    private static boolean andAll(String[] expressions) {
        for (String expression : expressions) {
            if (BooleanEvaluator.evaluateExpression(expression)) continue;
            return false;
        }
        return true;
    }

    private static boolean orAll(String[] expressions) {
        for (String expression : expressions) {
            if (!BooleanEvaluator.evaluateExpression(expression)) continue;
            return true;
        }
        return false;
    }
}

