/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentProvisioner;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentProvisionerNone;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContextImpl;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;

public class EnvironmentResolver {
    private final Map<String, PropertyResolver> propertyResolvers;
    private final Map<String, EnvironmentProvisioner> environmentProvisioners;

    public EnvironmentResolver(Map<String, PropertyResolver> propertyResolvers, Map<String, EnvironmentProvisioner> environmentProvisioners) {
        this.propertyResolvers = propertyResolvers;
        this.environmentProvisioners = environmentProvisioners;
    }

    public ResolvedEnvironment resolve(String environmentName, EnvironmentModel environment, String workingDirectory, ProgressLogger progress) {
        return this.resolve(environmentName, environment, ProvisionerMode.Provision, workingDirectory, progress);
    }

    public ResolvedEnvironment resolve(String environmentName, EnvironmentModel environment, ProvisionerMode mode, String workingDirectory, ProgressLogger progress) {
        Map<String, Map<String, Object>> resolversToConfigure = environment.getResolvers();
        PropertyResolverContextImpl context = new PropertyResolverContextImpl(environmentName, workingDirectory, this.propertyResolvers, resolversToConfigure);
        ResolvedEnvironment result = new ResolvedEnvironment();
        result.setDriver(environment.getDriver());
        result.setConnectRetries(environment.getConnectRetries());
        result.setConnectRetriesInterval(environment.getConnectRetriesInterval());
        result.setInitSql(environment.getInitSql());
        result.setSchemas(environment.getSchemas());
        result.setJarDirs(environment.getJarDirs());
        progress.pushSteps(2);
        ProgressLogger provisionProgress = progress.subTask("provision");
        ProgressLogger resolveProgress = progress.subTask("resolve");
        EnvironmentProvisioner provisioner = this.getProvisioner(environment.getProvisioner(), context, provisionProgress);
        if (mode == ProvisionerMode.Provision) {
            progress.log("Provisioning environment " + environmentName + " with " + provisioner.getName());
            provisioner.preProvision(context, provisionProgress);
        } else if (mode == ProvisionerMode.Reprovision) {
            progress.log("Reprovisioning environment " + environmentName + " with " + provisioner.getName());
            provisioner.preReprovision(context, provisionProgress);
        }
        progress.log("Resolving environment properties " + environmentName);
        if (environment.getJdbcProperties() != null) {
            HashMap<String, String> jdbcResolvedProps = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : environment.getJdbcProperties().entrySet()) {
                jdbcResolvedProps.put(entry.getKey(), context.resolveValue(entry.getValue(), resolveProgress));
            }
            result.setJdbcProperties(jdbcResolvedProps);
        }
        result.setPassword(context.resolveValue(environment.getPassword(), resolveProgress));
        result.setUser(context.resolveValue(environment.getUser(), resolveProgress));
        result.setUrl(context.resolveValue(environment.getUrl(), resolveProgress));
        result.setToken(context.resolveValue(environment.getToken(), resolveProgress));
        if (mode == ProvisionerMode.Provision) {
            progress.log("Provisioning environment " + environmentName + " with " + provisioner.getName());
            provisioner.postProvision(context, result, provisionProgress);
        } else if (mode == ProvisionerMode.Reprovision) {
            progress.log("Reprovisioning environment " + environmentName + " with " + provisioner.getName());
            provisioner.postReprovision(context, result, provisionProgress);
        }
        return result;
    }

    private EnvironmentProvisioner getProvisioner(String provisionerName, PropertyResolverContext context, ProgressLogger progress) {
        String name = context.resolveValue(provisionerName, progress);
        if (name != null) {
            if (!this.environmentProvisioners.containsKey(provisionerName)) {
                throw new FlywayException("Unknown provisioner '" + provisionerName + "' for environment " + context.getEnvironmentName(), ErrorCode.CONFIGURATION);
            }
            return this.environmentProvisioners.get(provisionerName);
        }
        return new EnvironmentProvisionerNone();
    }
}

