/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;

public class PropertyResolverContextImpl
implements PropertyResolverContext {
    private final Map<String, PropertyResolver> resolvers;
    private final Map<String, Map<String, Object>> resolverProperties;
    private final String environmentName;
    private static final CharsetEncoder ASCII_ENCODER = StandardCharsets.US_ASCII.newEncoder();
    private static final Pattern RESOLVER_REGEX_PATTERN = Pattern.compile("\\${1,2}\\{[^.]+\\.[^.]+\\}");
    private static final Pattern VERBATIM_REGEX_PATTERN = Pattern.compile("\\!\\{.*\\}");

    public PropertyResolverContextImpl(String environmentName, Map<String, PropertyResolver> resolvers, Map<String, Map<String, Object>> resolverProperties) {
        this.environmentName = environmentName;
        this.resolvers = resolvers;
        this.resolverProperties = resolverProperties;
    }

    @Override
    public String resolvePropertyString(String resolverName, String propertyName) {
        if (this.resolverProperties == null) {
            return null;
        }
        Map<String, Object> properties = this.resolverProperties.get(resolverName);
        if (properties == null) {
            return null;
        }
        Object propertyValue = properties.get(propertyName);
        if (!(propertyValue instanceof String)) {
            return null;
        }
        return this.resolveValue((String)propertyValue);
    }

    @Override
    public List<String> resolvePropertyStringList(String resolverName, String propertyName) {
        if (this.resolverProperties == null) {
            return null;
        }
        Map<String, Object> properties = this.resolverProperties.get(resolverName);
        if (properties == null) {
            return null;
        }
        Object propertyValue = properties.get(propertyName);
        if (!(propertyValue instanceof List)) {
            return null;
        }
        return ((List)propertyValue).stream().filter(v -> v instanceof String).map(v -> this.resolveValue((String)v)).toList();
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public String resolveValue(String value) {
        if (value == null) {
            return null;
        }
        if (this.isVerbatim(value)) {
            return value.substring(2, value.length() - 1);
        }
        return RESOLVER_REGEX_PATTERN.matcher(value.strip()).replaceAll(this::parseResolverSyntax);
    }

    private boolean isVerbatim(String value) {
        return VERBATIM_REGEX_PATTERN.matcher(value.strip()).matches();
    }

    private String parseResolverSyntax(MatchResult resolverMatchResult) {
        String resolverMatch = resolverMatchResult.group();
        if (resolverMatch.startsWith("$$")) {
            return "\\" + resolverMatch.substring(1);
        }
        String resolverName = resolverMatch.substring(2, resolverMatch.indexOf(".")).strip();
        if (!this.resolvers.containsKey(resolverName)) {
            throw new FlywayException("Unknown resolver '" + resolverName + "' for environment " + this.environmentName, ErrorCode.CONFIGURATION);
        }
        if (resolverMatch.contains(":")) {
            String resolverParam = resolverMatch.substring(resolverMatch.indexOf(".") + 1, resolverMatch.indexOf(":")).strip();
            String filter = resolverMatch.substring(resolverMatch.indexOf(":") + 1, resolverMatch.length() - 1).strip();
            return PropertyResolverContextImpl.filter(this.resolvers.get(resolverName).resolve(resolverParam, this), filter);
        }
        String resolverParam = resolverMatch.substring(resolverMatch.indexOf(".") + 1, resolverMatch.length() - 1).strip();
        return this.resolvers.get(resolverName).resolve(resolverParam, this);
    }

    static String filter(String str, String filter) {
        return str.chars().filter(c -> PropertyResolverContextImpl.isAllowed((char)c, filter)).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static boolean isAllowed(char c, String filter) {
        return filter.contains("D") && Character.isDigit(c) || filter.contains("A") && Character.isLetter(c) || filter.contains("a") && Character.isLetter(c) && ASCII_ENCODER.canEncode(c) || filter.contains("d") && Character.isDigit(c) && ASCII_ENCODER.canEncode(c);
    }
}

