/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import java.util.HashMap;
import java.util.Map;
import org.flywaydb.core.api.ErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentProvisioner;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentProvisionerNone;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolverContextImpl;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;

public class EnvironmentResolver {
    private final Map<String, PropertyResolver> propertyResolvers;
    private final Map<String, EnvironmentProvisioner> environmentProvisioners;

    public EnvironmentResolver(Map<String, PropertyResolver> propertyResolvers, Map<String, EnvironmentProvisioner> environmentProvisioners) {
        this.propertyResolvers = propertyResolvers;
        this.environmentProvisioners = environmentProvisioners;
    }

    public ResolvedEnvironment resolve(String environmentName, EnvironmentModel environment) {
        return this.resolve(environmentName, environment, ProvisionerMode.Provision);
    }

    public ResolvedEnvironment resolve(String environmentName, EnvironmentModel environment, ProvisionerMode mode) {
        Map<String, Map<String, Object>> resolversToConfigure = environment.getResolvers();
        PropertyResolverContextImpl context = new PropertyResolverContextImpl(environmentName, this.propertyResolvers, resolversToConfigure);
        ResolvedEnvironment result = new ResolvedEnvironment();
        result.setDriver(environment.getDriver());
        result.setConnectRetries(environment.getConnectRetries());
        result.setConnectRetriesInterval(environment.getConnectRetriesInterval());
        result.setInitSql(environment.getInitSql());
        result.setSchemas(environment.getSchemas());
        result.setJarDirs(environment.getJarDirs());
        if (environment.getJdbcProperties() != null) {
            HashMap<String, String> jdbcResolvedProps = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : environment.getJdbcProperties().entrySet()) {
                jdbcResolvedProps.put(entry.getKey(), context.resolveValue(entry.getValue()));
            }
            result.setJdbcProperties(jdbcResolvedProps);
        }
        EnvironmentProvisioner provisioner = this.getProvisioner(environment.getProvisioner(), context);
        if (mode == ProvisionerMode.Provision) {
            provisioner.preProvision(context);
        } else if (mode == ProvisionerMode.Reprovision) {
            provisioner.preReprovision(context);
        }
        result.setPassword(context.resolveValue(environment.getPassword()));
        result.setUser(context.resolveValue(environment.getUser()));
        result.setUrl(context.resolveValue(environment.getUrl()));
        result.setToken(context.resolveValue(environment.getToken()));
        if (mode == ProvisionerMode.Provision) {
            provisioner.postProvision(context, result);
        } else if (mode == ProvisionerMode.Reprovision) {
            provisioner.postReprovision(context, result);
        }
        return result;
    }

    private EnvironmentProvisioner getProvisioner(String provisionerName, PropertyResolverContext context) {
        String name = context.resolveValue(provisionerName);
        if (name != null) {
            if (!this.environmentProvisioners.containsKey(provisionerName)) {
                throw new FlywayException("Unknown provisioner '" + provisionerName + "' for environment " + context.getEnvironmentName(), ErrorCode.CONFIGURATION);
            }
            return this.environmentProvisioners.get(provisionerName);
        }
        return new EnvironmentProvisionerNone();
    }
}

