/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.command.version;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.flywaydb.commandline.command.version.VersionResult;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.OperationResult;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.Pair;

public class VersionCommandExtension
implements CommandExtension {
    private static final Log LOG = LogFactory.getLog(VersionCommandExtension.class);
    public static final String VERSION = "version";
    public static final List<String> FLAGS = Arrays.asList("-v", "--version");

    public boolean handlesCommand(String command) {
        return command.equals(VERSION);
    }

    public String getCommandForFlag(String flag) {
        if (FLAGS.contains(flag.toLowerCase())) {
            return VERSION;
        }
        return super.getCommandForFlag(flag);
    }

    public boolean handlesParameter(String parameter) {
        return false;
    }

    public OperationResult handle(String command, Configuration config, List<String> flags) throws FlywayException {
        VersionPrinter.printVersionOnly();
        LOG.info("");
        LOG.debug("Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        LOG.debug(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "\n");
        return new VersionResult(VersionPrinter.getVersion(), command, VersionPrinter.EDITION);
    }

    public List<Pair<String, String>> getUsage() {
        return Collections.singletonList(Pair.of((Object)("version, " + String.join((CharSequence)", ", FLAGS)), (Object)"Print the Flyway version and edition"));
    }
}

