/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.utils;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.InfoOutput;
import org.flywaydb.core.extensibility.RgDomainChecker;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.StringUtils;

public class TelemetryUtils {
    public static RootTelemetryModel populateRootTelemetry(RootTelemetryModel rootTelemetryModel, Configuration configuration, boolean isRedgateEmployee) {
        ConfigurationModel modernConfig;
        rootTelemetryModel.setRedgateEmployee(isRedgateEmployee);
        if (configuration != null && (modernConfig = configuration.getModernConfig()) != null && StringUtils.hasText((String)modernConfig.getId())) {
            rootTelemetryModel.setProjectId(TelemetryUtils.hashProjectId(modernConfig.getId()));
        }
        return rootTelemetryModel;
    }

    static String hashProjectId(String projectId) {
        if (projectId == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(projectId.getBytes(StandardCharsets.UTF_8));
            byte[] hash = md.digest("fur".getBytes(StandardCharsets.UTF_8));
            BigInteger number = new BigInteger(1, hash);
            String result = number.toString(16);
            while (result.length() < 64) {
                result = "0" + result;
            }
            return result;
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
    }

    public static boolean isRedgateEmployee(PluginRegister pluginRegister, Configuration configuration) {
        RgDomainChecker domainChecker = (RgDomainChecker)pluginRegister.getPlugin(RgDomainChecker.class);
        if (domainChecker == null) {
            return false;
        }
        return domainChecker.isInDomain(configuration);
    }

    public static String getOldestMigration(List<InfoOutput> infos) {
        if (infos == null) {
            return "";
        }
        ArrayList migrationDates = new ArrayList();
        infos.stream().filter(output -> StringUtils.hasText((String)output.installedOnUTC)).forEach(output -> migrationDates.add(output.installedOnUTC));
        if (!migrationDates.isEmpty()) {
            migrationDates.sort(Comparator.naturalOrder());
            return (String)migrationDates.get(0);
        }
        return "";
    }

    private TelemetryUtils() {
    }
}

