/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.CommandLineConfigurationUtils;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.TomlUtils;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.MergeUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class ModernConfigurationManager
implements ConfigurationManager {
    private static final Pattern ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN = Pattern.compile("\"([^\"]*)\"");

    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        String configuredJarDirs;
        String workingDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : ClassUtils.getInstallDir(Main.class);
        List tomlFiles = ConfigUtils.getDefaultTomlConfigFileLocations((File)new File(ClassUtils.getInstallDir(Main.class)));
        tomlFiles.addAll(CommandLineConfigurationUtils.getTomlConfigFilePaths());
        tomlFiles.addAll(commandLineArguments.getConfigFiles().stream().map(File::new).collect(Collectors.toList()));
        List existingFiles = tomlFiles.stream().filter(File::exists).collect(Collectors.toList());
        ConfigurationModel config = TomlUtils.loadConfigurationFiles(existingFiles, (String)workingDirectory);
        ConfigurationModel commandLineArgumentsModel = TomlUtils.loadConfigurationFromCommandlineArgs(commandLineArguments.getConfiguration());
        ConfigurationModel environmentVariablesModel = TomlUtils.loadConfigurationFromEnvironment();
        config = config.merge(environmentVariablesModel).merge(commandLineArgumentsModel);
        if (commandLineArgumentsModel.getEnvironments().containsKey("tempConfigEnvironment") || environmentVariablesModel.getEnvironments().containsKey("tempConfigEnvironment")) {
            EnvironmentModel defaultEnv = (EnvironmentModel)config.getEnvironments().get(config.getFlyway().getEnvironment());
            if (environmentVariablesModel.getEnvironments().containsKey("tempConfigEnvironment")) {
                config.getEnvironments().put(config.getFlyway().getEnvironment(), defaultEnv.merge((EnvironmentModel)environmentVariablesModel.getEnvironments().get("tempConfigEnvironment")));
            }
            if (commandLineArgumentsModel.getEnvironments().containsKey("tempConfigEnvironment")) {
                config.getEnvironments().put(config.getFlyway().getEnvironment(), defaultEnv.merge((EnvironmentModel)commandLineArgumentsModel.getEnvironments().get("tempConfigEnvironment")));
            }
            config.getEnvironments().remove("tempConfigEnvironment");
        }
        config.getFlyway().getLocations().add("filesystem:" + new File(workingDirectory, "sql").getAbsolutePath());
        ArrayList<String> jarDirs = new ArrayList<String>();
        File jarDir = new File(workingDirectory, "jars");
        if (jarDir.exists()) {
            jarDirs.add(jarDir.getAbsolutePath());
        }
        if (StringUtils.hasText((String)(configuredJarDirs = commandLineArguments.getConfiguration().get("flyway.jarDirs")))) {
            jarDirs.addAll(StringUtils.tokenizeToStringCollection((String)configuredJarDirs.replace(File.pathSeparator, ","), (String)","));
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<File> jarFiles = new ArrayList<File>();
        jarFiles.addAll(CommandLineConfigurationUtils.getJdbcDriverJarFiles());
        jarFiles.addAll(CommandLineConfigurationUtils.getJavaMigrationJarFiles(jarDirs.toArray(new String[0])));
        if (!jarFiles.isEmpty()) {
            classLoader = ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)classLoader, jarFiles);
        }
        ClassicConfiguration cfg = new ClassicConfiguration(config);
        cfg.setClassLoader(classLoader);
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<String> missingParams = new ArrayList<String>();
        for (ConfigurationExtension configurationExtension : cfg.getPluginRegister().getPlugins(ConfigurationExtension.class)) {
            String namespace = configurationExtension.getNamespace();
            if (!config.getFlyway().getPluginConfigurations().containsKey(namespace)) continue;
            List fields = Arrays.stream(configurationExtension.getClass().getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
            Map<String, Object> values = (Map<String, Object>)config.getFlyway().getPluginConfigurations().get(namespace);
            values = values.entrySet().stream().filter(p -> fields.contains(p.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (String key : values.keySet()) {
                ((Map)config.getFlyway().getPluginConfigurations().get(namespace)).remove(key);
            }
            try {
                ConfigurationExtension newConfigurationExtension = (ConfigurationExtension)objectMapper.convertValue(values, configurationExtension.getClass());
                MergeUtils.mergeModel((Object)newConfigurationExtension, (Object)configurationExtension);
            }
            catch (IllegalArgumentException e) {
                Matcher matcher = ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN.matcher(e.getMessage());
                if (!matcher.find()) continue;
                missingParams.add(matcher.group(1));
            }
        }
        for (Map.Entry entry : config.getFlyway().getPluginConfigurations().entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map temp = (Map)entry.getValue();
                missingParams.addAll(temp.keySet());
                continue;
            }
            missingParams.add((String)entry.getKey());
        }
        if (!missingParams.isEmpty()) {
            throw new FlywayException("Unknown configuration parameters: " + missingParams.stream().collect(Collectors.joining(", ")));
        }
        return cfg;
    }
}

