/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.sqlserver;

import java.util.Map;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class SQLServerConfigurationExtension
implements ConfigurationExtension {
    private static final Log LOG = LogFactory.getLog(SQLServerConfigurationExtension.class);
    private static final String SQLSERVER_KERBEROS_LOGIN_FILE = "sqlserver.kerberos.login.file";
    private static final String KERBEROS_LOGIN_FILE = "flyway.plugins.sqlserver.kerberos.login.file";
    private static final String KERBEROS_LOGIN_FILE_DEPRECATED = "flyway.sqlServer.kerberosLoginFile";
    private String kerberosLoginFile;

    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        if (configuration.containsKey(KERBEROS_LOGIN_FILE_DEPRECATED)) {
            LOG.warn("The 'flyway.sqlServer.kerberosLoginFile' parameter has been deprecated, and will be replaced with 'flyway.plugins.sqlserver.kerberos.login.file'. Update your configuration to use the new names.");
            this.kerberosLoginFile = this.getProperty(configuration, KERBEROS_LOGIN_FILE_DEPRECATED, this.kerberosLoginFile);
        } else {
            this.kerberosLoginFile = this.getProperty(configuration, KERBEROS_LOGIN_FILE, this.kerberosLoginFile);
        }
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_PLUGINS_SQL_SERVER_KERBEROS_LOGIN_FILE": {
                return KERBEROS_LOGIN_FILE;
            }
            case "FLYWAY_SQL_SERVER_KERBEROS_LOGIN_FILE": {
                return KERBEROS_LOGIN_FILE_DEPRECATED;
            }
        }
        return null;
    }

    private String getProperty(Map<String, String> configuration, String key, String fallback) {
        String property = configuration.getOrDefault(key, fallback);
        configuration.remove(key);
        return property;
    }

    public String getKerberosLoginFile() {
        return this.kerberosLoginFile;
    }

    public void setKerberosLoginFile(String kerberosLoginFile) {
        this.kerberosLoginFile = kerberosLoginFile;
    }
}

