/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.cloud.grpc.GcpClientCall;
import com.google.cloud.grpc.GcpManagedChannelOptions;
import com.google.cloud.grpc.GcpMetricsConstants;
import com.google.cloud.grpc.proto.AffinityConfig;
import com.google.cloud.grpc.proto.ApiConfig;
import com.google.cloud.grpc.proto.MethodConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.opencensus.common.ToLongFunction;
import io.opencensus.metrics.DerivedLongCumulative;
import io.opencensus.metrics.DerivedLongGauge;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.MetricOptions;
import io.opencensus.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class GcpManagedChannel
extends ManagedChannel {
    private static final Logger logger = Logger.getLogger(GcpManagedChannel.class.getName());
    static final AtomicInteger channelPoolIndex = new AtomicInteger();
    private static final int DEFAULT_MAX_CHANNEL = 10;
    private static final int DEFAULT_MAX_STREAM = 100;
    private final ManagedChannelBuilder<?> delegateChannelBuilder;
    private final GcpManagedChannelOptions options;
    private final boolean fallbackEnabled;
    private final boolean unresponsiveDetectionEnabled;
    private final int unresponsiveMs;
    private final int unresponsiveDropCount;
    private int maxSize = 10;
    private int maxConcurrentStreamsLowWatermark = 100;
    @VisibleForTesting
    final Map<String, AffinityConfig> methodToAffinity = new HashMap<String, AffinityConfig>();
    @VisibleForTesting
    final Map<String, ChannelRef> affinityKeyToChannelRef = new ConcurrentHashMap<String, ChannelRef>();
    private final Map<Integer, Map<String, Integer>> fallbackMap = new ConcurrentHashMap<Integer, Map<String, Integer>>();
    @VisibleForTesting
    final List<ChannelRef> channelRefs = new CopyOnWriteArrayList<ChannelRef>();
    private MetricRegistry metricRegistry;
    private final List<LabelKey> labelKeys = new ArrayList<LabelKey>();
    private final List<LabelKey> labelKeysWithResult = new ArrayList<LabelKey>(Collections.singletonList(LabelKey.create((String)GcpMetricsConstants.RESULT_LABEL, (String)GcpMetricsConstants.RESULT_DESC)));
    private final List<LabelValue> labelValues = new ArrayList<LabelValue>();
    private final List<LabelValue> labelValuesSuccess = new ArrayList<LabelValue>(Collections.singletonList(LabelValue.create((String)GcpMetricsConstants.RESULT_SUCCESS)));
    private final List<LabelValue> labelValuesError = new ArrayList<LabelValue>(Collections.singletonList(LabelValue.create((String)GcpMetricsConstants.RESULT_ERROR)));
    private String metricPrefix;
    private final AtomicInteger readyChannels = new AtomicInteger();
    private int minReadyChannels = 0;
    private int maxReadyChannels = 0;
    private final AtomicLong numChannelConnect = new AtomicLong();
    private final AtomicLong numChannelDisconnect = new AtomicLong();
    private long minReadinessTime = 0L;
    private long maxReadinessTime = 0L;
    private final AtomicLong totalReadinessTime = new AtomicLong();
    private final AtomicLong readinessTimeOccurrences = new AtomicLong();
    private final AtomicInteger totalActiveStreams = new AtomicInteger();
    private int minActiveStreams = 0;
    private int maxActiveStreams = 0;
    private int minTotalActiveStreams = 0;
    private int maxTotalActiveStreams = 0;
    private long minOkCalls = 0L;
    private long maxOkCalls = 0L;
    private final AtomicLong totalOkCalls = new AtomicLong();
    private boolean minOkReported = false;
    private boolean maxOkReported = false;
    private long minErrCalls = 0L;
    private long maxErrCalls = 0L;
    private final AtomicLong totalErrCalls = new AtomicLong();
    private boolean minErrReported = false;
    private boolean maxErrReported = false;
    private int minAffinity = 0;
    private int maxAffinity = 0;
    private final AtomicInteger totalAffinityCount = new AtomicInteger();
    private final AtomicLong fallbacksSucceeded = new AtomicLong();
    private final AtomicLong fallbacksFailed = new AtomicLong();
    private final AtomicLong unresponsiveDetectionCount = new AtomicLong();
    private long minUnresponsiveMs = 0L;
    private long maxUnresponsiveMs = 0L;
    private long minUnresponsiveDrops = 0L;
    private long maxUnresponsiveDrops = 0L;

    public GcpManagedChannel(ManagedChannelBuilder<?> delegateChannelBuilder, ApiConfig apiConfig, int poolSize, GcpManagedChannelOptions options) {
        this.loadApiConfig(apiConfig);
        if (poolSize != 0) {
            this.maxSize = poolSize;
        }
        this.delegateChannelBuilder = delegateChannelBuilder;
        this.options = options;
        this.initOptions();
        if (options.getResiliencyOptions() != null) {
            this.fallbackEnabled = options.getResiliencyOptions().isNotReadyFallbackEnabled();
            this.unresponsiveDetectionEnabled = options.getResiliencyOptions().isUnresponsiveDetectionEnabled();
            this.unresponsiveMs = options.getResiliencyOptions().getUnresponsiveDetectionMs();
            this.unresponsiveDropCount = options.getResiliencyOptions().getUnresponsiveDetectionDroppedCount();
        } else {
            this.fallbackEnabled = false;
            this.unresponsiveDetectionEnabled = false;
            this.unresponsiveMs = 0;
            this.unresponsiveDropCount = 0;
        }
    }

    private void initOptions() {
        this.initMetrics();
    }

    private void initMetrics() {
        GcpManagedChannelOptions.GcpMetricsOptions metricsOptions = this.options.getMetricsOptions();
        if (metricsOptions == null) {
            logger.info("Metrics options are empty. Metrics disabled.");
            return;
        }
        if (metricsOptions.getMetricRegistry() == null) {
            logger.info("Metric registry is null. Metrics disabled.");
            return;
        }
        logger.info("Metrics enabled.");
        this.metricRegistry = metricsOptions.getMetricRegistry();
        this.labelKeys.addAll(metricsOptions.getLabelKeys());
        this.labelKeysWithResult.addAll(metricsOptions.getLabelKeys());
        this.labelValues.addAll(metricsOptions.getLabelValues());
        this.labelValuesSuccess.addAll(metricsOptions.getLabelValues());
        this.labelValuesError.addAll(metricsOptions.getLabelValues());
        LabelKey poolKey = LabelKey.create((String)GcpMetricsConstants.POOL_INDEX_LABEL, (String)GcpMetricsConstants.POOL_INDEX_DESC);
        this.labelKeys.add(poolKey);
        this.labelKeysWithResult.add(poolKey);
        LabelValue poolIndex = LabelValue.create((String)String.format("pool-%d", channelPoolIndex.incrementAndGet()));
        this.labelValues.add(poolIndex);
        this.labelValuesSuccess.add(poolIndex);
        this.labelValuesError.add(poolIndex);
        this.metricPrefix = metricsOptions.getNamePrefix();
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_READY_CHANNELS, "The minimum number of channels simultaneously in the READY state.", "1", this, GcpManagedChannel::reportMinReadyChannels);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_READY_CHANNELS, "The maximum number of channels simultaneously in the READY state.", "1", this, GcpManagedChannel::reportMaxReadyChannels);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_CHANNELS, "The maximum number of channels in the pool.", "1", this, GcpManagedChannel::reportMaxChannels);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_ALLOWED_CHANNELS, "The maximum number of channels allowed in the pool. (The poll max size)", "1", this, GcpManagedChannel::reportMaxAllowedChannels);
        this.createDerivedLongCumulativeTimeSeries(GcpMetricsConstants.METRIC_NUM_CHANNEL_DISCONNECT, "The number of disconnections (occurrences when a channel deviates from the READY state)", "1", this, GcpManagedChannel::reportNumChannelDisconnect);
        this.createDerivedLongCumulativeTimeSeries(GcpMetricsConstants.METRIC_NUM_CHANNEL_CONNECT, "The number of times when a channel reached the READY state.", "1", this, GcpManagedChannel::reportNumChannelConnect);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_CHANNEL_READINESS_TIME, "The minimum time it took to transition a channel to the READY state.", "us", this, GcpManagedChannel::reportMinReadinessTime);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_AVG_CHANNEL_READINESS_TIME, "The average time it took to transition a channel to the READY state.", "us", this, GcpManagedChannel::reportAvgReadinessTime);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_CHANNEL_READINESS_TIME, "The maximum time it took to transition a channel to the READY state.", "us", this, GcpManagedChannel::reportMaxReadinessTime);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_ACTIVE_STREAMS, "The minimum number of active streams on any channel.", "1", this, GcpManagedChannel::reportMinActiveStreams);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_ACTIVE_STREAMS, "The maximum number of active streams on any channel.", "1", this, GcpManagedChannel::reportMaxActiveStreams);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_TOTAL_ACTIVE_STREAMS, "The minimum total number of active streams across all channels.", "1", this, GcpManagedChannel::reportMinTotalActiveStreams);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_TOTAL_ACTIVE_STREAMS, "The maximum total number of active streams across all channels.", "1", this, GcpManagedChannel::reportMaxTotalActiveStreams);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_AFFINITY, "The minimum number of affinity count on any channel.", "1", this, GcpManagedChannel::reportMinAffinity);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_AFFINITY, "The maximum number of affinity count on any channel.", "1", this, GcpManagedChannel::reportMaxAffinity);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_NUM_AFFINITY, "The total number of affinity count across all channels.", "1", this, GcpManagedChannel::reportNumAffinity);
        this.createDerivedLongGaugeTimeSeriesWithResult(GcpMetricsConstants.METRIC_MIN_CALLS, "The minimum number of completed calls on any channel.", "1", this, GcpManagedChannel::reportMinOkCalls, GcpManagedChannel::reportMinErrCalls);
        this.createDerivedLongGaugeTimeSeriesWithResult(GcpMetricsConstants.METRIC_MAX_CALLS, "The maximum number of completed calls on any channel.", "1", this, GcpManagedChannel::reportMaxOkCalls, GcpManagedChannel::reportMaxErrCalls);
        this.createDerivedLongCumulativeTimeSeriesWithResult(GcpMetricsConstants.METRIC_NUM_CALLS_COMPLETED, "The number of calls completed across all channels.", "1", this, GcpManagedChannel::reportTotalOkCalls, GcpManagedChannel::reportTotalErrCalls);
        this.createDerivedLongCumulativeTimeSeriesWithResult(GcpMetricsConstants.METRIC_NUM_FALLBACKS, "The number of calls that had fallback to another channel.", "1", this, GcpManagedChannel::reportSucceededFallbacks, GcpManagedChannel::reportFailedFallbacks);
        this.createDerivedLongCumulativeTimeSeries(GcpMetricsConstants.METRIC_NUM_UNRESPONSIVE_DETECTIONS, "The number of unresponsive connections detected.", "1", this, GcpManagedChannel::reportUnresponsiveDetectionCount);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_UNRESPONSIVE_DETECTION_TIME, "The minimum time it took to detect an unresponsive connection.", "ms", this, GcpManagedChannel::reportMinUnresponsiveMs);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_UNRESPONSIVE_DETECTION_TIME, "The maximum time it took to detect an unresponsive connection.", "ms", this, GcpManagedChannel::reportMaxUnresponsiveMs);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MIN_UNRESPONSIVE_DROPPED_CALLS, "The minimum calls dropped before detection of an unresponsive connection.", "ms", this, GcpManagedChannel::reportMinUnresponsiveDrops);
        this.createDerivedLongGaugeTimeSeries(GcpMetricsConstants.METRIC_MAX_UNRESPONSIVE_DROPPED_CALLS, "The maximum calls dropped before detection of an unresponsive connection.", "ms", this, GcpManagedChannel::reportMaxUnresponsiveDrops);
    }

    private MetricOptions createMetricOptions(String description, List<LabelKey> labelKeys, String unit) {
        return MetricOptions.builder().setDescription(description).setLabelKeys(labelKeys).setUnit(unit).build();
    }

    private <T> void createDerivedLongGaugeTimeSeries(String name, String description, String unit, T obj, ToLongFunction<T> func) {
        String string = String.valueOf(this.metricPrefix);
        String string2 = String.valueOf(name);
        DerivedLongGauge metric = this.metricRegistry.addDerivedLongGauge(string2.length() != 0 ? string.concat(string2) : new String(string), this.createMetricOptions(description, this.labelKeys, unit));
        metric.removeTimeSeries(this.labelValues);
        metric.createTimeSeries(this.labelValues, obj, func);
    }

    private <T> void createDerivedLongGaugeTimeSeriesWithResult(String name, String description, String unit, T obj, ToLongFunction<T> funcSucc, ToLongFunction<T> funcErr) {
        String string = String.valueOf(this.metricPrefix);
        String string2 = String.valueOf(name);
        DerivedLongGauge metric = this.metricRegistry.addDerivedLongGauge(string2.length() != 0 ? string.concat(string2) : new String(string), this.createMetricOptions(description, this.labelKeysWithResult, unit));
        metric.removeTimeSeries(this.labelValuesSuccess);
        metric.createTimeSeries(this.labelValuesSuccess, obj, funcSucc);
        metric.removeTimeSeries(this.labelValuesError);
        metric.createTimeSeries(this.labelValuesError, obj, funcErr);
    }

    private <T> void createDerivedLongCumulativeTimeSeries(String name, String description, String unit, T obj, ToLongFunction<T> func) {
        String string = String.valueOf(this.metricPrefix);
        String string2 = String.valueOf(name);
        DerivedLongCumulative metric = this.metricRegistry.addDerivedLongCumulative(string2.length() != 0 ? string.concat(string2) : new String(string), this.createMetricOptions(description, this.labelKeys, unit));
        metric.removeTimeSeries(this.labelValues);
        metric.createTimeSeries(this.labelValues, obj, func);
    }

    private <T> void createDerivedLongCumulativeTimeSeriesWithResult(String name, String description, String unit, T obj, ToLongFunction<T> funcSucc, ToLongFunction<T> funcErr) {
        String string = String.valueOf(this.metricPrefix);
        String string2 = String.valueOf(name);
        DerivedLongCumulative metric = this.metricRegistry.addDerivedLongCumulative(string2.length() != 0 ? string.concat(string2) : new String(string), this.createMetricOptions(description, this.labelKeysWithResult, unit));
        metric.removeTimeSeries(this.labelValuesSuccess);
        metric.createTimeSeries(this.labelValuesSuccess, obj, funcSucc);
        metric.removeTimeSeries(this.labelValuesError);
        metric.createTimeSeries(this.labelValuesError, obj, funcErr);
    }

    private long reportMaxChannels() {
        return this.getNumberOfChannels();
    }

    private long reportMaxAllowedChannels() {
        return this.maxSize;
    }

    private long reportMinReadyChannels() {
        int value = this.minReadyChannels;
        this.minReadyChannels = this.readyChannels.get();
        return value;
    }

    private long reportMaxReadyChannels() {
        int value = this.maxReadyChannels;
        this.maxReadyChannels = this.readyChannels.get();
        return value;
    }

    private long reportNumChannelConnect() {
        return this.numChannelConnect.get();
    }

    private long reportNumChannelDisconnect() {
        return this.numChannelDisconnect.get();
    }

    private long reportMinReadinessTime() {
        long value = this.minReadinessTime;
        this.minReadinessTime = 0L;
        return value;
    }

    private long reportAvgReadinessTime() {
        long value = 0L;
        long total = this.totalReadinessTime.getAndSet(0L);
        long occ = this.readinessTimeOccurrences.getAndSet(0L);
        if (occ != 0L) {
            value = total / occ;
        }
        return value;
    }

    private long reportMaxReadinessTime() {
        long value = this.maxReadinessTime;
        this.maxReadinessTime = 0L;
        return value;
    }

    private int reportMinActiveStreams() {
        int value = this.minActiveStreams;
        this.minActiveStreams = this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).min().orElse(0);
        return value;
    }

    private int reportMaxActiveStreams() {
        int value = this.maxActiveStreams;
        this.maxActiveStreams = this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).max().orElse(0);
        return value;
    }

    private int reportMinTotalActiveStreams() {
        int value = this.minTotalActiveStreams;
        this.minTotalActiveStreams = this.totalActiveStreams.get();
        return value;
    }

    private int reportMaxTotalActiveStreams() {
        int value = this.maxTotalActiveStreams;
        this.maxTotalActiveStreams = this.totalActiveStreams.get();
        return value;
    }

    private int reportMinAffinity() {
        int value = this.minAffinity;
        this.minAffinity = this.channelRefs.stream().mapToInt(ChannelRef::getAffinityCount).min().orElse(0);
        return value;
    }

    private int reportMaxAffinity() {
        int value = this.maxAffinity;
        this.maxAffinity = this.channelRefs.stream().mapToInt(ChannelRef::getAffinityCount).max().orElse(0);
        return value;
    }

    private int reportNumAffinity() {
        return this.totalAffinityCount.get();
    }

    private synchronized long reportMinOkCalls() {
        this.minOkReported = true;
        this.calcMinMaxOkCalls();
        return this.minOkCalls;
    }

    private synchronized long reportMaxOkCalls() {
        this.maxOkReported = true;
        this.calcMinMaxOkCalls();
        return this.maxOkCalls;
    }

    private long reportTotalOkCalls() {
        return this.totalOkCalls.get();
    }

    private void calcMinMaxOkCalls() {
        if (this.minOkReported && this.maxOkReported) {
            this.minOkReported = false;
            this.maxOkReported = false;
            return;
        }
        LongSummaryStatistics stats = this.channelRefs.stream().mapToLong(ChannelRef::getAndResetOkCalls).summaryStatistics();
        this.minOkCalls = stats.getMin();
        this.maxOkCalls = stats.getMax();
    }

    private synchronized long reportMinErrCalls() {
        this.minErrReported = true;
        this.calcMinMaxErrCalls();
        return this.minErrCalls;
    }

    private synchronized long reportMaxErrCalls() {
        this.maxErrReported = true;
        this.calcMinMaxErrCalls();
        return this.maxErrCalls;
    }

    private long reportTotalErrCalls() {
        return this.totalErrCalls.get();
    }

    private void calcMinMaxErrCalls() {
        if (this.minErrReported && this.maxErrReported) {
            this.minErrReported = false;
            this.maxErrReported = false;
            return;
        }
        LongSummaryStatistics stats = this.channelRefs.stream().mapToLong(ChannelRef::getAndResetErrCalls).summaryStatistics();
        this.minErrCalls = stats.getMin();
        this.maxErrCalls = stats.getMax();
    }

    private long reportSucceededFallbacks() {
        return this.fallbacksSucceeded.get();
    }

    private long reportFailedFallbacks() {
        return this.fallbacksFailed.get();
    }

    private long reportUnresponsiveDetectionCount() {
        return this.unresponsiveDetectionCount.get();
    }

    private long reportMinUnresponsiveMs() {
        long value = this.minUnresponsiveMs;
        this.minUnresponsiveMs = 0L;
        return value;
    }

    private long reportMaxUnresponsiveMs() {
        long value = this.maxUnresponsiveMs;
        this.maxUnresponsiveMs = 0L;
        return value;
    }

    private long reportMinUnresponsiveDrops() {
        long value = this.minUnresponsiveDrops;
        this.minUnresponsiveDrops = 0L;
        return value;
    }

    private long reportMaxUnresponsiveDrops() {
        long value = this.maxUnresponsiveDrops;
        this.maxUnresponsiveDrops = 0L;
        return value;
    }

    private void incReadyChannels() {
        this.numChannelConnect.incrementAndGet();
        int newReady = this.readyChannels.incrementAndGet();
        if (this.maxReadyChannels < newReady) {
            this.maxReadyChannels = newReady;
        }
    }

    private void decReadyChannels() {
        this.numChannelDisconnect.incrementAndGet();
        int newReady = this.readyChannels.decrementAndGet();
        if (this.minReadyChannels > newReady) {
            this.minReadyChannels = newReady;
        }
    }

    private void saveReadinessTime(long readinessNanos) {
        long readinessTimeUs = readinessNanos / 1000L;
        if (this.minReadinessTime == 0L || readinessTimeUs < this.minReadinessTime) {
            this.minReadinessTime = readinessTimeUs;
        }
        if (readinessTimeUs > this.maxReadinessTime) {
            this.maxReadinessTime = readinessTimeUs;
        }
        this.totalReadinessTime.addAndGet(readinessTimeUs);
        this.readinessTimeOccurrences.incrementAndGet();
    }

    private void recordUnresponsiveDetection(long nanos, long dropCount) {
        this.unresponsiveDetectionCount.incrementAndGet();
        long ms = nanos / 1000000L;
        if (this.minUnresponsiveMs == 0L || this.minUnresponsiveMs > ms) {
            this.minUnresponsiveMs = ms;
        }
        if (this.maxUnresponsiveMs < ms) {
            this.maxUnresponsiveMs = ms;
        }
        if (this.minUnresponsiveDrops == 0L || this.minUnresponsiveDrops > dropCount) {
            this.minUnresponsiveDrops = dropCount;
        }
        if (this.maxUnresponsiveDrops < dropCount) {
            this.maxUnresponsiveDrops = dropCount;
        }
    }

    void processChannelStateChange(int channelId, ConnectivityState state) {
        if (!this.fallbackEnabled) {
            return;
        }
        if (state == ConnectivityState.READY || state == ConnectivityState.IDLE) {
            this.fallbackMap.remove(channelId);
            return;
        }
        this.fallbackMap.putIfAbsent(channelId, new ConcurrentHashMap());
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getNumberOfChannels() {
        return this.channelRefs.size();
    }

    public int getStreamsLowWatermark() {
        return this.maxConcurrentStreamsLowWatermark;
    }

    public int getMinActiveStreams() {
        return this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).min().orElse(0);
    }

    public int getMaxActiveStreams() {
        return this.channelRefs.stream().mapToInt(ChannelRef::getActiveStreamsCount).max().orElse(0);
    }

    protected ChannelRef getChannelRef(@Nullable String key) {
        if (key == null || key.isEmpty()) {
            return this.pickLeastBusyChannel();
        }
        ChannelRef mappedChannel = this.affinityKeyToChannelRef.get(key);
        if (mappedChannel == null || !this.fallbackEnabled) {
            return mappedChannel;
        }
        Map<String, Integer> tempMap = this.fallbackMap.get(mappedChannel.getId());
        if (tempMap == null) {
            return mappedChannel;
        }
        Integer channelId = tempMap.get(key);
        if (channelId != null && !this.fallbackMap.containsKey(channelId)) {
            this.fallbacksSucceeded.incrementAndGet();
            return this.channelRefs.get(channelId);
        }
        ChannelRef channelRef = this.pickLeastBusyChannel();
        if (!this.fallbackMap.containsKey(channelRef.getId()) && channelRef.getActiveStreamsCount() < 100) {
            this.fallbacksSucceeded.incrementAndGet();
            tempMap.put(key, channelRef.getId());
            return channelRef;
        }
        this.fallbacksFailed.incrementAndGet();
        if (channelId != null) {
            return this.channelRefs.get(channelId);
        }
        return mappedChannel;
    }

    private synchronized ChannelRef createNewChannel() {
        int size = this.channelRefs.size();
        ChannelRef channelRef = new ChannelRef(this.delegateChannelBuilder.build(), size);
        this.channelRefs.add(channelRef);
        return channelRef;
    }

    private ChannelRef pickLeastBusyChannel() {
        if (this.channelRefs.isEmpty()) {
            return this.createNewChannel();
        }
        ChannelRef channelCandidate = this.channelRefs.get(0);
        int minStreams = channelCandidate.getActiveStreamsCount();
        ChannelRef readyCandidate = null;
        int readyMinStreams = Integer.MAX_VALUE;
        for (ChannelRef channelRef : this.channelRefs) {
            int cnt = channelRef.getActiveStreamsCount();
            if (cnt < minStreams) {
                minStreams = cnt;
                channelCandidate = channelRef;
            }
            if (cnt >= readyMinStreams || this.fallbackMap.containsKey(channelRef.getId()) || channelRef.getActiveStreamsCount() >= 100) continue;
            readyMinStreams = cnt;
            readyCandidate = channelRef;
        }
        if (!this.fallbackEnabled) {
            if (this.channelRefs.size() < this.maxSize && minStreams >= this.maxConcurrentStreamsLowWatermark) {
                return this.createNewChannel();
            }
            return channelCandidate;
        }
        if (this.channelRefs.size() < this.maxSize && readyMinStreams >= this.maxConcurrentStreamsLowWatermark) {
            return this.createNewChannel();
        }
        if (readyCandidate != null) {
            return readyCandidate;
        }
        return channelCandidate;
    }

    public String authority() {
        if (!this.channelRefs.isEmpty()) {
            return this.channelRefs.get(0).getChannel().authority();
        }
        ManagedChannel channel = this.delegateChannelBuilder.build();
        String authority = channel.authority();
        channel.shutdownNow();
        return authority;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions) {
        AffinityConfig affinity = this.methodToAffinity.get(methodDescriptor.getFullMethodName());
        if (affinity == null) {
            return new GcpClientCall.SimpleGcpClientCall<ReqT, RespT>(this.getChannelRef(null), methodDescriptor, callOptions);
        }
        return new GcpClientCall<ReqT, RespT>(this, methodDescriptor, callOptions, affinity);
    }

    public ManagedChannel shutdownNow() {
        for (ChannelRef channelRef : this.channelRefs) {
            if (channelRef.getChannel().isTerminated()) continue;
            channelRef.getChannel().shutdownNow();
        }
        return this;
    }

    public ManagedChannel shutdown() {
        for (ChannelRef channelRef : this.channelRefs) {
            channelRef.getChannel().shutdown();
        }
        return this;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        for (ChannelRef channelRef : this.channelRefs) {
            if (channelRef.getChannel().isTerminated()) continue;
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            channelRef.getChannel().awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    public boolean isShutdown() {
        for (ChannelRef channelRef : this.channelRefs) {
            if (channelRef.getChannel().isShutdown()) continue;
            return false;
        }
        return true;
    }

    public boolean isTerminated() {
        for (ChannelRef channelRef : this.channelRefs) {
            if (channelRef.getChannel().isTerminated()) continue;
            return false;
        }
        return true;
    }

    public ConnectivityState getState(boolean requestConnection) {
        int ready = 0;
        int idle = 0;
        int connecting = 0;
        int transientFailure = 0;
        int shutdown = 0;
        for (ChannelRef channelRef : this.channelRefs) {
            ConnectivityState cur = channelRef.getChannel().getState(requestConnection);
            switch (cur) {
                case READY: {
                    ++ready;
                    break;
                }
                case SHUTDOWN: {
                    ++shutdown;
                    break;
                }
                case TRANSIENT_FAILURE: {
                    ++transientFailure;
                    break;
                }
                case CONNECTING: {
                    ++connecting;
                    break;
                }
                case IDLE: {
                    ++idle;
                }
            }
        }
        if (ready > 0) {
            return ConnectivityState.READY;
        }
        if (connecting > 0) {
            return ConnectivityState.CONNECTING;
        }
        if (transientFailure > 0) {
            return ConnectivityState.TRANSIENT_FAILURE;
        }
        if (idle > 0) {
            return ConnectivityState.IDLE;
        }
        if (shutdown > 0) {
            return ConnectivityState.SHUTDOWN;
        }
        return ConnectivityState.IDLE;
    }

    protected void bind(ChannelRef channelRef, List<String> affinityKeys) {
        if (channelRef == null || affinityKeys == null) {
            return;
        }
        for (String affinityKey : affinityKeys) {
            while (this.affinityKeyToChannelRef.putIfAbsent(affinityKey, channelRef) != null) {
                this.unbind(Collections.singletonList(affinityKey));
            }
            channelRef.affinityCountIncr();
        }
    }

    protected void unbind(List<String> affinityKeys) {
        if (affinityKeys == null) {
            return;
        }
        for (String affinityKey : affinityKeys) {
            ChannelRef channelRef = this.affinityKeyToChannelRef.remove(affinityKey);
            if (channelRef == null) continue;
            channelRef.affinityCountDecr();
        }
    }

    private void loadApiConfig(ApiConfig apiConfig) {
        int lowWatermark;
        if (apiConfig == null) {
            return;
        }
        if (apiConfig.getChannelPool().getMaxSize() > 0) {
            this.maxSize = apiConfig.getChannelPool().getMaxSize();
        }
        if ((lowWatermark = apiConfig.getChannelPool().getMaxConcurrentStreamsLowWatermark()) >= 0 && lowWatermark <= 100) {
            this.maxConcurrentStreamsLowWatermark = lowWatermark;
        }
        for (MethodConfig method : apiConfig.getMethodList()) {
            if (method.getAffinity().equals(AffinityConfig.getDefaultInstance())) continue;
            for (String methodName : method.getNameList()) {
                this.methodToAffinity.put(methodName, method.getAffinity());
            }
        }
    }

    @VisibleForTesting
    static List<String> getKeysFromMessage(MessageOrBuilder msg, String name) {
        int currentLength = name.indexOf(46);
        String currentName = name;
        if (currentLength != -1) {
            currentName = name.substring(0, currentLength);
        }
        ArrayList<String> keys = new ArrayList<String>();
        Map obs = msg.getAllFields();
        for (Map.Entry entry : obs.entrySet()) {
            List list;
            if (!((Descriptors.FieldDescriptor)entry.getKey()).getName().equals(currentName)) continue;
            if (currentLength == -1 && entry.getValue() instanceof String) {
                keys.add(entry.getValue().toString());
                continue;
            }
            if (currentLength != -1 && entry.getValue() instanceof MessageOrBuilder) {
                keys.addAll(GcpManagedChannel.getKeysFromMessage((MessageOrBuilder)entry.getValue(), name.substring(currentLength + 1)));
                continue;
            }
            if (currentLength == -1 || !(entry.getValue() instanceof List) || (list = (List)entry.getValue()).isEmpty() || !(list.get(0) instanceof MessageOrBuilder)) continue;
            for (Object item : list) {
                keys.addAll(GcpManagedChannel.getKeysFromMessage((MessageOrBuilder)item, name.substring(currentLength + 1)));
            }
        }
        return keys;
    }

    @Nullable
    protected <ReqT, RespT> List<String> checkKeys(Object message, boolean isReq, MethodDescriptor<ReqT, RespT> methodDescriptor) {
        if (!(message instanceof MessageOrBuilder)) {
            return null;
        }
        AffinityConfig affinity = this.methodToAffinity.get(methodDescriptor.getFullMethodName());
        if (affinity != null) {
            AffinityConfig.Command cmd = affinity.getCommand();
            String keyName = affinity.getAffinityKey();
            List<String> keys = GcpManagedChannel.getKeysFromMessage((MessageOrBuilder)message, keyName);
            if (isReq && (cmd == AffinityConfig.Command.UNBIND || cmd == AffinityConfig.Command.BOUND)) {
                if (keys.size() > 1) {
                    throw new IllegalStateException("Duplicate affinity key in the request message");
                }
                return keys;
            }
            if (!isReq && cmd == AffinityConfig.Command.BIND) {
                return keys;
            }
        }
        return null;
    }

    protected class ChannelRef {
        private final ManagedChannel delegate;
        private final int channelId;
        private final AtomicInteger affinityCount;
        private final AtomicInteger activeStreamsCount;
        private long lastResponseNanos = System.nanoTime();
        private final AtomicInteger deadlineExceededCount = new AtomicInteger();
        private final AtomicLong okCalls = new AtomicLong();
        private final AtomicLong errCalls = new AtomicLong();

        protected ChannelRef(ManagedChannel channel, int channelId) {
            this(channel, channelId, 0, 0);
        }

        protected ChannelRef(ManagedChannel channel, int channelId, int affinityCount, int activeStreamsCount) {
            this.delegate = channel;
            this.channelId = channelId;
            this.affinityCount = new AtomicInteger(affinityCount);
            this.activeStreamsCount = new AtomicInteger(activeStreamsCount);
            new ChannelStateMonitor(channel, channelId);
        }

        protected ManagedChannel getChannel() {
            return this.delegate;
        }

        protected int getId() {
            return this.channelId;
        }

        protected void affinityCountIncr() {
            this.affinityCount.incrementAndGet();
            GcpManagedChannel.this.totalAffinityCount.incrementAndGet();
        }

        protected void affinityCountDecr() {
            this.affinityCount.decrementAndGet();
            GcpManagedChannel.this.totalAffinityCount.decrementAndGet();
        }

        protected void activeStreamsCountIncr() {
            int actStreams = this.activeStreamsCount.incrementAndGet();
            if (GcpManagedChannel.this.maxActiveStreams < actStreams) {
                GcpManagedChannel.this.maxActiveStreams = actStreams;
            }
            int totalActStreams = GcpManagedChannel.this.totalActiveStreams.incrementAndGet();
            if (GcpManagedChannel.this.maxTotalActiveStreams < totalActStreams) {
                GcpManagedChannel.this.maxTotalActiveStreams = totalActStreams;
            }
        }

        protected void activeStreamsCountDecr(long startNanos, Status status, boolean fromClientSide) {
            int actStreams = this.activeStreamsCount.decrementAndGet();
            if (GcpManagedChannel.this.minActiveStreams > actStreams) {
                GcpManagedChannel.this.minActiveStreams = actStreams;
            }
            int totalActStreams = GcpManagedChannel.this.totalActiveStreams.decrementAndGet();
            if (GcpManagedChannel.this.minTotalActiveStreams > totalActStreams) {
                GcpManagedChannel.this.minTotalActiveStreams = totalActStreams;
            }
            if (status.isOk()) {
                this.okCalls.incrementAndGet();
                GcpManagedChannel.this.totalOkCalls.incrementAndGet();
            } else {
                this.errCalls.incrementAndGet();
                GcpManagedChannel.this.totalErrCalls.incrementAndGet();
            }
            if (GcpManagedChannel.this.unresponsiveDetectionEnabled) {
                this.detectUnresponsiveConnection(startNanos, status, fromClientSide);
            }
        }

        protected void messageReceived() {
            this.lastResponseNanos = System.nanoTime();
            this.deadlineExceededCount.set(0);
        }

        protected int getAffinityCount() {
            return this.affinityCount.get();
        }

        protected int getActiveStreamsCount() {
            return this.activeStreamsCount.get();
        }

        protected long getAndResetOkCalls() {
            return this.okCalls.getAndSet(0L);
        }

        protected long getAndResetErrCalls() {
            return this.errCalls.getAndSet(0L);
        }

        private void detectUnresponsiveConnection(long startNanos, Status status, boolean fromClientSide) {
            if (status.getCode().equals((Object)Status.Code.DEADLINE_EXCEEDED)) {
                if (startNanos < this.lastResponseNanos) {
                    return;
                }
                if (this.deadlineExceededCount.incrementAndGet() >= GcpManagedChannel.this.unresponsiveDropCount && this.unresponsiveTimingConditionMet()) {
                    this.maybeReconnectUnresponsive();
                }
                return;
            }
            if (!fromClientSide) {
                this.lastResponseNanos = System.nanoTime();
                this.deadlineExceededCount.set(0);
            }
        }

        private boolean unresponsiveTimingConditionMet() {
            return (System.nanoTime() - this.lastResponseNanos) / 1000000L >= (long)GcpManagedChannel.this.unresponsiveMs;
        }

        private synchronized void maybeReconnectUnresponsive() {
            if (this.deadlineExceededCount.get() >= GcpManagedChannel.this.unresponsiveDropCount && this.unresponsiveTimingConditionMet()) {
                GcpManagedChannel.this.recordUnresponsiveDetection(System.nanoTime() - this.lastResponseNanos, this.deadlineExceededCount.get());
                this.delegate.enterIdle();
                this.lastResponseNanos = System.nanoTime();
                this.deadlineExceededCount.set(0);
            }
        }
    }

    private class ChannelStateMonitor
    implements Runnable {
        private final int channelId;
        private final ManagedChannel channel;
        private ConnectivityState currentState;
        private long connectingStartNanos;

        private ChannelStateMonitor(ManagedChannel channel, int channelId) {
            this.channelId = channelId;
            this.channel = channel;
            this.run();
        }

        @Override
        public void run() {
            if (this.channel == null) {
                return;
            }
            ConnectivityState newState = this.channel.getState(false);
            if (newState == ConnectivityState.READY && this.currentState != ConnectivityState.READY) {
                GcpManagedChannel.this.incReadyChannels();
                GcpManagedChannel.this.saveReadinessTime(System.nanoTime() - this.connectingStartNanos);
            }
            if (newState != ConnectivityState.READY && this.currentState == ConnectivityState.READY) {
                GcpManagedChannel.this.decReadyChannels();
            }
            if (newState == ConnectivityState.CONNECTING && this.currentState != ConnectivityState.CONNECTING) {
                this.connectingStartNanos = System.nanoTime();
            }
            this.currentState = newState;
            GcpManagedChannel.this.processChannelStateChange(this.channelId, newState);
            if (newState != ConnectivityState.SHUTDOWN) {
                this.channel.notifyWhenStateChanged(newState, (Runnable)this);
            }
        }
    }
}

