/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.auth.Credentials;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.oauth2.UserCredentials;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.jdbc.AbstractJdbcWrapper;
import com.google.cloud.spanner.jdbc.JdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcDriver;
import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcPreparedStatement;
import com.google.cloud.spanner.jdbc.JdbcResultSet;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Scanner;

class JdbcDatabaseMetaData
extends AbstractJdbcWrapper
implements DatabaseMetaData {
    private static final int JDBC_MAJOR_VERSION = 4;
    private static final int JDBC_MINOR_VERSION = 1;
    private static final int DATABASE_MAJOR_VERSION = 1;
    private static final int DATABASE_MINOR_VERSION = 0;
    private static final String PRODUCT_NAME = "Google Cloud Spanner";
    private final JdbcConnection connection;
    static final int MAX_CLIENT_INFO_VALUE_LENGTH = 63;

    @VisibleForTesting
    static String readSqlFromFile(String filename) {
        InputStream in = JdbcDatabaseMetaData.class.getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder builder = new StringBuilder();
        try (Scanner scanner = new Scanner(reader);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                builder.append(line).append("\n");
            }
        }
        return builder.toString();
    }

    JdbcDatabaseMetaData(JdbcConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() {
        return this.connection.getConnectionUrl();
    }

    @Override
    public String getUserName() {
        Credentials credentials = this.connection.getConnectionOptions().getCredentials();
        if (credentials != null) {
            if (credentials instanceof ServiceAccountSigner) {
                return ((ServiceAccountSigner)credentials).getAccount();
            }
            if (credentials instanceof UserCredentials) {
                return ((UserCredentials)credentials).getClientId();
            }
        }
        return "";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.getDatabaseMajorVersion() + "." + this.getDatabaseMinorVersion();
    }

    @Override
    public String getDriverName() {
        return JdbcDriver.class.getName();
    }

    @Override
    public String getDriverVersion() {
        return this.getDriverMajorVersion() + "." + this.getDriverMinorVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return 2;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public String getSQLKeywords() {
        return "ASSERT_ROWS_MODIFIED,ENUM,GROUPS,HASH,IGNORE,LOOKUP,PROTO,RESPECT,STRUCT,WINDOW";
    }

    @Override
    public String getNumericFunctions() {
        return "ABS,SIGN,IS_INF,IS_NAN,IEEE_DIVIDE,SQRT,POW,POWER,EXP,LN,LOG,LOG10,GREATEST,LEAST,DIV,MOD,ROUND,TRUNC,CEIL,CEILING,FLOOR,COS,COSH,ACOS,ACOSH,SIN,SINH,ASIN,ASINH,TAN,TANH,ATAN,ATANH,ATAN2,FARM_FINGERPRINT,SHA1,SHA256,SHA512";
    }

    @Override
    public String getStringFunctions() {
        return "BYTE_LENGTH,CHAR_LENGTH,CHARACTER_LENGTH,CODE_POINTS_TO_BYTES,CODE_POINTS_TO_STRING,CONCAT,ENDS_WITH,FORMAT,FROM_BASE64,FROM_HEX,LENGTH,LPAD,LOWER,LTRIM,REGEXP_CONTAINS,REGEXP_EXTRACT,REGEXP_EXTRACT_ALL,REGEXP_REPLACE,REPLACE,REPEAT,REVERSE,RPAD,RTRIM,SAFE_CONVERT_BYTES_TO_STRING,SPLIT,STARTS_WITH,STRPOS,SUBSTR,TO_BASE64,TO_CODE_POINTS,TO_HEX,TRIM,UPPER,JSON_QUERY,JSON_VALUE";
    }

    @Override
    public String getSystemFunctions() {
        return "";
    }

    @Override
    public String getTimeDateFunctions() {
        return "CURRENT_DATE,EXTRACT,DATE,DATE_ADD,DATE_SUB,DATE_DIFF,DATE_TRUNC,DATE_FROM_UNIX_DATE,FORMAT_DATE,PARSE_DATE,UNIX_DATE,CURRENT_TIMESTAMP,STRING,TIMESTAMP,TIMESTAMP_ADD,TIMESTAMP_SUB,TIMESTAMP_DIFF,TIMESTAMP_TRUNC,FORMAT_TIMESTAMP,PARSE_TIMESTAMP,TIMESTAMP_SECONDS,TIMESTAMP_MILLIS,TIMESTAMP_MICROS,UNIX_SECONDS,UNIX_MILLIS,UNIX_MICROS";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "SCHEMA";
    }

    @Override
    public String getProcedureTerm() {
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() {
        return "CATALOG";
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 1000;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 16;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 1024;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 8000;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 1000000;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 8;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return 8 == level;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return true;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"PROCEDURE_CAT", (Type)Type.string()), Type.StructField.of((String)"PROCEDURE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"PROCEDURE_NAME", (Type)Type.string()), Type.StructField.of((String)"reserved1", (Type)Type.string()), Type.StructField.of((String)"reserved2", (Type)Type.string()), Type.StructField.of((String)"reserved3", (Type)Type.string()), Type.StructField.of((String)"REMARKS", (Type)Type.string()), Type.StructField.of((String)"PROCEDURE_TYPE", (Type)Type.int64()), Type.StructField.of((String)"SPECIFIC_NAME", (Type)Type.string())}), Collections.emptyList()));
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"PROCEDURE_CAT", (Type)Type.string()), Type.StructField.of((String)"PROCEDURE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"PROCEDURE_NAME", (Type)Type.string()), Type.StructField.of((String)"COLUMN_NAME", (Type)Type.string()), Type.StructField.of((String)"COLUMN_TYPE", (Type)Type.int64()), Type.StructField.of((String)"DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"PRECISION", (Type)Type.string()), Type.StructField.of((String)"LENGTH", (Type)Type.int64()), Type.StructField.of((String)"SCALE", (Type)Type.int64()), Type.StructField.of((String)"RADIX", (Type)Type.int64()), Type.StructField.of((String)"NULLABLE", (Type)Type.int64()), Type.StructField.of((String)"REMARKS", (Type)Type.string()), Type.StructField.of((String)"COLUMN_DEF", (Type)Type.string()), Type.StructField.of((String)"SQL_DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"SQL_DATETIME_SUB", (Type)Type.int64()), Type.StructField.of((String)"CHAR_OCTET_LENGTH", (Type)Type.int64()), Type.StructField.of((String)"ORDINAL_POSITION", (Type)Type.int64()), Type.StructField.of((String)"IS_NULLABLE", (Type)Type.string()), Type.StructField.of((String)"SPECIFIC_NAME", (Type)Type.string())}), Collections.emptyList()));
    }

    private JdbcPreparedStatement prepareStatementReplaceNullWithAnyString(String sql, String ... params) throws SQLException {
        JdbcPreparedStatement statement = this.connection.prepareStatement(sql);
        int paramIndex = 1;
        for (String param : params) {
            if (param == null) {
                statement.setString(paramIndex, "%");
            } else {
                statement.setString(paramIndex, param.toUpperCase());
            }
            ++paramIndex;
        }
        return statement;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String type2;
        String type1;
        String sql = JdbcDatabaseMetaData.readSqlFromFile("DatabaseMetaData_GetTables.sql");
        if (types == null || types.length == 0) {
            type1 = "TABLE";
            type2 = "VIEW";
        } else if (types.length == 1) {
            type1 = types[0];
            type2 = "NON_EXISTENT_TYPE";
        } else {
            type1 = types[0];
            type2 = types[1];
        }
        JdbcPreparedStatement statement = this.prepareStatementReplaceNullWithAnyString(sql, catalog, schemaPattern, tableNamePattern, type1, type2);
        return statement.executeQueryWithOptions(new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TABLE_CAT", (Type)Type.string())}), Collections.singletonList(((Struct.Builder)Struct.newBuilder().set("TABLE_CAT").to("")).build())));
    }

    @Override
    public ResultSet getTableTypes() {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TABLE_TYPE", (Type)Type.string())}), Arrays.asList(((Struct.Builder)Struct.newBuilder().set("TABLE_TYPE").to("TABLE")).build(), ((Struct.Builder)Struct.newBuilder().set("TABLE_TYPE").to("VIEW")).build())));
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String sql = JdbcDatabaseMetaData.readSqlFromFile("DatabaseMetaData_GetColumns.sql");
        JdbcPreparedStatement statement = this.prepareStatementReplaceNullWithAnyString(sql, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        return statement.executeQueryWithOptions(new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TABLE_CAT", (Type)Type.string()), Type.StructField.of((String)"TABLE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"TABLE_NAME", (Type)Type.string()), Type.StructField.of((String)"COLUMN_NAME", (Type)Type.string()), Type.StructField.of((String)"GRANTOR", (Type)Type.string()), Type.StructField.of((String)"GRANTEE", (Type)Type.string()), Type.StructField.of((String)"PRIVILEGE", (Type)Type.string()), Type.StructField.of((String)"IS_GRANTABLE", (Type)Type.string())}), Collections.emptyList()));
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TABLE_CAT", (Type)Type.string()), Type.StructField.of((String)"TABLE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"TABLE_NAME", (Type)Type.string()), Type.StructField.of((String)"GRANTOR", (Type)Type.string()), Type.StructField.of((String)"GRANTEE", (Type)Type.string()), Type.StructField.of((String)"PRIVILEGE", (Type)Type.string()), Type.StructField.of((String)"IS_GRANTABLE", (Type)Type.string())}), Collections.emptyList()));
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return this.getEmptyColumnsResultSet();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        return this.getEmptyColumnsResultSet();
    }

    private ResultSet getEmptyColumnsResultSet() {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"SCOPE", (Type)Type.int64()), Type.StructField.of((String)"COLUMN_NAME", (Type)Type.string()), Type.StructField.of((String)"DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"COLUMN_SIZE", (Type)Type.int64()), Type.StructField.of((String)"BUFFER_LENGTH", (Type)Type.int64()), Type.StructField.of((String)"DECIMAL_DIGITS", (Type)Type.int64()), Type.StructField.of((String)"PSEUDO_COLUMN", (Type)Type.int64())}), Collections.emptyList()));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        JdbcPreconditions.checkArgument(table != null, "table may not be null");
        String sql = JdbcDatabaseMetaData.readSqlFromFile("DatabaseMetaData_GetPrimaryKeys.sql");
        JdbcPreparedStatement statement = this.prepareStatementReplaceNullWithAnyString(sql, catalog, schema, table);
        return statement.executeQueryWithOptions(new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        JdbcPreconditions.checkArgument(table != null, "table may not be null");
        String sql = JdbcDatabaseMetaData.readSqlFromFile("DatabaseMetaData_GetImportedKeys.sql");
        JdbcPreparedStatement statement = this.prepareStatementReplaceNullWithAnyString(sql, catalog, schema, table);
        return statement.executeQueryWithOptions(new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        JdbcPreconditions.checkArgument(table != null, "table may not be null");
        String sql = JdbcDatabaseMetaData.readSqlFromFile("DatabaseMetaData_GetExportedKeys.sql");
        JdbcPreparedStatement statement = this.prepareStatementReplaceNullWithAnyString(sql, catalog, schema, table);
        return statement.executeQueryWithOptions(new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String sql = JdbcDatabaseMetaData.readSqlFromFile("DatabaseMetaData_GetCrossReferences.sql");
        JdbcPreparedStatement statement = this.prepareStatementReplaceNullWithAnyString(sql, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        return statement.executeQueryWithOptions(new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});
    }

    @Override
    public ResultSet getTypeInfo() {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"PRECISION", (Type)Type.int64()), Type.StructField.of((String)"LITERAL_PREFIX", (Type)Type.string()), Type.StructField.of((String)"LITERAL_SUFFIX", (Type)Type.string()), Type.StructField.of((String)"CREATE_PARAMS", (Type)Type.string()), Type.StructField.of((String)"NULLABLE", (Type)Type.int64()), Type.StructField.of((String)"CASE_SENSITIVE", (Type)Type.bool()), Type.StructField.of((String)"SEARCHABLE", (Type)Type.int64()), Type.StructField.of((String)"UNSIGNED_ATTRIBUTE", (Type)Type.bool()), Type.StructField.of((String)"FIXED_PREC_SCALE", (Type)Type.bool()), Type.StructField.of((String)"AUTO_INCREMENT", (Type)Type.bool()), Type.StructField.of((String)"LOCAL_TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"MINIMUM_SCALE", (Type)Type.int64()), Type.StructField.of((String)"MAXIMUM_SCALE", (Type)Type.int64()), Type.StructField.of((String)"SQL_DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"SQL_DATETIME_SUB", (Type)Type.int64()), Type.StructField.of((String)"NUM_PREC_RADIX", (Type)Type.int64())}), Arrays.asList(((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("TYPE_NAME").to("STRING")).set("DATA_TYPE").to(-9L)).set("PRECISION").to(0x280000L)).set("LITERAL_PREFIX").to((String)null)).set("LITERAL_SUFFIX").to((String)null)).set("CREATE_PARAMS").to("(length)")).set("NULLABLE").to(1L)).set("CASE_SENSITIVE").to(true)).set("SEARCHABLE").to(3L)).set("UNSIGNED_ATTRIBUTE").to(true)).set("FIXED_PREC_SCALE").to(false)).set("AUTO_INCREMENT").to(false)).set("LOCAL_TYPE_NAME").to("STRING")).set("MINIMUM_SCALE").to(0L)).set("MAXIMUM_SCALE").to(0L)).set("SQL_DATA_TYPE").to((Long)null)).set("SQL_DATETIME_SUB").to((Long)null)).set("NUM_PREC_RADIX").to((Long)null)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("TYPE_NAME").to("INT64")).set("DATA_TYPE").to(-5L)).set("PRECISION").to(19L)).set("LITERAL_PREFIX").to((String)null)).set("LITERAL_SUFFIX").to((String)null)).set("CREATE_PARAMS").to((String)null)).set("NULLABLE").to(1L)).set("CASE_SENSITIVE").to(false)).set("SEARCHABLE").to(2L)).set("UNSIGNED_ATTRIBUTE").to(false)).set("FIXED_PREC_SCALE").to(false)).set("AUTO_INCREMENT").to(false)).set("LOCAL_TYPE_NAME").to("INT64")).set("MINIMUM_SCALE").to(0L)).set("MAXIMUM_SCALE").to(0L)).set("SQL_DATA_TYPE").to((Long)null)).set("SQL_DATETIME_SUB").to((Long)null)).set("NUM_PREC_RADIX").to(10L)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("TYPE_NAME").to("BYTES")).set("DATA_TYPE").to(-2L)).set("PRECISION").to(0xA00000L)).set("LITERAL_PREFIX").to((String)null)).set("LITERAL_SUFFIX").to((String)null)).set("CREATE_PARAMS").to("(length)")).set("NULLABLE").to(1L)).set("CASE_SENSITIVE").to(false)).set("SEARCHABLE").to(2L)).set("UNSIGNED_ATTRIBUTE").to(true)).set("FIXED_PREC_SCALE").to(false)).set("AUTO_INCREMENT").to(false)).set("LOCAL_TYPE_NAME").to("BYTES")).set("MINIMUM_SCALE").to(0L)).set("MAXIMUM_SCALE").to(0L)).set("SQL_DATA_TYPE").to((Long)null)).set("SQL_DATETIME_SUB").to((Long)null)).set("NUM_PREC_RADIX").to((Long)null)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("TYPE_NAME").to("FLOAT64")).set("DATA_TYPE").to(8L)).set("PRECISION").to(15L)).set("LITERAL_PREFIX").to((String)null)).set("LITERAL_SUFFIX").to((String)null)).set("CREATE_PARAMS").to((String)null)).set("NULLABLE").to(1L)).set("CASE_SENSITIVE").to(false)).set("SEARCHABLE").to(2L)).set("UNSIGNED_ATTRIBUTE").to(false)).set("FIXED_PREC_SCALE").to(false)).set("AUTO_INCREMENT").to(false)).set("LOCAL_TYPE_NAME").to("FLOAT64")).set("MINIMUM_SCALE").to(0L)).set("MAXIMUM_SCALE").to(0L)).set("SQL_DATA_TYPE").to((Long)null)).set("SQL_DATETIME_SUB").to((Long)null)).set("NUM_PREC_RADIX").to(2L)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("TYPE_NAME").to("BOOL")).set("DATA_TYPE").to(16L)).set("PRECISION").to((Long)null)).set("LITERAL_PREFIX").to((String)null)).set("LITERAL_SUFFIX").to((String)null)).set("CREATE_PARAMS").to((String)null)).set("NULLABLE").to(1L)).set("CASE_SENSITIVE").to(false)).set("SEARCHABLE").to(2L)).set("UNSIGNED_ATTRIBUTE").to(true)).set("FIXED_PREC_SCALE").to(false)).set("AUTO_INCREMENT").to(false)).set("LOCAL_TYPE_NAME").to("BOOL")).set("MINIMUM_SCALE").to(0L)).set("MAXIMUM_SCALE").to(0L)).set("SQL_DATA_TYPE").to((Long)null)).set("SQL_DATETIME_SUB").to((Long)null)).set("NUM_PREC_RADIX").to((Long)null)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("TYPE_NAME").to("DATE")).set("DATA_TYPE").to(91L)).set("PRECISION").to(10L)).set("LITERAL_PREFIX").to("DATE ")).set("LITERAL_SUFFIX").to((String)null)).set("CREATE_PARAMS").to((String)null)).set("NULLABLE").to(1L)).set("CASE_SENSITIVE").to(false)).set("SEARCHABLE").to(2L)).set("UNSIGNED_ATTRIBUTE").to(true)).set("FIXED_PREC_SCALE").to(false)).set("AUTO_INCREMENT").to(false)).set("LOCAL_TYPE_NAME").to("DATE")).set("MINIMUM_SCALE").to(0L)).set("MAXIMUM_SCALE").to(0L)).set("SQL_DATA_TYPE").to((Long)null)).set("SQL_DATETIME_SUB").to((Long)null)).set("NUM_PREC_RADIX").to((Long)null)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("TYPE_NAME").to("TIMESTAMP")).set("DATA_TYPE").to(93L)).set("PRECISION").to(35L)).set("LITERAL_PREFIX").to("TIMESTAMP ")).set("LITERAL_SUFFIX").to((String)null)).set("CREATE_PARAMS").to((String)null)).set("NULLABLE").to(1L)).set("CASE_SENSITIVE").to(false)).set("SEARCHABLE").to(2L)).set("UNSIGNED_ATTRIBUTE").to(true)).set("FIXED_PREC_SCALE").to(false)).set("AUTO_INCREMENT").to(false)).set("LOCAL_TYPE_NAME").to("TIMESTAMP")).set("MINIMUM_SCALE").to(0L)).set("MAXIMUM_SCALE").to(0L)).set("SQL_DATA_TYPE").to((Long)null)).set("SQL_DATETIME_SUB").to((Long)null)).set("NUM_PREC_RADIX").to((Long)null)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("TYPE_NAME").to("NUMERIC")).set("DATA_TYPE").to(2L)).set("PRECISION").to(0x280000L)).set("LITERAL_PREFIX").to((String)null)).set("LITERAL_SUFFIX").to((String)null)).set("CREATE_PARAMS").to((String)null)).set("NULLABLE").to(1L)).set("CASE_SENSITIVE").to(false)).set("SEARCHABLE").to(2L)).set("UNSIGNED_ATTRIBUTE").to(false)).set("FIXED_PREC_SCALE").to(false)).set("AUTO_INCREMENT").to(false)).set("LOCAL_TYPE_NAME").to("NUMERIC")).set("MINIMUM_SCALE").to(0L)).set("MAXIMUM_SCALE").to(0L)).set("SQL_DATA_TYPE").to((Long)null)).set("SQL_DATETIME_SUB").to((Long)null)).set("NUM_PREC_RADIX").to(10L)).build())));
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.getIndexInfo(catalog, schema, table, null, unique);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String indexName) throws SQLException {
        return this.getIndexInfo(catalog, schema, null, indexName, false);
    }

    private ResultSet getIndexInfo(String catalog, String schema, String table, String indexName, boolean unique) throws SQLException {
        String sql = JdbcDatabaseMetaData.readSqlFromFile("DatabaseMetaData_GetIndexInfo.sql");
        JdbcPreparedStatement statement = this.prepareStatementReplaceNullWithAnyString(sql, catalog, schema, table, indexName, unique ? "YES" : "%");
        return statement.executeQueryWithOptions(new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TYPE_CAT", (Type)Type.string()), Type.StructField.of((String)"TYPE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"CLASS_NAME", (Type)Type.string()), Type.StructField.of((String)"DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"REMARKS", (Type)Type.string()), Type.StructField.of((String)"BASE_TYPE", (Type)Type.int64())}), Collections.emptyList()));
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TYPE_CAT", (Type)Type.string()), Type.StructField.of((String)"TYPE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"SUPERTYPE_CAT", (Type)Type.string()), Type.StructField.of((String)"SUPERTYPE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"SUPERTYPE_NAME", (Type)Type.string())}), Collections.emptyList()));
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TABLE_CAT", (Type)Type.string()), Type.StructField.of((String)"TABLE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"TABLE_NAME", (Type)Type.string()), Type.StructField.of((String)"SUPERTABLE_NAME", (Type)Type.string())}), Collections.emptyList()));
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TYPE_CAT", (Type)Type.string()), Type.StructField.of((String)"TYPE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"ATTR_NAME", (Type)Type.string()), Type.StructField.of((String)"DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"ATTR_TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"ATTR_SIZE", (Type)Type.int64()), Type.StructField.of((String)"DECIMAL_DIGITS", (Type)Type.int64()), Type.StructField.of((String)"NUM_PREC_RADIX", (Type)Type.int64()), Type.StructField.of((String)"NULLABLE", (Type)Type.int64()), Type.StructField.of((String)"REMARKS", (Type)Type.string()), Type.StructField.of((String)"ATTR_DEF", (Type)Type.string()), Type.StructField.of((String)"SQL_DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"SQL_DATETIME_SUB", (Type)Type.int64()), Type.StructField.of((String)"CHAR_OCTET_LENGTH", (Type)Type.int64()), Type.StructField.of((String)"ORDINAL_POSITION", (Type)Type.int64()), Type.StructField.of((String)"IS_NULLABLE", (Type)Type.string()), Type.StructField.of((String)"SCOPE_CATALOG", (Type)Type.string()), Type.StructField.of((String)"SCOPE_SCHEMA", (Type)Type.string()), Type.StructField.of((String)"SCOPE_TABLE", (Type)Type.string()), Type.StructField.of((String)"SOURCE_DATA_TYPE", (Type)Type.int64())}), Collections.emptyList()));
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 2;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 1;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String sql = JdbcDatabaseMetaData.readSqlFromFile("DatabaseMetaData_GetSchemas.sql");
        JdbcPreparedStatement statement = this.prepareStatementReplaceNullWithAnyString(sql, catalog, schemaPattern);
        return statement.executeQueryWithOptions(new Options.QueryOption[]{Connection.InternalMetadataQuery.INSTANCE});
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    static Properties getDefaultClientInfoProperties() throws SQLException {
        Properties info = new Properties();
        try (ResultSet rs = JdbcDatabaseMetaData.getDefaultClientInfo();){
            while (rs.next()) {
                info.put(rs.getString("NAME"), rs.getString("DEFAULT_VALUE"));
            }
        }
        return info;
    }

    private static ResultSet getDefaultClientInfo() {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"NAME", (Type)Type.string()), Type.StructField.of((String)"MAX_LEN", (Type)Type.int64()), Type.StructField.of((String)"DEFAULT_VALUE", (Type)Type.string()), Type.StructField.of((String)"DESCRIPTION", (Type)Type.string())}), Arrays.asList(((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("NAME").to("APPLICATIONNAME")).set("MAX_LEN").to(63L)).set("DEFAULT_VALUE").to("")).set("DESCRIPTION").to("The name of the application currently utilizing the connection.")).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("NAME").to("CLIENTHOSTNAME")).set("MAX_LEN").to(63L)).set("DEFAULT_VALUE").to("")).set("DESCRIPTION").to("The hostname of the computer the application using the connection is running on.")).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("NAME").to("CLIENTUSER")).set("MAX_LEN").to(63L)).set("DEFAULT_VALUE").to("")).set("DESCRIPTION").to("The name of the user that the application using the connection is performing work for. This may not be the same as the user name that was used in establishing the connection.")).build())));
    }

    @Override
    public ResultSet getClientInfoProperties() {
        return JdbcDatabaseMetaData.getDefaultClientInfo();
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"FUNCTION_CAT", (Type)Type.string()), Type.StructField.of((String)"FUNCTION_SCHEM", (Type)Type.string()), Type.StructField.of((String)"FUNCTION_NAME", (Type)Type.string()), Type.StructField.of((String)"REMARKS", (Type)Type.string()), Type.StructField.of((String)"FUNCTION_TYPE", (Type)Type.int64()), Type.StructField.of((String)"SPECIFIC_NAME", (Type)Type.string())}), Collections.emptyList()));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"FUNCTION_CAT", (Type)Type.string()), Type.StructField.of((String)"FUNCTION_SCHEM", (Type)Type.string()), Type.StructField.of((String)"FUNCTION_NAME", (Type)Type.string()), Type.StructField.of((String)"COLUMN_NAME", (Type)Type.string()), Type.StructField.of((String)"COLUMN_TYPE", (Type)Type.int64()), Type.StructField.of((String)"DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"TYPE_NAME", (Type)Type.string()), Type.StructField.of((String)"PRECISION", (Type)Type.int64()), Type.StructField.of((String)"LENGTH", (Type)Type.int64()), Type.StructField.of((String)"SCALE", (Type)Type.int64()), Type.StructField.of((String)"RADIX", (Type)Type.int64()), Type.StructField.of((String)"NULLABLE", (Type)Type.int64()), Type.StructField.of((String)"REMARKS", (Type)Type.string()), Type.StructField.of((String)"CHAR_OCTET_LENGTH", (Type)Type.int64()), Type.StructField.of((String)"ORDINAL_POSITION", (Type)Type.int64()), Type.StructField.of((String)"IS_NULLABLE", (Type)Type.string()), Type.StructField.of((String)"SPECIFIC_NAME", (Type)Type.string())}), Collections.emptyList()));
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        return JdbcResultSet.of(ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"TABLE_CAT", (Type)Type.string()), Type.StructField.of((String)"TABLE_SCHEM", (Type)Type.string()), Type.StructField.of((String)"TABLE_NAME", (Type)Type.string()), Type.StructField.of((String)"COLUMN_NAME", (Type)Type.string()), Type.StructField.of((String)"DATA_TYPE", (Type)Type.int64()), Type.StructField.of((String)"COLUMN_SIZE", (Type)Type.int64()), Type.StructField.of((String)"DECIMAL_DIGITS", (Type)Type.int64()), Type.StructField.of((String)"NUM_PREC_RADIX", (Type)Type.int64()), Type.StructField.of((String)"COLUMN_USAGE", (Type)Type.string()), Type.StructField.of((String)"REMARKS", (Type)Type.string()), Type.StructField.of((String)"CHAR_OCTET_LENGTH", (Type)Type.int64()), Type.StructField.of((String)"IS_NULLABLE", (Type)Type.string())}), Collections.emptyList()));
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public long getMaxLogicalLobSize() {
        return 0xA00000L;
    }

    @Override
    public boolean supportsRefCursors() {
        return false;
    }
}

