/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.jdbc.AbstractJdbcStatement;
import com.google.cloud.spanner.jdbc.JdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcResultSet;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.rpc.Code;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class JdbcStatement
extends AbstractJdbcStatement {
    private java.sql.ResultSet currentResultSet;
    private long currentUpdateCount;
    private int fetchSize;
    private BatchType currentBatchType = BatchType.NONE;
    final List<Statement> batchedStatements = new ArrayList<Statement>();

    JdbcStatement(JdbcConnection connection) {
        super(connection);
    }

    @Override
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        return this.executeQuery(Statement.of((String)sql), new Options.QueryOption[0]);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long result = this.executeLargeUpdate(sql);
        if (result > Integer.MAX_VALUE) {
            throw JdbcSqlExceptionFactory.of("update count too large: " + result, Code.OUT_OF_RANGE);
        }
        return (int)result;
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        this.checkClosed();
        Statement statement = Statement.of((String)sql);
        StatementResult result = this.execute(statement);
        switch (result.getResultType()) {
            case RESULT_SET: {
                throw JdbcSqlExceptionFactory.of("The statement is not an update or DDL statement", Code.INVALID_ARGUMENT);
            }
            case UPDATE_COUNT: {
                return result.getUpdateCount();
            }
            case NO_RESULT: {
                return 0L;
            }
        }
        throw JdbcSqlExceptionFactory.of("unknown result: " + result.getResultType(), Code.FAILED_PRECONDITION);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        return this.executeStatement(Statement.of((String)sql));
    }

    boolean executeStatement(Statement statement) throws SQLException {
        StatementResult result = this.execute(statement);
        switch (result.getResultType()) {
            case RESULT_SET: {
                this.currentResultSet = JdbcResultSet.of(this, result.getResultSet());
                this.currentUpdateCount = -1L;
                return true;
            }
            case UPDATE_COUNT: {
                this.currentResultSet = null;
                this.currentUpdateCount = result.getUpdateCount();
                return false;
            }
            case NO_RESULT: {
                this.currentResultSet = null;
                this.currentUpdateCount = -2L;
                return false;
            }
        }
        throw JdbcSqlExceptionFactory.of("unknown result: " + result.getResultType(), Code.FAILED_PRECONDITION);
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.currentResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.currentUpdateCount > Integer.MAX_VALUE) {
            throw JdbcSqlExceptionFactory.of("update count too large: " + this.currentUpdateCount, Code.OUT_OF_RANGE);
        }
        return (int)this.currentUpdateCount;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        this.checkClosed();
        return this.currentUpdateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        if (!(this.currentResultSet == null || this.currentResultSet.isClosed() || current != 1 && current != 3)) {
            this.currentResultSet.close();
        }
        this.currentResultSet = null;
        this.currentUpdateCount = -1L;
        return false;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    private BatchType determineStatementBatchType(String sql) throws SQLException {
        String sqlWithoutComments = StatementParser.removeCommentsAndTrim((String)sql);
        if (StatementParser.INSTANCE.isDdlStatement(sqlWithoutComments)) {
            return BatchType.DDL;
        }
        if (StatementParser.INSTANCE.isUpdateStatement(sqlWithoutComments)) {
            return BatchType.DML;
        }
        throw JdbcSqlExceptionFactory.of("The statement is not suitable for batching. Only DML and DDL statements are allowed for batching.", Code.INVALID_ARGUMENT);
    }

    void checkAndSetBatchType(String sql) throws SQLException {
        this.checkConnectionHasNoActiveBatch();
        BatchType type = this.determineStatementBatchType(sql);
        if (this.currentBatchType == BatchType.NONE) {
            this.currentBatchType = type;
        } else if (this.currentBatchType != type) {
            throw JdbcSqlExceptionFactory.of("Mixing DML and DDL statements in a batch is not allowed.", Code.INVALID_ARGUMENT);
        }
    }

    private void checkConnectionHasNoActiveBatch() throws SQLException {
        if (this.getConnection().getSpannerConnection().isDdlBatchActive() || this.getConnection().getSpannerConnection().isDmlBatchActive()) {
            throw JdbcSqlExceptionFactory.of("Calling addBatch() is not allowed when a DML or DDL batch has been started on the connection.", Code.FAILED_PRECONDITION);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        this.checkAndSetBatchType(sql);
        this.batchedStatements.add(Statement.of((String)sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.checkConnectionHasNoActiveBatch();
        this.batchedStatements.clear();
        this.currentBatchType = BatchType.NONE;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.convertUpdateCounts(this.executeBatch(false));
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.executeBatch(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] executeBatch(boolean large) throws SQLException {
        this.checkClosed();
        this.checkConnectionHasNoActiveBatch();
        try {
            switch (this.currentBatchType) {
                case DML: {
                    try {
                        long[] lArray = this.getConnection().getSpannerConnection().executeBatchUpdate(this.batchedStatements);
                        return lArray;
                    }
                    catch (SpannerBatchUpdateException e) {
                        if (!large) throw JdbcSqlExceptionFactory.batchException(this.convertUpdateCounts(e.getUpdateCounts()), e);
                        throw JdbcSqlExceptionFactory.batchException(e.getUpdateCounts(), e);
                    }
                    catch (SpannerException e) {
                        throw JdbcSqlExceptionFactory.of(e);
                    }
                }
                case DDL: {
                    try {
                        this.getConnection().getSpannerConnection().startBatchDdl();
                        Iterator<Statement> e = this.batchedStatements.iterator();
                        while (true) {
                            Object statement;
                            if (!e.hasNext()) {
                                this.getConnection().getSpannerConnection().runBatch();
                                long[] res = new long[this.batchedStatements.size()];
                                Arrays.fill(res, -2L);
                                statement = res;
                                return statement;
                            }
                            statement = e.next();
                            this.execute((Statement)statement);
                        }
                    }
                    catch (SpannerBatchUpdateException e) {
                        long[] res = new long[this.batchedStatements.size()];
                        Arrays.fill(res, -3L);
                        this.convertUpdateCountsToSuccessNoInfo(e.getUpdateCounts(), res);
                        if (!large) throw JdbcSqlExceptionFactory.batchException(this.convertUpdateCounts(res), e);
                        throw JdbcSqlExceptionFactory.batchException(res, e);
                    }
                    catch (SpannerException e) {
                        throw JdbcSqlExceptionFactory.of(e);
                    }
                }
                case NONE: {
                    long[] lArray = new long[]{};
                    return lArray;
                }
            }
            throw JdbcSqlExceptionFactory.unsupported(String.format("Unknown batch type: %s", this.currentBatchType.name()));
        }
        finally {
            this.batchedStatements.clear();
            this.currentBatchType = BatchType.NONE;
        }
    }

    @VisibleForTesting
    int[] convertUpdateCounts(long[] updateCounts) throws SQLException {
        int[] res = new int[updateCounts.length];
        for (int index = 0; index < updateCounts.length; ++index) {
            if (updateCounts[index] > Integer.MAX_VALUE) {
                throw JdbcSqlExceptionFactory.of(String.format("Update count too large for int: %d", updateCounts[index]), Code.OUT_OF_RANGE);
            }
            res[index] = (int)updateCounts[index];
        }
        return res;
    }

    @VisibleForTesting
    void convertUpdateCountsToSuccessNoInfo(long[] updateCounts, long[] res) {
        Preconditions.checkNotNull((Object)updateCounts);
        Preconditions.checkNotNull((Object)res);
        Preconditions.checkArgument((res.length >= updateCounts.length ? 1 : 0) != 0);
        for (int index = 0; index < updateCounts.length; ++index) {
            res[index] = updateCounts[index] > 0L ? -2L : -3L;
        }
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        ResultSet rs = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"COLUMN_NAME", (Type)Type.string()), Type.StructField.of((String)"VALUE", (Type)Type.int64())}), Collections.emptyList());
        return JdbcResultSet.of(rs);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(autoGeneratedKeys == 2, "Only NO_GENERATED_KEYS are supported");
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return this.executeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(autoGeneratedKeys == 2, "Only NO_GENERATED_KEYS are supported");
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return this.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return this.executeLargeUpdate(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkSqlFeatureSupported(autoGeneratedKeys == 2, "Only NO_GENERATED_KEYS are supported");
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return this.execute(sql);
    }

    static enum BatchType {
        NONE,
        DML,
        DDL;

    }
}

