/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.flywaydb.LicenseGuard;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.ConfigurationProvider;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.secretsmanagement.GcsmConfigurationExtension;

public class GcsmConfigurationProvider
implements ConfigurationProvider<GcsmConfigurationExtension> {
    public Map<String, String> getConfiguration(GcsmConfigurationExtension configurationExtension, ClassicConfiguration flywayConfiguration) throws Exception {
        boolean isConfigured;
        String gcsmProject = configurationExtension.getGcsmProject();
        String[] gcsmSecrets = configurationExtension.getGcsmSecrets();
        boolean bl = isConfigured = gcsmProject != null && gcsmSecrets != null;
        if (!isConfigured) {
            return new HashMap<String, String>();
        }
        String gcsmConfiguration = GcsmConfigurationProvider.getConfiguration(gcsmProject, gcsmSecrets);
        Map gcsmConfigurationMap = ConfigUtils.loadConfigurationFromString((String)gcsmConfiguration);
        flywayConfiguration.configure(gcsmConfigurationMap);
        LicenseGuard.guard((Configuration)flywayConfiguration, Collections.singletonList(Edition.ENTERPRISE), (String)"Google Cloud Secret Manager");
        ConfigUtils.dumpConfiguration((Map)gcsmConfigurationMap);
        return gcsmConfigurationMap;
    }

    public Class<GcsmConfigurationExtension> getConfigurationExtensionClass() {
        return GcsmConfigurationExtension.class;
    }

    public static String getConfiguration(String project, String ... secrets) throws Exception {
        StringBuilder gcsmConf = new StringBuilder();
        for (String secret : secrets) {
            gcsmConf.append(GcsmConfigurationProvider.readSecret(project, secret)).append("\n");
        }
        return gcsmConf.toString();
    }

    private static String readSecret(String project, String secret) throws Exception {
        try (SecretManagerServiceClient client = SecretManagerServiceClient.create();){
            SecretVersionName secretVersionName = SecretVersionName.of((String)project, (String)secret, (String)"latest");
            AccessSecretVersionResponse response = client.accessSecretVersion(secretVersionName);
            String string = response.getPayload().getData().toStringUtf8();
            return string;
        }
    }
}

