/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.flywaydb.LicenseGuard;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.extensibility.ConfigurationProvider;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.secretsmanagement.VaultConfigurationExtension;

public class VaultConfigurationProvider
implements ConfigurationProvider<VaultConfigurationExtension> {
    public Map<String, String> getConfiguration(VaultConfigurationExtension configurationExtension, ClassicConfiguration flywayConfiguration) throws Exception {
        boolean isConfigured;
        String vaultUrl = configurationExtension.getVaultUrl();
        String vaultToken = configurationExtension.getVaultToken();
        String[] vaultSecrets = configurationExtension.getVaultSecrets();
        boolean bl = isConfigured = vaultUrl != null && vaultToken != null && vaultSecrets != null;
        if (!isConfigured) {
            return new HashMap<String, String>();
        }
        String vaultConfiguration = VaultConfigurationProvider.getConfiguration(vaultUrl, vaultToken, vaultSecrets);
        Map vaultConfigurationMap = ConfigUtils.loadConfigurationFromString((String)vaultConfiguration);
        flywayConfiguration.configure(vaultConfigurationMap);
        LicenseGuard.guard((Configuration)flywayConfiguration, Collections.singletonList(Edition.ENTERPRISE), (String)"Vault");
        ConfigUtils.dumpConfiguration((Map)vaultConfigurationMap);
        return vaultConfigurationMap;
    }

    public Class<VaultConfigurationExtension> getConfigurationExtensionClass() {
        return VaultConfigurationExtension.class;
    }

    public static String getConfiguration(String url, String token, String ... secrets) throws Exception {
        String urlWithoutSlash = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        StringBuilder vaultConf = new StringBuilder();
        for (String secret : secrets) {
            if (!secret.contains("/")) {
                vaultConf.append(VaultConfigurationProvider.readSecret(urlWithoutSlash, token, secret)).append("\n");
                continue;
            }
            vaultConf.append(VaultConfigurationProvider.readSecretWithPath(urlWithoutSlash, token, secret)).append("\n");
        }
        return vaultConf.toString();
    }

    private static String readSecretWithPath(String url, String token, String secret) throws Exception {
        if (!secret.startsWith("/")) {
            secret = "/" + secret;
        }
        String path = secret.substring(0, secret.lastIndexOf("/"));
        String secretName = secret.substring(secret.lastIndexOf("/") + 1);
        return VaultConfigurationProvider.readSecret(url + path, token, secretName);
    }

    private static String readSecret(String url, String token, String secret) throws Exception {
        if (url.startsWith("https")) {
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            return VaultConfigurationProvider.readSecret(conn, token, secret);
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return VaultConfigurationProvider.readSecret(conn, token, secret);
    }

    private static String readSecret(URLConnection conn, String token, String secret) throws Exception {
        JsonObject secretObj;
        JsonObject secretResponse = (JsonObject)new Gson().fromJson(VaultConfigurationProvider.getSecretFromVault(conn, token), JsonObject.class);
        if (VaultConfigurationProvider.isKV1Response(secretResponse)) {
            secretObj = secretResponse.getAsJsonObject("data");
        } else if (VaultConfigurationProvider.isKV2Response(secretResponse)) {
            secretObj = secretResponse.getAsJsonObject("data").getAsJsonObject("data");
        } else {
            throw new FlywayException("Vault response unaccepted. Expected a KV1 or KV2 secret, but was: " + secretResponse);
        }
        if (!secretObj.has(secret)) {
            throw new FlywayException("'" + secret + "' is not a valid Vault secret");
        }
        return secretObj.get(secret).getAsString();
    }

    private static String getSecretFromVault(URLConnection conn, String token) throws Exception {
        conn.setRequestProperty("X-Vault-Token", token);
        StringBuilder rawSecret = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = br.readLine()) != null) {
                rawSecret.append(line);
            }
        }
        catch (FileNotFoundException e) {
            throw new FlywayException("Vault secret location '" + conn.getURL() + "' could not be found. Ensure the path to your secret is correct.");
        }
        return rawSecret.toString();
    }

    private static boolean isKV1Response(JsonObject secretResponse) {
        JsonObject secretObj;
        try {
            secretObj = secretResponse.getAsJsonObject("data");
        }
        catch (ClassCastException e) {
            return false;
        }
        try {
            if (!secretObj.has("data")) {
                return true;
            }
            secretObj.getAsJsonObject("data");
            return false;
        }
        catch (ClassCastException e) {
            return true;
        }
    }

    private static boolean isKV2Response(JsonObject secretResponse) {
        try {
            secretResponse.getAsJsonObject("data").getAsJsonObject("data");
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

