/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import java.util.Map;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public class VaultConfigurationExtension
implements ConfigurationExtension {
    private static final Log LOG = LogFactory.getLog(VaultConfigurationExtension.class);
    private static final String VAULT_URL = "flyway.plugins.vault.url";
    private static final String VAULT_TOKEN = "flyway.plugins.vault.token";
    private static final String VAULT_SECRETS = "flyway.plugins.vault.secrets";
    private static final String VAULT_URL_DEPRECATED = "flyway.vault.url";
    private static final String VAULT_TOKEN_DEPRECATED = "flyway.vault.token";
    private static final String VAULT_SECRETS_DEPRECATED = "flyway.vault.secrets";
    private String vaultUrl;
    private String vaultToken;
    private String[] vaultSecrets;

    public void extractParametersFromConfiguration(Map<String, String> configuration) {
        if (configuration.containsKey(VAULT_URL_DEPRECATED)) {
            LOG.warn("The 'flyway.vault' parameters have been deprecated, and will be replaced with 'flyway.plugins.vault'. Update your configuration to use the new names, see: https://rd.gt/3mUUFvE");
            this.extractDeprecatedConfiguration(configuration);
        } else {
            this.extractConfiguration(configuration);
        }
    }

    private void extractConfiguration(Map<String, String> configuration) {
        this.vaultUrl = configuration.getOrDefault(VAULT_URL, this.vaultUrl);
        this.vaultToken = configuration.getOrDefault(VAULT_TOKEN, this.vaultToken);
        String vaultSecretsString = configuration.getOrDefault(VAULT_SECRETS, null);
        if (vaultSecretsString != null) {
            this.vaultSecrets = vaultSecretsString.split(",");
        }
        configuration.remove(VAULT_URL);
        configuration.remove(VAULT_TOKEN);
        configuration.remove(VAULT_SECRETS);
    }

    private void extractDeprecatedConfiguration(Map<String, String> configuration) {
        this.vaultUrl = configuration.getOrDefault(VAULT_URL_DEPRECATED, this.vaultUrl);
        this.vaultToken = configuration.getOrDefault(VAULT_TOKEN_DEPRECATED, this.vaultToken);
        String vaultSecretsString = configuration.getOrDefault(VAULT_SECRETS_DEPRECATED, null);
        if (vaultSecretsString != null) {
            this.vaultSecrets = vaultSecretsString.split(",");
        }
        configuration.remove(VAULT_URL_DEPRECATED);
        configuration.remove(VAULT_TOKEN_DEPRECATED);
        configuration.remove(VAULT_SECRETS_DEPRECATED);
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        switch (environmentVariable) {
            case "FLYWAY_PLUGINS_VAULT_URL": {
                return VAULT_URL;
            }
            case "FLYWAY_PLUGINS_VAULT_TOKEN": {
                return VAULT_TOKEN;
            }
            case "FLYWAY_PLUGINS_VAULT_SECRETS": {
                return VAULT_SECRETS;
            }
            case "FLYWAY_VAULT_URL": {
                return VAULT_URL_DEPRECATED;
            }
            case "FLYWAY_VAULT_TOKEN": {
                return VAULT_TOKEN_DEPRECATED;
            }
            case "FLYWAY_VAULT_SECRETS": {
                return VAULT_SECRETS_DEPRECATED;
            }
        }
        return null;
    }

    public void setVaultSecrets(String ... vaultSecrets) {
        this.vaultSecrets = vaultSecrets;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public String getVaultToken() {
        return this.vaultToken;
    }

    public String[] getVaultSecrets() {
        return this.vaultSecrets;
    }

    public void setVaultUrl(String vaultUrl) {
        this.vaultUrl = vaultUrl;
    }

    public void setVaultToken(String vaultToken) {
        this.vaultToken = vaultToken;
    }
}

