/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import javax.net.ssl.HttpsURLConnection;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.MachineFingerprintUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class RedgateUpdateChecker {
    private static final Log LOG = LogFactory.getLog(RedgateUpdateChecker.class);
    private static final String PLATFORM_URL_ROOT = RedgateUpdateChecker.getRoot();
    private static final String USAGE_CHECKER_ENDPOINT = "/usage-checker";
    private static final String CFU_ENDPOINT = "/flyway/cfu/api/v0/cfu";

    public static boolean isEnabled() {
        return RedgateUpdateChecker.usageChecker("flyway-cfu", VersionPrinter.getVersion());
    }

    public static void checkForVersionUpdates(String jdbcUrl) {
        String message = RedgateUpdateChecker.cfu(jdbcUrl);
        if (StringUtils.hasText((String)message)) {
            LOG.info(message);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean usageChecker(String clientName, String clientVersion) {
        try {
            String url = PLATFORM_URL_ROOT + USAGE_CHECKER_ENDPOINT + String.format("?client_name=%s&client_version=%s", clientName, clientVersion);
            HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
            try {
                boolean bl;
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(1000);
                try (BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    bl = Boolean.parseBoolean(rd.readLine());
                }
                return bl;
            }
            finally {
                if (Collections.singletonList(connection).get(0) != null) {
                    connection.disconnect();
                }
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String cfu(String jdbcUrl) {
        String string;
        block20: {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(PLATFORM_URL_ROOT + CFU_ENDPOINT).openConnection();
            try {
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json; utf-8");
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = RedgateUpdateChecker.getJsonPayload(jdbcUrl).getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                StringBuilder response = new StringBuilder();
                try (BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    while ((line = rd.readLine()) != null) {
                        response.append(line).append('\n');
                    }
                }
                response.deleteCharAt(response.length() - 1);
                string = response.toString();
                if (Collections.singletonList(connection).get(0) == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(connection).get(0) != null) {
                        connection.disconnect();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.debug("Failed to perform update check: " + e.getMessage());
                    return "";
                }
            }
            connection.disconnect();
        }
        return string;
    }

    private static String getRoot() {
        String root = System.getenv("REDGATE_PLATFORM_URL");
        return StringUtils.hasText((String)root) ? root : "https://www.redgate-platform.com";
    }

    private static String getJsonPayload(String jdbcUrl) throws Exception {
        String operatingSystem = System.getProperty("os.name");
        JsonObject json = new JsonObject();
        json.addProperty("currentVersion", VersionPrinter.getVersion());
        json.addProperty("operatingSystem", operatingSystem);
        json.addProperty("fingerprint", MachineFingerprintUtils.getFingerprint((String[])new String[]{operatingSystem, jdbcUrl, System.getProperty("user.dir")}));
        json.addProperty("timeStamp", Instant.now().toString());
        return new Gson().toJson((JsonElement)json);
    }

    private RedgateUpdateChecker() {
    }
}

