/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.flywaydb.commandline.logging.console.ConsoleLog;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.util.StringUtils;

public class CommandLineArguments {
    private static final String DEBUG_FLAG = "-X";
    private static final String QUIET_FLAG = "-q";
    private static final String SUPPRESS_PROMPT_FLAG = "-n";
    private static final List<String> PRINT_VERSION_AND_EXIT_FLAGS = Arrays.asList("-v", "--version");
    private static final String CHECK_LICENCE = "-checkLicence";
    private static final List<String> PRINT_USAGE_FLAGS = Arrays.asList("-?", "-h", "--help");
    private static final String SKIP_CHECK_FOR_UPDATE_FLAG = "-skipCheckForUpdate";
    private static final String COMMUNITY_FLAG = "-community";
    private static final String ENTERPRISE_FLAG = "-enterprise";
    private static final String PRO_FLAG = "-pro";
    private static final String TEAMS_FLAG = "-teams";
    private static final String OUTPUT_FILE = "outputFile";
    private static final String OUTPUT_TYPE = "outputType";
    private static final String CONFIG_FILE_ENCODING = "configFileEncoding";
    private static final String CONFIG_FILES = "configFiles";
    private static final String COLOR = "color";
    private static final String WORKING_DIRECTORY = "workingDirectory";
    private static final String INFO_SINCE_DATE = "infoSinceDate";
    private static final String INFO_UNTIL_DATE = "infoUntilDate";
    private static final String INFO_SINCE_VERSION = "infoSinceVersion";
    private static final String INFO_UNTIL_VERSION = "infoUntilVersion";
    private static final String INFO_OF_STATE = "infoOfState";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    private static final List<String> VALID_OPERATIONS_AND_FLAGS = CommandLineArguments.getValidOperationsAndFlags();
    private final String[] args;

    private static List<String> getValidOperationsAndFlags() {
        ArrayList<String> operationsAndFlags = new ArrayList<String>(Arrays.asList(DEBUG_FLAG, QUIET_FLAG, SUPPRESS_PROMPT_FLAG, SKIP_CHECK_FOR_UPDATE_FLAG, COMMUNITY_FLAG, ENTERPRISE_FLAG, PRO_FLAG, TEAMS_FLAG, CHECK_LICENCE, "help", "migrate", "clean", "info", "validate", "undo", "baseline", "repair"));
        operationsAndFlags.addAll(PRINT_VERSION_AND_EXIT_FLAGS);
        operationsAndFlags.addAll(PRINT_USAGE_FLAGS);
        return operationsAndFlags;
    }

    public CommandLineArguments(String[] args) {
        this.args = args;
    }

    private static boolean isFlagSet(String[] args, String flag) {
        for (String arg : args) {
            if (!flag.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFlagSet(String[] args, List<String> flags) {
        for (String flag : flags) {
            if (!CommandLineArguments.isFlagSet(args, flag)) continue;
            return true;
        }
        return false;
    }

    private static String getArgumentValue(String argName, String[] allArgs) {
        for (String arg : allArgs) {
            if (!arg.startsWith("-" + argName + "=")) continue;
            return CommandLineArguments.parseConfigurationOptionValueFromArg(arg);
        }
        return "";
    }

    private static String parseConfigurationOptionValueFromArg(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static List<String> getOperationsFromArgs(String[] args) {
        ArrayList<String> operations = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            operations.add(arg);
        }
        return operations;
    }

    private static List<String> getConfigFilesFromArgs(String[] args) {
        String configFilesCommaSeparatedList = CommandLineArguments.getArgumentValue(CONFIG_FILES, args);
        return Arrays.asList(StringUtils.tokenizeToStringArray((String)configFilesCommaSeparatedList, (String)","));
    }

    private static Map<String, String> getConfigurationFromArgs(String[] args) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        for (String arg : args) {
            String configurationOptionName;
            if (!CommandLineArguments.isConfigurationArg(arg) || CommandLineArguments.isConfigurationOptionCommandlineOnly(configurationOptionName = CommandLineArguments.getConfigurationOptionNameFromArg(arg))) continue;
            configuration.put("flyway." + configurationOptionName, CommandLineArguments.parseConfigurationOptionValueFromArg(arg));
        }
        return configuration;
    }

    private static boolean isConfigurationOptionCommandlineOnly(String configurationOptionName) {
        return OUTPUT_FILE.equals(configurationOptionName) || OUTPUT_TYPE.equals(configurationOptionName) || COLOR.equals(configurationOptionName) || WORKING_DIRECTORY.equals(configurationOptionName) || INFO_SINCE_DATE.equals(configurationOptionName) || INFO_UNTIL_DATE.equals(configurationOptionName) || INFO_SINCE_VERSION.equals(configurationOptionName) || INFO_UNTIL_VERSION.equals(configurationOptionName) || INFO_OF_STATE.equals(configurationOptionName);
    }

    private static String getConfigurationOptionNameFromArg(String arg) {
        int index = arg.indexOf("=");
        return arg.substring(1, index);
    }

    private static boolean isConfigurationArg(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    public void validate() {
        for (String arg : this.args) {
            if (CommandLineArguments.isConfigurationArg(arg) || VALID_OPERATIONS_AND_FLAGS.contains(arg)) continue;
            throw new FlywayException("Invalid argument: " + arg);
        }
        String outputTypeValue = CommandLineArguments.getArgumentValue(OUTPUT_TYPE, this.args).toLowerCase();
        if (!"json".equals(outputTypeValue) && !"".equals(outputTypeValue)) {
            throw new FlywayException("'" + outputTypeValue + "' is an invalid value for the -outputType option. Use 'json'.");
        }
        String colorArgumentValue = CommandLineArguments.getArgumentValue(COLOR, this.args);
        if (!Color.isValid(colorArgumentValue)) {
            throw new FlywayException("'" + colorArgumentValue + "' is an invalid value for the -color option. Use 'always', 'never', or 'auto'.");
        }
    }

    public boolean shouldSuppressPrompt() {
        return CommandLineArguments.isFlagSet(this.args, SUPPRESS_PROMPT_FLAG);
    }

    public boolean shouldPrintVersionAndExit() {
        return CommandLineArguments.isFlagSet(this.args, PRINT_VERSION_AND_EXIT_FLAGS);
    }

    public boolean shouldCheckLicenseAndExit() {
        return CommandLineArguments.isFlagSet(this.args, CHECK_LICENCE);
    }

    public boolean shouldOutputJson() {
        return "json".equalsIgnoreCase(CommandLineArguments.getArgumentValue(OUTPUT_TYPE, this.args));
    }

    public boolean shouldPrintUsage() {
        return (CommandLineArguments.isFlagSet(this.args, PRINT_USAGE_FLAGS) || this.getOperations().isEmpty()) && !CommandLineArguments.isFlagSet(this.args, CHECK_LICENCE);
    }

    public ConsoleLog.Level getLogLevel() {
        if (CommandLineArguments.isFlagSet(this.args, QUIET_FLAG)) {
            return ConsoleLog.Level.WARN;
        }
        if (CommandLineArguments.isFlagSet(this.args, DEBUG_FLAG)) {
            return ConsoleLog.Level.DEBUG;
        }
        return ConsoleLog.Level.INFO;
    }

    public boolean hasOperation(String operation) {
        return this.getOperations().contains(operation);
    }

    public List<String> getOperations() {
        return CommandLineArguments.getOperationsFromArgs(this.args);
    }

    public List<String> getConfigFiles() {
        return CommandLineArguments.getConfigFilesFromArgs(this.args);
    }

    public String getOutputFile() {
        return CommandLineArguments.getArgumentValue(OUTPUT_FILE, this.args);
    }

    public String getWorkingDirectory() {
        return CommandLineArguments.getArgumentValue(WORKING_DIRECTORY, this.args);
    }

    public Date getInfoSinceDate() {
        return this.parseDate(INFO_SINCE_DATE);
    }

    public Date getInfoUntilDate() {
        return this.parseDate(INFO_UNTIL_DATE);
    }

    public MigrationVersion getInfoSinceVersion() {
        return this.parseVersion(INFO_SINCE_VERSION);
    }

    public MigrationVersion getInfoUntilVersion() {
        return this.parseVersion(INFO_UNTIL_VERSION);
    }

    public MigrationState getInfoOfState() {
        String stateStr = CommandLineArguments.getArgumentValue(INFO_OF_STATE, this.args);
        if (!StringUtils.hasText((String)stateStr)) {
            return null;
        }
        return MigrationState.valueOf((String)stateStr.toUpperCase(Locale.ENGLISH));
    }

    private MigrationVersion parseVersion(String argument) {
        String versionStr = CommandLineArguments.getArgumentValue(argument, this.args);
        if (versionStr.isEmpty()) {
            return null;
        }
        return MigrationVersion.fromVersion((String)versionStr);
    }

    private Date parseDate(String argument) {
        String dateStr = CommandLineArguments.getArgumentValue(argument, this.args);
        if (dateStr.isEmpty()) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(dateStr);
        }
        catch (ParseException e) {
            throw new FlywayException("'" + dateStr + "' is an invalid value for the " + argument + " option. The expected format is 'dd/mm/yyyy hh:mm', like '13/10/2020 16:30'. See the Flyway documentation for help: " + "https://rd.gt/3jqLqAn");
        }
    }

    public boolean isOutputFileSet() {
        return !this.getOutputFile().isEmpty();
    }

    public boolean isWorkingDirectorySet() {
        return !this.getWorkingDirectory().isEmpty();
    }

    public String getConfigFileEncoding() {
        return CommandLineArguments.getArgumentValue(CONFIG_FILE_ENCODING, this.args);
    }

    public boolean isConfigFileEncodingSet() {
        return !this.getConfigFileEncoding().isEmpty();
    }

    public boolean skipCheckForUpdate() {
        return CommandLineArguments.isFlagSet(this.args, SKIP_CHECK_FOR_UPDATE_FLAG);
    }

    public Color getColor() {
        return Color.fromString(CommandLineArguments.getArgumentValue(COLOR, this.args));
    }

    public Map<String, String> getConfiguration() {
        return CommandLineArguments.getConfigurationFromArgs(this.args);
    }

    public static enum Color {
        ALWAYS("always"),
        NEVER("never"),
        AUTO("auto");

        private final String value;

        private Color(String value) {
            this.value = value;
        }

        public static Color fromString(String value) {
            if (value.isEmpty()) {
                return AUTO;
            }
            for (Color color : Color.values()) {
                if (!color.value.equals(value)) continue;
                return color;
            }
            return null;
        }

        public static boolean isValid(String value) {
            return Color.fromString(value) != null;
        }
    }
}

