/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.VersionPrinter;

public class VersionChecker {
    private static final String FlywayUrl = "https://search.maven.org/solrsearch/select?q=a:flyway-core";
    private static final Log LOG = LogFactory.getLog(VersionPrinter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForVersionUpdates() {
        HttpURLConnection connection = null;
        try {
            MigrationVersion latest;
            URL url = new URL(FlywayUrl);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            StringBuilder response = new StringBuilder();
            try (BufferedReader rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = rd.readLine()) != null) {
                    response.append(line).append('\r');
                }
            }
            MavenObject obj = (MavenObject)new Gson().fromJson(response.toString(), MavenObject.class);
            MigrationVersion current = MigrationVersion.fromVersion((String)VersionPrinter.getVersion());
            if (current.compareTo(latest = MigrationVersion.fromVersion((String)obj.response.docs[0].latestVersion)) < 0) {
                LOG.warn("You are on an older version of Flyway. Please download latest at https://www.flywaydb.org/download/community");
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static class MavenObject {
        public MavenResponse response;

        private MavenObject() {
        }
    }

    private static class MavenDocs {
        public String latestVersion;

        private MavenDocs() {
        }
    }

    private static class MavenResponse {
        public MavenDocs[] docs;

        private MavenResponse() {
        }
    }
}

