/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.flywaydb.commandline.ConsoleLog;
import org.flywaydb.commandline.FileLog;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;

class FileLogCreator
implements LogCreator {
    private final ConsoleLog.Level level;
    private final Path path;

    public FileLogCreator(ConsoleLog.Level level, String filePath) {
        this.level = level;
        this.path = Paths.get(filePath, new String[0]);
        FileLogCreator.prepareLogFile(this.path);
    }

    public Log createLogger(Class<?> clazz) {
        return new FileLog(this.path, this.level);
    }

    private static void prepareLogFile(Path path) {
        try {
            Files.write(path, "".getBytes(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException exception) {
            throw new FlywayException("Could not initialize log file at " + path + ".", (Throwable)exception);
        }
    }
}

