/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.io.PrintStream;
import org.flywaydb.core.api.logging.Log;

class PrintStreamLog
implements Log {
    private final Level level;
    private final PrintStream outStream;
    private final PrintStream errStream;

    public PrintStreamLog(Level level, PrintStream outStream, PrintStream errStream) {
        this.level = level;
        this.outStream = outStream;
        this.errStream = errStream;
    }

    public boolean isDebugEnabled() {
        return this.level == Level.DEBUG;
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.outStream.println("DEBUG: " + message);
        }
    }

    public void info(String message) {
        if (this.level.compareTo(Level.INFO) <= 0) {
            this.outStream.println(message);
        }
    }

    public void warn(String message) {
        this.outStream.println("WARNING: " + message);
    }

    public void error(String message) {
        this.errStream.println("ERROR: " + message);
    }

    public void error(String message, Exception e) {
        this.errStream.println("ERROR: " + message);
        e.printStackTrace(this.errStream);
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN;

    }
}

