/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import org.flywaydb.commandline.PrintStreamLog;

class CommandLineFlags {
    private boolean isSuppressPrompt;
    private boolean printVersionAndExit;
    private boolean jsonOutput;
    private boolean printUsage;
    private PrintStreamLog.Level logLevel;

    private CommandLineFlags(boolean isSuppressPrompt, boolean printVersionAndExit, boolean jsonOutput, boolean printUsage, PrintStreamLog.Level logLevel) {
        this.isSuppressPrompt = isSuppressPrompt;
        this.printVersionAndExit = printVersionAndExit;
        this.jsonOutput = jsonOutput;
        this.printUsage = printUsage;
        this.logLevel = logLevel;
    }

    public boolean getIsSuppressPrompt() {
        return this.isSuppressPrompt;
    }

    public boolean getPrintVersionAndExit() {
        return this.printVersionAndExit;
    }

    public boolean getJsonOutput() {
        return this.jsonOutput;
    }

    public boolean getPrintUsage() {
        return this.printUsage;
    }

    public PrintStreamLog.Level getLogLevel() {
        return this.logLevel;
    }

    public static CommandLineFlags createFromArguments(String[] args) {
        boolean isSuppressPrompt = false;
        boolean printVersionAndExit = false;
        boolean jsonOutput = false;
        boolean printUsage = false;
        PrintStreamLog.Level logLevel = PrintStreamLog.Level.INFO;
        if (CommandLineFlags.isFlagSet(args, "-n")) {
            isSuppressPrompt = true;
        }
        if (CommandLineFlags.isFlagSet(args, "-v")) {
            printVersionAndExit = true;
        }
        if (CommandLineFlags.isFlagSet(args, "-?")) {
            printUsage = true;
        }
        if (CommandLineFlags.isFlagSet(args, "-X")) {
            logLevel = PrintStreamLog.Level.DEBUG;
        }
        if (CommandLineFlags.isFlagSet(args, "-q")) {
            logLevel = PrintStreamLog.Level.WARN;
        }
        if (CommandLineFlags.isFlagSet(args, "-json")) {
            jsonOutput = true;
        }
        return new CommandLineFlags(isSuppressPrompt, printVersionAndExit, jsonOutput, printUsage, logLevel);
    }

    private static boolean isFlagSet(String[] args, String flag) {
        for (String arg : args) {
            if (!flag.equals(arg)) continue;
            return true;
        }
        return false;
    }
}

