/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.io.Console;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flywaydb.commandline.ConsoleLog;
import org.flywaydb.commandline.ConsoleLogCreator;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class Main {
    private static Log LOG;
    private static List<String> VALID_OPERATIONS_AND_FLAGS;

    static void initLogging(ConsoleLog.Level level) {
        LogFactory.setFallbackLogCreator((LogCreator)new ConsoleLogCreator(level));
        LOG = LogFactory.getLog(Main.class);
    }

    public static void main(String[] args) {
        ConsoleLog.Level logLevel = Main.getLogLevel(args);
        Main.initLogging(logLevel);
        try {
            List<String> operations;
            if (Main.isPrintVersionAndExit(args)) {
                Main.printVersion();
                System.exit(0);
            }
            if ((operations = Main.determineOperations(args)).isEmpty() || operations.contains("help") || Main.isFlagSet(args, "-?")) {
                Main.printUsage();
                return;
            }
            Main.validateArgs(args);
            Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
            HashMap<String, String> config = new HashMap<String, String>();
            Main.initializeDefaults(config);
            Main.loadConfigurationFromConfigFiles(config, args, envVars);
            config.putAll(envVars);
            Main.overrideConfigurationWithArgs(config, args);
            if (!Main.isSuppressPrompt(args)) {
                Main.promptForCredentialsIfMissing(config);
            }
            ConfigUtils.dumpConfiguration(config);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ArrayList<File> jarFiles = new ArrayList<File>();
            jarFiles.addAll(Main.getJdbcDriverJarFiles());
            jarFiles.addAll(Main.getJavaMigrationJarFiles(config));
            if (!jarFiles.isEmpty()) {
                classLoader = ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)classLoader, jarFiles);
            }
            Main.filterProperties(config);
            Flyway flyway = Flyway.configure((ClassLoader)classLoader).configuration(config).load();
            for (String operation : operations) {
                Main.executeOperation(flyway, operation);
            }
        }
        catch (Exception e) {
            if (logLevel == ConsoleLog.Level.DEBUG) {
                LOG.error("Unexpected error", e);
            } else if (e instanceof FlywayException) {
                LOG.error(e.getMessage());
            } else {
                LOG.error(e.toString());
            }
            System.exit(1);
        }
    }

    static void validateArgs(String[] args) {
        for (String arg : args) {
            if (Main.isPropertyArgument(arg) || VALID_OPERATIONS_AND_FLAGS.contains(arg)) continue;
            throw new FlywayException("Invalid argument: " + arg);
        }
    }

    private static boolean isPrintVersionAndExit(String[] args) {
        return Main.isFlagSet(args, "-v");
    }

    private static boolean isSuppressPrompt(String[] args) {
        return Main.isFlagSet(args, "-n");
    }

    private static boolean isFlagSet(String[] args, String flag) {
        for (String arg : args) {
            if (!flag.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static void executeOperation(Flyway flyway, String operation) {
        if ("clean".equals(operation)) {
            flyway.clean();
        } else if ("baseline".equals(operation)) {
            flyway.baseline();
        } else if ("migrate".equals(operation)) {
            flyway.migrate();
        } else if ("undo".equals(operation)) {
            flyway.undo();
        } else if ("validate".equals(operation)) {
            flyway.validate();
        } else if ("info".equals(operation)) {
            MigrationInfoService info = flyway.info();
            MigrationInfo current = info.current();
            MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
            LOG.info("Schema version: " + currentSchemaVersion);
            LOG.info("");
            LOG.info(MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])info.all()));
        } else if ("repair".equals(operation)) {
            flyway.repair();
        } else {
            LOG.error("Invalid operation: " + operation);
            Main.printUsage();
            System.exit(1);
        }
    }

    private static ConsoleLog.Level getLogLevel(String[] args) {
        for (String arg : args) {
            if ("-X".equals(arg)) {
                return ConsoleLog.Level.DEBUG;
            }
            if (!"-q".equals(arg)) continue;
            return ConsoleLog.Level.WARN;
        }
        return ConsoleLog.Level.INFO;
    }

    private static void initializeDefaults(Map<String, String> config) {
        config.put("flyway.locations", "filesystem:" + new File(Main.getInstallationDir(), "sql").getAbsolutePath());
        config.put("flyway.jarDirs", new File(Main.getInstallationDir(), "jars").getAbsolutePath());
    }

    private static void filterProperties(Map<String, String> config) {
        config.remove("flyway.jarDirs");
        config.remove("flyway.configFiles");
        config.remove("flyway.configFileEncoding");
    }

    private static void printVersion() {
        VersionPrinter.printVersionOnly();
        LOG.info("");
        LOG.debug("Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        LOG.debug(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "\n");
    }

    private static void printUsage() {
        LOG.info("Usage");
        LOG.info("=====");
        LOG.info("");
        LOG.info("flyway [options] command");
        LOG.info("");
        LOG.info("By default, the configuration will be read from conf/flyway.conf.");
        LOG.info("Options passed from the command-line override the configuration.");
        LOG.info("");
        LOG.info("Commands");
        LOG.info("--------");
        LOG.info("migrate  : Migrates the database");
        LOG.info("clean    : Drops all objects in the configured schemas");
        LOG.info("info     : Prints the information about applied, current and pending migrations");
        LOG.info("validate : Validates the applied migrations against the ones on the classpath");
        LOG.info("undo     : [pro] Undoes the most recently applied versioned migration");
        LOG.info("baseline : Baselines an existing database at the baselineVersion");
        LOG.info("repair   : Repairs the schema history table");
        LOG.info("");
        LOG.info("Options (Format: -key=value)");
        LOG.info("-------");
        LOG.info("driver                       : Fully qualified classname of the JDBC driver");
        LOG.info("url                          : Jdbc url to use to connect to the database");
        LOG.info("user                         : User to use to connect to the database");
        LOG.info("password                     : Password to use to connect to the database");
        LOG.info("connectRetries               : Maximum number of retries when attempting to connect to the database");
        LOG.info("initSql                      : SQL statements to run to initialize a new database connection");
        LOG.info("schemas                      : Comma-separated list of the schemas managed by Flyway");
        LOG.info("table                        : Name of Flyway's schema history table");
        LOG.info("locations                    : Classpath locations to scan recursively for migrations");
        LOG.info("resolvers                    : Comma-separated list of custom MigrationResolvers");
        LOG.info("skipDefaultResolvers         : Skips default resolvers (jdbc, sql and Spring-jdbc)");
        LOG.info("sqlMigrationPrefix           : File name prefix for versioned SQL migrations");
        LOG.info("undoSqlMigrationPrefix       : [pro] File name prefix for undo SQL migrations");
        LOG.info("repeatableSqlMigrationPrefix : File name prefix for repeatable SQL migrations");
        LOG.info("sqlMigrationSeparator        : File name separator for SQL migrations");
        LOG.info("sqlMigrationSuffixes         : Comma-separated list of file name suffixes for SQL migrations");
        LOG.info("stream                       : [pro] Stream SQL migrations when executing them");
        LOG.info("batch                        : [pro] Batch SQL statements when executing them");
        LOG.info("mixed                        : Allow mixing transactional and non-transactional statements");
        LOG.info("encoding                     : Encoding of SQL migrations");
        LOG.info("placeholderReplacement       : Whether placeholders should be replaced");
        LOG.info("placeholders                 : Placeholders to replace in sql migrations");
        LOG.info("placeholderPrefix            : Prefix of every placeholder");
        LOG.info("placeholderSuffix            : Suffix of every placeholder");
        LOG.info("installedBy                  : Username that will be recorded in the schema history table");
        LOG.info("target                       : Target version up to which Flyway should use migrations");
        LOG.info("outOfOrder                   : Allows migrations to be run \"out of order\"");
        LOG.info("callbacks                    : Comma-separated list of FlywayCallback classes");
        LOG.info("skipDefaultCallbacks         : Skips default callbacks (sql)");
        LOG.info("validateOnMigrate            : Validate when running migrate");
        LOG.info("ignoreMissingMigrations      : Allow missing migrations when validating");
        LOG.info("ignoreIgnoredMigrations      : Allow ignored migrations when validating");
        LOG.info("ignorePendingMigrations      : Allow pending migrations when validating");
        LOG.info("ignoreFutureMigrations       : Allow future migrations when validating");
        LOG.info("cleanOnValidationError       : Automatically clean on a validation error");
        LOG.info("cleanDisabled                : Whether to disable clean");
        LOG.info("baselineVersion              : Version to tag schema with when executing baseline");
        LOG.info("baselineDescription          : Description to tag schema with when executing baseline");
        LOG.info("baselineOnMigrate            : Baseline on migrate against uninitialized non-empty schema");
        LOG.info("configFiles                  : Comma-separated list of config files to use");
        LOG.info("configFileEncoding           : Encoding to use when loading the config files");
        LOG.info("jarDirs                      : Comma-separated list of dirs for Jdbc drivers & Java migrations");
        LOG.info("dryRunOutput                 : [pro] File where to output the SQL statements of a migration dry run");
        LOG.info("errorOverrides               : [pro] Rules to override specific SQL states and errors codes");
        LOG.info("oracle.sqlplus               : [pro] Enable Oracle SQL*Plus command support");
        LOG.info("licenseKey                   : [pro] Your Flyway license key");
        LOG.info("");
        LOG.info("Flags");
        LOG.info("-----");
        LOG.info("-X          : Print debug output");
        LOG.info("-q          : Suppress all output, except for errors and warnings");
        LOG.info("-n          : Suppress prompting for a user and password");
        LOG.info("-v          : Print the Flyway version and exit");
        LOG.info("-?          : Print this usage info and exit");
        LOG.info("-community  : Run the Flyway Community Edition (default)");
        LOG.info("-pro        : Run the Flyway Pro Edition");
        LOG.info("-enterprise : Run the Flyway Enterprise Edition");
        LOG.info("");
        LOG.info("Example");
        LOG.info("-------");
        LOG.info("flyway -user=myuser -password=s3cr3t -url=jdbc:h2:mem -placeholders.abc=def migrate");
        LOG.info("");
        LOG.info("More info at https://flywaydb.org/documentation/commandline");
    }

    private static List<File> getJdbcDriverJarFiles() {
        File driversDir = new File(Main.getInstallationDir(), "drivers");
        File[] files = driversDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files == null) {
            LOG.debug("Directory for Jdbc Drivers not found: " + driversDir.getAbsolutePath());
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private static List<File> getJavaMigrationJarFiles(Map<String, String> config) {
        String jarDirs = config.get("flyway.jarDirs");
        if (!StringUtils.hasLength((String)jarDirs)) {
            return Collections.emptyList();
        }
        jarDirs = jarDirs.replace(File.pathSeparator, ",");
        String[] dirs = StringUtils.tokenizeToStringArray((String)jarDirs, (String)",");
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (String dirName : dirs) {
            File dir = new File(dirName);
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (files == null) {
                LOG.error("Directory for Java Migrations not found: " + dirName);
                System.exit(1);
            }
            jarFiles.addAll(Arrays.asList(files));
        }
        return jarFiles;
    }

    static void loadConfigurationFromConfigFiles(Map<String, String> config, String[] args, Map<String, String> envVars) {
        String encoding = Main.determineConfigurationFileEncoding(args, envVars);
        config.putAll(ConfigUtils.loadConfigurationFile((File)new File(Main.getInstallationDir() + "/conf/" + "flyway.conf"), (String)encoding, (boolean)false));
        config.putAll(ConfigUtils.loadConfigurationFile((File)new File(System.getProperty("user.home") + "/" + "flyway.conf"), (String)encoding, (boolean)false));
        config.putAll(ConfigUtils.loadConfigurationFile((File)new File("flyway.conf"), (String)encoding, (boolean)false));
        for (File configFile : Main.determineConfigFilesFromArgs(args, envVars)) {
            config.putAll(ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
    }

    private static void promptForCredentialsIfMissing(Map<String, String> config) {
        Console console = System.console();
        if (console == null) {
            return;
        }
        if (!config.containsKey("flyway.url")) {
            return;
        }
        if (!config.containsKey("flyway.user")) {
            config.put("flyway.user", console.readLine("Database user: ", new Object[0]));
        }
        if (!config.containsKey("flyway.password")) {
            char[] password = console.readPassword("Database password: ", new Object[0]);
            config.put("flyway.password", password == null ? "" : String.valueOf(password));
        }
    }

    private static List<File> determineConfigFilesFromArgs(String[] args, Map<String, String> envVars) {
        ArrayList<File> configFiles = new ArrayList<File>();
        if (envVars.containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)envVars.get("flyway.configFiles"), (String)",")) {
                configFiles.add(new File(file));
            }
            return configFiles;
        }
        for (String arg : args) {
            String argValue = Main.getArgumentValue(arg);
            if (!Main.isPropertyArgument(arg) || !"flyway.configFiles".equals(Main.getArgumentProperty(arg))) continue;
            for (String file : StringUtils.tokenizeToStringArray((String)argValue, (String)",")) {
                configFiles.add(new File(file));
            }
        }
        return configFiles;
    }

    private static String getInstallationDir() {
        String path = ClassUtils.getLocationOnDisk(Main.class);
        return new File(path).getParentFile().getParentFile().getParentFile().getAbsolutePath();
    }

    private static String determineConfigurationFileEncoding(String[] args, Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg) || !"flyway.configFileEncoding".equals(Main.getArgumentProperty(arg))) continue;
            return Main.getArgumentValue(arg);
        }
        return "UTF-8";
    }

    static void overrideConfigurationWithArgs(Map<String, String> config, String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg)) continue;
            config.put(Main.getArgumentProperty(arg), Main.getArgumentValue(arg));
        }
    }

    static boolean isPropertyArgument(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    static String getArgumentProperty(String arg) {
        int index = arg.indexOf("=");
        return "flyway." + arg.substring(1, index);
    }

    static String getArgumentValue(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static List<String> determineOperations(String[] args) {
        ArrayList<String> operations = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            operations.add(arg);
        }
        return operations;
    }

    static {
        VALID_OPERATIONS_AND_FLAGS = Arrays.asList("-X", "-q", "-n", "-v", "-?", "-community", "-pro", "-enterprise", "help", "migrate", "clean", "info", "validate", "undo", "baseline", "repair");
    }
}

