/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.io.Console;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogCreator;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.VersionPrinter;
import org.flywaydb.core.internal.util.logging.console.ConsoleLog;
import org.flywaydb.core.internal.util.logging.console.ConsoleLogCreator;

public class Main {
    private static Log LOG;
    private static List<String> VALID_OPERATIONS_AND_FLAGS;

    static void initLogging(ConsoleLog.Level level) {
        LogFactory.setFallbackLogCreator((LogCreator)new ConsoleLogCreator(level));
        LOG = LogFactory.getLog(Main.class);
    }

    public static void main(String[] args) {
        ConsoleLog.Level logLevel = Main.getLogLevel(args);
        Main.initLogging(logLevel);
        try {
            List<String> operations;
            Main.printVersion();
            if (Main.isPrintVersionAndExit(args)) {
                System.exit(0);
            }
            if ((operations = Main.determineOperations(args)).isEmpty() || operations.contains("help") || Main.isFlagSet(args, "-?")) {
                Main.printUsage();
                return;
            }
            Main.validateArgs(args);
            Map envVars = ConfigUtils.environmentVariablesToPropertyMap();
            Properties properties = new Properties();
            Main.initializeDefaults(properties);
            Main.loadConfigurationFromConfigFiles(properties, args, envVars);
            properties.putAll((Map<?, ?>)envVars);
            Main.overrideConfigurationWithArgs(properties, args);
            if (!Main.isSuppressPrompt(args)) {
                Main.promptForCredentialsIfMissing(properties);
            }
            Main.dumpConfiguration(properties);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            classLoader = Main.loadJdbcDrivers(classLoader);
            classLoader = Main.loadJavaMigrationsFromJarDirs(classLoader, properties);
            Flyway flyway = new Flyway(classLoader);
            Main.filterProperties(properties);
            flyway.configure(properties);
            for (String operation : operations) {
                Main.executeOperation(flyway, operation);
            }
        }
        catch (Exception e) {
            if (logLevel == ConsoleLog.Level.DEBUG) {
                LOG.error("Unexpected error", e);
            } else if (e instanceof FlywayException) {
                LOG.error(e.getMessage());
            } else {
                LOG.error(e.toString());
            }
            System.exit(1);
        }
    }

    static void validateArgs(String[] args) {
        for (String arg : args) {
            if (Main.isPropertyArgument(arg) || VALID_OPERATIONS_AND_FLAGS.contains(arg)) continue;
            throw new FlywayException("Invalid argument: " + arg);
        }
    }

    private static boolean isPrintVersionAndExit(String[] args) {
        return Main.isFlagSet(args, "-v");
    }

    private static boolean isSuppressPrompt(String[] args) {
        return Main.isFlagSet(args, "-n");
    }

    private static boolean isFlagSet(String[] args, String flag) {
        for (String arg : args) {
            if (!flag.equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static void executeOperation(Flyway flyway, String operation) {
        if ("clean".equals(operation)) {
            flyway.clean();
        } else if ("baseline".equals(operation)) {
            flyway.baseline();
        } else if ("migrate".equals(operation)) {
            flyway.migrate();
        } else if ("undo".equals(operation)) {
            flyway.undo();
        } else if ("validate".equals(operation)) {
            flyway.validate();
        } else if ("info".equals(operation)) {
            MigrationInfoService info = flyway.info();
            MigrationInfo current = info.current();
            MigrationVersion currentSchemaVersion = current == null ? MigrationVersion.EMPTY : current.getVersion();
            LOG.info("Schema version: " + currentSchemaVersion);
            LOG.info("");
            LOG.info(MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])info.all()));
        } else if ("repair".equals(operation)) {
            flyway.repair();
        } else {
            LOG.error("Invalid operation: " + operation);
            Main.printUsage();
            System.exit(1);
        }
    }

    private static ConsoleLog.Level getLogLevel(String[] args) {
        for (String arg : args) {
            if ("-X".equals(arg)) {
                return ConsoleLog.Level.DEBUG;
            }
            if (!"-q".equals(arg)) continue;
            return ConsoleLog.Level.WARN;
        }
        return ConsoleLog.Level.INFO;
    }

    private static void initializeDefaults(Properties properties) {
        properties.put("flyway.locations", "filesystem:" + new File(Main.getInstallationDir(), "sql").getAbsolutePath());
        properties.put("flyway.jarDirs", new File(Main.getInstallationDir(), "jars").getAbsolutePath());
    }

    private static void filterProperties(Properties properties) {
        properties.remove("flyway.jarDirs");
        properties.remove("flyway.configFile");
        properties.remove("flyway.configFiles");
        properties.remove("flyway.configFileEncoding");
    }

    private static void printVersion() {
        VersionPrinter.printVersion();
        LOG.info("");
        LOG.debug("Java " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        LOG.debug(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + "\n");
    }

    private static void printUsage() {
        LOG.info("Usage");
        LOG.info("=====");
        LOG.info("");
        LOG.info("flyway [options] command");
        LOG.info("");
        LOG.info("By default, the configuration will be read from conf/flyway.conf.");
        LOG.info("Options passed from the command-line override the configuration.");
        LOG.info("");
        LOG.info("Commands");
        LOG.info("--------");
        LOG.info("migrate  : Migrates the database");
        LOG.info("clean    : Drops all objects in the configured schemas");
        LOG.info("info     : Prints the information about applied, current and pending migrations");
        LOG.info("validate : Validates the applied migrations against the ones on the classpath");
        LOG.info("undo     : Undoes the most recently applied versioned migration");
        LOG.info("baseline : Baselines an existing database at the baselineVersion");
        LOG.info("repair   : Repairs the schema history table");
        LOG.info("");
        LOG.info("Options (Format: -key=value)");
        LOG.info("-------");
        LOG.info("driver                       : Fully qualified classname of the JDBC driver");
        LOG.info("url                          : Jdbc url to use to connect to the database");
        LOG.info("user                         : User to use to connect to the database");
        LOG.info("password                     : Password to use to connect to the database");
        LOG.info("schemas                      : Comma-separated list of the schemas managed by Flyway");
        LOG.info("table                        : Name of Flyway's schema history table");
        LOG.info("locations                    : Classpath locations to scan recursively for migrations");
        LOG.info("resolvers                    : Comma-separated list of custom MigrationResolvers");
        LOG.info("skipDefaultResolvers         : Skips default resolvers (jdbc, sql and Spring-jdbc)");
        LOG.info("sqlMigrationPrefix           : File name prefix for versioned SQL migrations");
        LOG.info("undoSqlMigrationPrefix       : File name prefix for undo SQL migrations");
        LOG.info("repeatableSqlMigrationPrefix : File name prefix for repeatable SQL migrations");
        LOG.info("sqlMigrationSeparator        : File name separator for sql migrations");
        LOG.info("sqlMigrationSuffixes         : Comma-separated list of file name suffixes for sql migrations");
        LOG.info("mixed                        : Allow mixing transactional and non-transactional statements");
        LOG.info("encoding                     : Encoding of sql migrations");
        LOG.info("placeholderReplacement       : Whether placeholders should be replaced");
        LOG.info("placeholders                 : Placeholders to replace in sql migrations");
        LOG.info("placeholderPrefix            : Prefix of every placeholder");
        LOG.info("placeholderSuffix            : Suffix of every placeholder");
        LOG.info("installedBy                  : Username that will be recorded in the schema history table");
        LOG.info("target                       : Target version up to which Flyway should use migrations");
        LOG.info("outOfOrder                   : Allows migrations to be run \"out of order\"");
        LOG.info("callbacks                    : Comma-separated list of FlywayCallback classes");
        LOG.info("skipDefaultCallbacks         : Skips default callbacks (sql)");
        LOG.info("validateOnMigrate            : Validate when running migrate");
        LOG.info("ignoreMissingMigrations      : Allow missing migrations when validating");
        LOG.info("ignoreFutureMigrations       : Allow future migrations when validating");
        LOG.info("cleanOnValidationError       : Automatically clean on a validation error");
        LOG.info("cleanDisabled                : Whether to disable clean");
        LOG.info("baselineVersion              : Version to tag schema with when executing baseline");
        LOG.info("baselineDescription          : Description to tag schema with when executing baseline");
        LOG.info("baselineOnMigrate            : Baseline on migrate against uninitialized non-empty schema");
        LOG.info("configFiles                  : Comma-separated list of config files to use");
        LOG.info("configFileEncoding           : Encoding to use when loading the config files");
        LOG.info("jarDirs                      : Comma-separated list of dirs for Jdbc drivers & Java migrations");
        LOG.info("dryRunOutput                 : File where to output the SQL statements of a migration dry run");
        LOG.info("errorHandlers                : Comma-separated list of handlers for errors and warnings");
        LOG.info("");
        LOG.info("Flags");
        LOG.info("-----");
        LOG.info("-X : Print debug output");
        LOG.info("-q : Suppress all output, except for errors and warnings");
        LOG.info("-n : Suppress prompting for a user and password");
        LOG.info("-v : Print the Flyway version and exit");
        LOG.info("-? : Print this usage info and exit");
        LOG.info("");
        LOG.info("Example");
        LOG.info("-------");
        LOG.info("flyway -user=myuser -password=s3cr3t -url=jdbc:h2:mem -placeholders.abc=def migrate");
        LOG.info("");
        LOG.info("More info at https://flywaydb.org/documentation/commandline");
    }

    private static ClassLoader loadJdbcDrivers(ClassLoader classLoader) throws IOException {
        File driversDir = new File(Main.getInstallationDir(), "drivers");
        File[] files = driversDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files == null) {
            LOG.error("Directory for Jdbc Drivers not found: " + driversDir.getAbsolutePath());
            System.exit(1);
        }
        for (File file : files) {
            classLoader = ClassUtils.addJarOrDirectoryToClasspath((ClassLoader)classLoader, (String)file.getPath());
        }
        return classLoader;
    }

    private static ClassLoader loadJavaMigrationsFromJarDirs(ClassLoader classLoader, Properties properties) throws IOException {
        String[] dirs;
        String jarDirs = properties.getProperty("flyway.jarDirs");
        if (!StringUtils.hasLength((String)jarDirs)) {
            return classLoader;
        }
        jarDirs = jarDirs.replace(File.pathSeparator, ",");
        for (String dirName : dirs = StringUtils.tokenizeToStringArray((String)jarDirs, (String)",")) {
            File dir = new File(dirName);
            File[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (files == null) {
                LOG.error("Directory for Java Migrations not found: " + dirName);
                System.exit(1);
            }
            for (File file : files) {
                classLoader = ClassUtils.addJarOrDirectoryToClasspath((ClassLoader)classLoader, (String)file.getPath());
            }
        }
        return classLoader;
    }

    static void loadConfigurationFromConfigFiles(Properties properties, String[] args, Map<String, String> envVars) {
        String encoding = Main.determineConfigurationFileEncoding(args, envVars);
        properties.putAll((Map<?, ?>)ConfigUtils.loadConfigurationFile((File)new File(Main.getInstallationDir() + "/conf/" + "flyway.conf"), (String)encoding, (boolean)false));
        properties.putAll((Map<?, ?>)ConfigUtils.loadConfigurationFile((File)new File(System.getProperty("user.home") + "/" + "flyway.conf"), (String)encoding, (boolean)false));
        properties.putAll((Map<?, ?>)ConfigUtils.loadConfigurationFile((File)new File("flyway.conf"), (String)encoding, (boolean)false));
        for (File configFile : Main.determineConfigFilesFromArgs(args, envVars)) {
            properties.putAll((Map<?, ?>)ConfigUtils.loadConfigurationFile((File)configFile, (String)encoding, (boolean)true));
        }
    }

    private static void promptForCredentialsIfMissing(Properties properties) {
        Console console = System.console();
        if (console == null) {
            return;
        }
        if (!properties.containsKey("flyway.url")) {
            return;
        }
        if (!properties.containsKey("flyway.user")) {
            properties.put("flyway.user", console.readLine("Database user: ", new Object[0]));
        }
        if (!properties.containsKey("flyway.password")) {
            char[] password = console.readPassword("Database password: ", new Object[0]);
            properties.put("flyway.password", password == null ? "" : String.valueOf(password));
        }
    }

    private static void dumpConfiguration(Properties properties) {
        LOG.debug("Using configuration:");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String value = entry.getValue().toString();
            value = "flyway.password".equals(entry.getKey()) ? StringUtils.trimOrPad((String)"", (int)value.length(), (char)'*') : value;
            LOG.debug(entry.getKey() + " -> " + value);
        }
    }

    private static List<File> determineConfigFilesFromArgs(String[] args, Map<String, String> envVars) {
        ArrayList<File> configFiles = new ArrayList<File>();
        if (envVars.containsKey("flyway.configFiles")) {
            for (String file : StringUtils.tokenizeToStringArray((String)envVars.get("flyway.configFiles"), (String)",")) {
                configFiles.add(new File(file));
            }
            return configFiles;
        }
        for (String arg : args) {
            String argValue = Main.getArgumentValue(arg);
            if (Main.isPropertyArgument(arg) && "flyway.configFile".equals(Main.getArgumentProperty(arg))) {
                LOG.warn("-configFile is deprecated and will be removed in Flyway 6.0. Use -configFiles instead.");
                configFiles.add(new File(argValue));
            }
            if (!Main.isPropertyArgument(arg) || !"flyway.configFiles".equals(Main.getArgumentProperty(arg))) continue;
            for (String file : StringUtils.tokenizeToStringArray((String)argValue, (String)",")) {
                configFiles.add(new File(file));
            }
        }
        return configFiles;
    }

    private static String getInstallationDir() {
        String path = ClassUtils.getLocationOnDisk(Main.class);
        return new File(path).getParentFile().getParentFile().getAbsolutePath();
    }

    private static String determineConfigurationFileEncoding(String[] args, Map<String, String> envVars) {
        if (envVars.containsKey("flyway.configFileEncoding")) {
            return envVars.get("flyway.configFileEncoding");
        }
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg) || !"flyway.configFileEncoding".equals(Main.getArgumentProperty(arg))) continue;
            return Main.getArgumentValue(arg);
        }
        return "UTF-8";
    }

    static void overrideConfigurationWithArgs(Properties properties, String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg)) continue;
            properties.put(Main.getArgumentProperty(arg), Main.getArgumentValue(arg));
        }
    }

    static boolean isPropertyArgument(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    static String getArgumentProperty(String arg) {
        int index = arg.indexOf("=");
        return "flyway." + arg.substring(1, index);
    }

    static String getArgumentValue(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static List<String> determineOperations(String[] args) {
        ArrayList<String> operations = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            operations.add(arg);
        }
        return operations;
    }

    static {
        VALID_OPERATIONS_AND_FLAGS = Arrays.asList("-X", "-q", "-n", "-v", "-?", "help", "migrate", "clean", "info", "validate", "undo", "baseline", "repair");
    }
}

