/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.logging.console;

import lombok.Generated;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.logging.LogLevel;

public class ConsoleLog
implements Log {
    public void debug(String message) {
        if (LogFactory.isDebugEnabled()) {
            System.out.println("DEBUG: " + message);
        }
    }

    public void info(String message) {
        if (!LogFactory.isQuietMode()) {
            System.out.println(message);
        }
    }

    public void notice(String message) {
        if (!LogFactory.isQuietMode()) {
            System.out.println(message);
        }
    }

    public void warn(String message) {
        System.out.println("WARNING: " + message);
    }

    public void error(String message) {
        System.err.println("ERROR: " + message);
    }

    public void error(String message, Exception e) {
        System.err.println("ERROR: " + message);
        e.printStackTrace(System.err);
    }

    @Generated
    public ConsoleLog() {
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN;


        public LogLevel toLogLevel() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> LogLevel.DEBUG;
                case 1 -> LogLevel.INFO;
                case 2 -> LogLevel.WARN;
            };
        }
    }
}

