/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.logging.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;

public class FileLog
implements Log {
    private final Path path;

    public void debug(String message) {
        if (LogFactory.isDebugEnabled()) {
            this.writeLogMessage("DEBUG", message);
        }
    }

    public void info(String message) {
        if (!LogFactory.isQuietMode()) {
            this.writeLogMessage(message);
        }
    }

    public void warn(String message) {
        this.writeLogMessage("WARNING", message);
    }

    public void error(String message) {
        this.writeLogMessage("ERROR", message);
    }

    public void error(String message, Exception e) {
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        String stackTrace = stringWriter.toString();
        this.writeLogMessage("ERROR", message);
        this.writeLogMessage(stackTrace);
    }

    public void notice(String message) {
    }

    private void writeLogMessage(String prefix, String message) {
        String logMessage = prefix + ": " + message;
        this.writeLogMessage(logMessage);
    }

    private void writeLogMessage(String logMessage) {
        try {
            Files.write(this.path, (logMessage + "\n").getBytes(), StandardOpenOption.APPEND, StandardOpenOption.WRITE);
        }
        catch (IOException exception) {
            throw new FlywayException("Could not write to file at " + String.valueOf(this.path) + ".", (Throwable)exception);
        }
    }

    @Generated
    public FileLog(Path path) {
        this.path = path;
    }
}

