/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import java.io.File;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.flywaydb.commandline.logging.console.ConsoleLog;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.CommandExtension;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.StringUtils;

public class CommandLineArguments {
    @Generated
    private static final Log LOG = LogFactory.getLog(CommandLineArguments.class);
    private static final String COMMUNITY_FALLBACK_FLAG = "-communityFallback";
    private static final String DEBUG_FLAG = "-X";
    private static final String QUIET_FLAG = "-q";
    private static final List<String> PRINT_VERSION_AND_EXIT_FLAGS = Arrays.asList("-v", "--version");
    private static final List<String> PRINT_USAGE_FLAGS = Arrays.asList("-?", "-h", "--help");
    private static final String SKIP_CHECK_FOR_UPDATE_FLAG = "-skipCheckForUpdate";
    private static final String MIGRATIONS_IDS_FLAG = "-migrationIds";
    private static final String OUTPUT_FILE = "outputFile";
    private static final String OUTPUT_TYPE = "outputType";
    private static final String OUTPUT_LOGS_IN_JSON = "outputLogsInJson";
    private static final String CONFIG_FILE_ENCODING = "configFileEncoding";
    private static final String CONFIG_FILES = "configFiles";
    private static final String COLOR = "color";
    private static final String WORKING_DIRECTORY = "workingDirectory";
    private static final String INFO_SINCE_DATE = "infoSinceDate";
    private static final String INFO_UNTIL_DATE = "infoUntilDate";
    private static final String INFO_SINCE_VERSION = "infoSinceVersion";
    private static final String INFO_UNTIL_VERSION = "infoUntilVersion";
    private static final String INFO_OF_STATE = "infoOfState";
    private static final Collection<String> COMMAND_LINE_ONLY_OPTIONS = new HashSet<String>(Arrays.asList("outputFile", "workingDirectory", "infoSinceDate", "infoUntilDate", "infoSinceVersion", "infoUntilVersion", "infoOfState"));
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm");
    private static final List<String> VALID_OPERATIONS_AND_FLAGS = CommandLineArguments.getValidOperationsAndFlags();
    private final PluginRegister pluginRegister;
    private final String[] args;

    private static Collection<String> getParametersByNamespace(String namespace) {
        return new ClassicConfiguration().getPluginRegister().getInstancesOf(ConfigurationExtension.class).stream().filter(p -> p.getNamespace().equalsIgnoreCase(namespace)).flatMap(ext -> Arrays.stream(ext.getClass().getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).flatMap(f -> {
            if (CommandLineArguments.shouldNotExpand(f.getType())) {
                return Stream.of(f.getName());
            }
            return Arrays.stream(f.getType().getDeclaredFields()).filter(subfield -> !Modifier.isStatic(subfield.getModifiers())).map(subfield -> f.getName() + "." + subfield.getName());
        })).collect(Collectors.toList());
    }

    public CommandLineArguments(PluginRegister pluginRegister, String ... args) {
        this.pluginRegister = pluginRegister;
        this.args = (String[])Arrays.stream(args).filter(StringUtils::hasText).toArray(String[]::new);
    }

    private static boolean shouldNotExpand(Class<?> c) {
        String pn = c.getPackageName();
        return c.isEnum() || pn.startsWith("java.") || pn.startsWith("javax.") || pn.startsWith("jdk.");
    }

    private static List<String> getValidOperationsAndFlags() {
        ArrayList<String> operationsAndFlags = new ArrayList<String>(Arrays.asList(DEBUG_FLAG, QUIET_FLAG, COMMUNITY_FALLBACK_FLAG, SKIP_CHECK_FOR_UPDATE_FLAG, MIGRATIONS_IDS_FLAG, OUTPUT_LOGS_IN_JSON, "help", "migrate", "clean", "info", "validate", "undo", "baseline", "repair"));
        operationsAndFlags.addAll(PRINT_VERSION_AND_EXIT_FLAGS);
        operationsAndFlags.addAll(PRINT_USAGE_FLAGS);
        return operationsAndFlags;
    }

    private static boolean isFlagSet(String[] args, String flag) {
        return Arrays.asList(args).contains(flag);
    }

    private static boolean isFlagSet(String[] args, List<String> flags) {
        return flags.stream().anyMatch(flag -> CommandLineArguments.isFlagSet(args, flag));
    }

    private static String getArgumentValue(String argName, String[] allArgs) {
        return Arrays.stream(allArgs).filter(arg -> arg.startsWith("-" + argName + "=")).findFirst().map(CommandLineArguments::parseConfigurationOptionValueFromArg).orElse("");
    }

    private static String parseConfigurationOptionValueFromArg(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private List<String> getOperationsFromArgs(String[] args) {
        List<String> flags = Arrays.stream(args).filter(x -> x.startsWith("-")).toList();
        List<String> operations = Arrays.stream(args).filter(arg -> !arg.startsWith("-")).collect(Collectors.toList());
        this.pluginRegister.getInstancesOf(CommandExtension.class).forEach(extension -> flags.stream().map(arg_0 -> ((CommandExtension)extension).getCommandForFlag(arg_0)).filter(Objects::nonNull).forEach(operations::add));
        return operations;
    }

    private static List<String> getConfigFilesFromArgs(String[] args) {
        return Arrays.stream(StringUtils.tokenizeToStringArray((String)CommandLineArguments.getArgumentValue(CONFIG_FILES, args), (String)",")).filter(i -> !i.isEmpty()).collect(Collectors.toList());
    }

    private static Map<String, String> getConfigurationFromArgs(String[] args, boolean isModernConfig) {
        boolean processingValid = true;
        String validNamespace = "";
        String[] processedArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String arg2;
            processedArgs[i] = arg2 = args[i];
            if (!arg2.startsWith("-")) {
                validNamespace = arg2;
                continue;
            }
            if (validNamespace.isEmpty() || !arg2.contains("=")) continue;
            String paramName = arg2.substring(1, arg2.contains("=") ? arg2.indexOf("=") : arg2.length());
            String paramValue = arg2.substring(arg2.indexOf("=") + 1);
            if (paramName.contains(".") && !paramName.startsWith("environments.")) {
                processingValid = false;
                break;
            }
            Collection<String> paramsInNamespace = CommandLineArguments.getParametersByNamespace(validNamespace);
            if (paramsInNamespace.contains(paramName)) {
                String replacedParamName = "-" + validNamespace + "." + paramName;
                processedArgs[i] = replacedParamName + "=" + paramValue;
                continue;
            }
            String preArg = args[i - 1];
            if (!preArg.startsWith("-") || preArg.contains("=") || !paramsInNamespace.contains((preArg = preArg.substring(1)) + "." + paramName)) continue;
            String replacedParamName = "-" + validNamespace + "." + preArg + "." + paramName;
            processedArgs[i] = replacedParamName + "=" + paramValue;
        }
        return Arrays.stream(processingValid ? processedArgs : args).filter(CommandLineArguments::isConfigurationArg).filter(arg -> !arg.startsWith("-configFiles=")).filter(arg -> !arg.startsWith("-configFileEncoding=")).filter(arg -> !arg.startsWith("-environments.")).filter(f -> !CommandLineArguments.isConfigurationOptionCommandlineOnly(CommandLineArguments.getConfigurationOptionNameFromArg(f))).collect(Collectors.toMap(p -> (Arrays.stream(EnvironmentModel.class.getDeclaredFields()).anyMatch(x -> x.getName().equals(CommandLineArguments.getConfigurationOptionNameFromArg(p))) && isModernConfig ? "environments.tempConfigEnvironment." : "flyway.") + CommandLineArguments.getConfigurationOptionNameFromArg(p), CommandLineArguments::parseConfigurationOptionValueFromArg));
    }

    private static Map<String, Map<String, String>> getEnvironmentConfigurationFromArgs(String[] args) {
        Map<String, String> envConfigs = Arrays.stream(args).filter(arg -> arg.toLowerCase().startsWith("-environments.") && arg.contains("=")).collect(Collectors.toMap(p -> CommandLineArguments.getConfigurationOptionNameFromArg(p).substring("environments.".length()), CommandLineArguments::parseConfigurationOptionValueFromArg));
        HashMap<String, Map<String, String>> envConfigMap = new HashMap<String, Map<String, String>>();
        for (String envKey : envConfigs.keySet()) {
            String envName = envKey.split("\\.")[0];
            String envConfigKey = envKey.substring(envName.length() + 1);
            if (!envConfigMap.containsKey(envName)) {
                envConfigMap.put(envName, new HashMap());
            }
            ((Map)envConfigMap.get(envName)).put(envConfigKey, envConfigs.get(envKey));
        }
        return envConfigMap;
    }

    private static boolean isConfigurationOptionCommandlineOnly(String configurationOptionName) {
        return COMMAND_LINE_ONLY_OPTIONS.contains(configurationOptionName);
    }

    private static String getConfigurationOptionNameFromArg(String arg) {
        return arg.substring(1, arg.indexOf("="));
    }

    private static boolean isConfigurationArg(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    public List<String> getFlags() {
        return Arrays.stream(this.args).filter(a -> a.startsWith("-") && !a.contains("=")).collect(Collectors.toList());
    }

    public void validate() {
        IntStream.range(0, this.args.length).filter(i -> !CommandLineArguments.isConfigurationArg(this.args[i])).filter(i -> !VALID_OPERATIONS_AND_FLAGS.contains(this.args[i])).filter(i -> !this.isHandledByExtension(this.args[i])).findAny().ifPresent(i -> {
            if (i < this.args.length - 1 && "=".equals(this.args[i + 1])) {
                throw new FlywayException("Invalid configuration argument: " + this.args[i] + ". Please check you have not included any spaces in your configuration argument.");
            }
            String hint = "";
            if (this.args.length > i + 1 && this.args[i + 1] != null && this.args[i + 1].startsWith(".")) {
                hint = "Shell may cause input parameters containing periods (.) to be misinterpreted - do you need to wrap your parameter in double quotes?";
            }
            throw new FlywayException("Invalid flag: " + this.args[i] + "\n" + hint);
        });
        Optional<String> environmentArgument = Arrays.stream(this.args).filter(x -> x.startsWith("-environments")).filter(x -> x.contains("=")).map(x -> x.substring(0, x.indexOf("="))).filter(x -> x.split("\\.").length == 2).findFirst();
        if (environmentArgument.isPresent()) {
            throw new FlywayException("Invalid configuration argument: " + environmentArgument.get() + ". Both the environment name and configuration option are required.");
        }
        String outputTypeValue = CommandLineArguments.getArgumentValue(OUTPUT_TYPE, this.args).toLowerCase();
        if (!"json".equals(outputTypeValue) && !outputTypeValue.isEmpty()) {
            throw new FlywayException("'" + outputTypeValue + "' is an invalid value for the -outputType option. Use 'json'.");
        }
        String colorArgumentValue = CommandLineArguments.getArgumentValue(COLOR, this.args);
        if (!Color.isValid(colorArgumentValue)) {
            throw new FlywayException("'" + colorArgumentValue + "' is an invalid value for the -color option. Use 'always', 'never', or 'auto'.");
        }
    }

    private boolean isHandledByExtension(String arg) {
        for (CommandExtension extension : this.pluginRegister.getInstancesOf(CommandExtension.class)) {
            if (!extension.handlesCommand(arg) && !extension.handlesParameter(arg)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldOutputJson() {
        return "json".equalsIgnoreCase(CommandLineArguments.getArgumentValue(OUTPUT_TYPE, this.args));
    }

    public boolean shouldOutputLogsInJson() {
        return "true".equalsIgnoreCase(CommandLineArguments.getArgumentValue(OUTPUT_LOGS_IN_JSON, this.args));
    }

    public PrintUsage shouldPrintUsage(StringBuilder helpText) {
        if (this.hasOperation("help") || CommandLineArguments.isFlagSet(this.args, PRINT_USAGE_FLAGS)) {
            this.getHelpTextForOperations(helpText);
            return PrintUsage.PRINT_ORIGINAL;
        }
        if (this.getOperations().isEmpty()) {
            return PrintUsage.PRINT_SHORT;
        }
        return PrintUsage.PRINT_NONE;
    }

    private void getHelpTextForOperations(StringBuilder helpText) {
        if (helpText == null) {
            return;
        }
        for (String operation : this.getOperations()) {
            String helpTextForOperation = this.pluginRegister.getInstancesOf(CommandExtension.class).stream().filter(e -> e.handlesCommand(operation)).map(e -> e.getHelpText(this.getFlags())).collect(Collectors.joining("\n\n"));
            if (!StringUtils.hasText((String)helpTextForOperation)) continue;
            helpText.append(helpTextForOperation).append("\n\n");
        }
    }

    public ConsoleLog.Level getLogLevel() {
        if (CommandLineArguments.isFlagSet(this.args, QUIET_FLAG)) {
            return ConsoleLog.Level.WARN;
        }
        if (CommandLineArguments.isFlagSet(this.args, DEBUG_FLAG)) {
            return ConsoleLog.Level.DEBUG;
        }
        return ConsoleLog.Level.INFO;
    }

    public boolean isCommunityFallback() {
        return CommandLineArguments.isFlagSet(this.args, COMMUNITY_FALLBACK_FLAG);
    }

    public boolean hasOperation(String operation) {
        return this.getOperations().contains(operation);
    }

    public List<String> getOperations() {
        return this.getOperationsFromArgs(this.args);
    }

    public List<String> getConfigFiles() {
        String workingDirectory = this.getWorkingDirectoryOrNull();
        return CommandLineArguments.getConfigFilesFromArgs(this.args).stream().map(File::new).map(file -> !file.isAbsolute() && workingDirectory != null ? new File(workingDirectory, file.getPath()).getAbsolutePath() : file.getAbsolutePath()).collect(Collectors.toList());
    }

    public List<File> getConfigFilePathsFromEnv(boolean loadToml) {
        String workingDirectory = this.getWorkingDirectoryOrNull();
        String[] fileLocations = StringUtils.tokenizeToStringArray((String)System.getenv("FLYWAY_CONFIG_FILES"), (String)",");
        return fileLocations == null ? new ArrayList<File>() : Arrays.stream(fileLocations).filter(loadToml ? f -> f.endsWith(".toml") : f -> !f.endsWith(".toml")).map(File::new).map(file -> !file.isAbsolute() && workingDirectory != null ? new File(workingDirectory, file.getPath()) : file).collect(Collectors.toList());
    }

    public String getOutputFile() {
        return CommandLineArguments.getArgumentValue(OUTPUT_FILE, this.args);
    }

    public String getWorkingDirectory() {
        return CommandLineArguments.getArgumentValue(WORKING_DIRECTORY, this.args);
    }

    public String getWorkingDirectoryOrNull() {
        return this.isWorkingDirectorySet() ? this.getWorkingDirectory() : null;
    }

    public Date getInfoSinceDate() {
        return this.parseDate(INFO_SINCE_DATE);
    }

    public Date getInfoUntilDate() {
        return this.parseDate(INFO_UNTIL_DATE);
    }

    public MigrationVersion getInfoSinceVersion() {
        return this.parseVersion(INFO_SINCE_VERSION);
    }

    public MigrationVersion getInfoUntilVersion() {
        return this.parseVersion(INFO_UNTIL_VERSION);
    }

    public MigrationState[] getInfoOfState() {
        String stateStr = CommandLineArguments.getArgumentValue(INFO_OF_STATE, this.args);
        if (!StringUtils.hasText((String)stateStr)) {
            return null;
        }
        return (MigrationState[])Arrays.stream(stateStr.split(",")).map(s -> MigrationState.valueOf((String)s.toUpperCase(Locale.ENGLISH))).toArray(MigrationState[]::new);
    }

    public boolean isFilterOnMigrationIds() {
        return CommandLineArguments.isFlagSet(this.args, MIGRATIONS_IDS_FLAG);
    }

    private MigrationVersion parseVersion(String argument) {
        String versionStr = CommandLineArguments.getArgumentValue(argument, this.args);
        if (versionStr.isEmpty()) {
            return null;
        }
        return MigrationVersion.fromVersion((String)versionStr);
    }

    private Date parseDate(String argument) {
        String dateStr = CommandLineArguments.getArgumentValue(argument, this.args);
        if (dateStr.isEmpty()) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(dateStr);
        }
        catch (ParseException e) {
            throw new FlywayException("'" + dateStr + "' is an invalid value for the " + argument + " option. The expected format is 'dd/mm/yyyy hh:mm', like '13/10/2020 16:30'. See the Flyway documentation for help: https://rd.gt/3jqLqAn");
        }
    }

    public boolean isOutputFileSet() {
        return !this.getOutputFile().isEmpty();
    }

    public boolean isWorkingDirectorySet() {
        return !this.getWorkingDirectory().isEmpty();
    }

    public String getConfigFileEncoding() {
        return CommandLineArguments.getArgumentValue(CONFIG_FILE_ENCODING, this.args);
    }

    public boolean isConfigFileEncodingSet() {
        return !this.getConfigFileEncoding().isEmpty();
    }

    public boolean skipCheckForUpdate() {
        return CommandLineArguments.isFlagSet(this.args, SKIP_CHECK_FOR_UPDATE_FLAG);
    }

    public Color getColor() {
        return Color.fromString(CommandLineArguments.getArgumentValue(COLOR, this.args));
    }

    public Map<String, String> getConfiguration(boolean isModernConfig) {
        return CommandLineArguments.getConfigurationFromArgs(this.args, isModernConfig);
    }

    public Map<String, Map<String, String>> getEnvironmentConfiguration() {
        return CommandLineArguments.getEnvironmentConfigurationFromArgs(this.args);
    }

    public static enum Color {
        ALWAYS("always"),
        NEVER("never"),
        AUTO("auto");

        private final String value;

        public static Color fromString(String value) {
            if (value.isEmpty()) {
                return AUTO;
            }
            return Arrays.stream(Color.values()).filter(color -> color.value.equals(value)).findFirst().orElse(null);
        }

        public static boolean isValid(String value) {
            return Color.fromString(value) != null;
        }

        @Generated
        private Color(String value) {
            this.value = value;
        }
    }

    public static enum PrintUsage {
        PRINT_NONE,
        PRINT_ORIGINAL,
        PRINT_SHORT;

    }
}

