/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.InfoOutput;
import org.flywaydb.core.extensibility.RootTelemetryModel;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.license.EncryptionUtils;
import org.flywaydb.core.internal.license.FlywayPermit;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.StringUtils;

public class TelemetryUtils {
    public static RootTelemetryModel populateRootTelemetry(RootTelemetryModel rootTelemetryModel, Configuration configuration, FlywayPermit flywayPermit) {
        ConfigurationModel modernConfig;
        boolean isRGDomainSet;
        rootTelemetryModel.setApplicationVersion(VersionPrinter.getVersion());
        boolean bl = isRGDomainSet = System.getenv("RGDOMAIN") != null;
        if (flywayPermit != null) {
            rootTelemetryModel.setRedgateEmployee(flywayPermit.isRedgateEmployee() || isRGDomainSet);
            rootTelemetryModel.setApplicationEdition(Tier.asString((Tier)flywayPermit.getTier()));
            rootTelemetryModel.setTrial(flywayPermit.isTrial());
            rootTelemetryModel.setSignedIn(flywayPermit.isFromAuth());
        } else {
            rootTelemetryModel.setRedgateEmployee(isRGDomainSet);
        }
        if (configuration != null && (modernConfig = configuration.getModernConfig()) != null && StringUtils.hasText((String)modernConfig.getId())) {
            rootTelemetryModel.setProjectId(EncryptionUtils.hashString((String)modernConfig.getId(), (String)"fur"));
        }
        return rootTelemetryModel;
    }

    public static String getOldestMigration(List<InfoOutput> infos) {
        if (infos == null) {
            return "";
        }
        ArrayList migrationDates = new ArrayList();
        infos.stream().filter(output -> StringUtils.hasText((String)output.installedOnUTC)).forEach(output -> migrationDates.add(output.installedOnUTC));
        if (!migrationDates.isEmpty()) {
            migrationDates.sort(Comparator.naturalOrder());
            return (String)migrationDates.get(0);
        }
        return "";
    }

    private TelemetryUtils() {
    }
}

