/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.cucumber;

import java.util.Objects;
import org.fluentlenium.adapter.FluentAdapter;
import org.fluentlenium.adapter.FluentControlContainer;
import org.fluentlenium.adapter.SharedMutator;
import org.fluentlenium.adapter.ThreadLocalFluentControlContainer;
import org.fluentlenium.adapter.cucumber.FluentCucumberSharedMutator;
import org.fluentlenium.adapter.cucumber.FluentCucumberTest;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.ComponentsManager;
import org.fluentlenium.core.inject.ContainerInstanciator;
import org.fluentlenium.core.inject.DefaultContainerInstanciator;
import org.fluentlenium.core.inject.FluentInjector;

public enum FluentTestContainer {
    FLUENT_TEST;

    private FluentAdapter fluentAdapter;
    private FluentControlContainer controlContainer;
    private SharedMutator sharedMutator;
    private FluentInjector injector;
    private static Class<?> configClass;

    public FluentAdapter instance() {
        if (Objects.isNull(this.fluentAdapter)) {
            this.controlContainer = new ThreadLocalFluentControlContainer();
            this.sharedMutator = new FluentCucumberSharedMutator();
            this.fluentAdapter = Objects.nonNull(configClass) ? new FluentCucumberTest(this.controlContainer, configClass, this.sharedMutator) : new FluentCucumberTest(this.controlContainer, this.sharedMutator);
            this.injector = new FluentInjector((FluentControl)this.fluentAdapter, null, new ComponentsManager((FluentControl)this.fluentAdapter), (ContainerInstanciator)new DefaultContainerInstanciator((FluentControl)this.fluentAdapter));
        }
        return this.fluentAdapter;
    }

    public void reset() {
        this.sharedMutator = null;
        this.controlContainer = null;
        this.injector = null;
        this.fluentAdapter = null;
        configClass = null;
    }

    protected FluentControlContainer getControlContainer() {
        if (this.fluentAdapter == null) {
            this.instance();
        }
        return this.controlContainer;
    }

    protected static void setConfigClass(Class clazz) {
        configClass = clazz;
    }

    protected SharedMutator getSharedMutator() {
        if (this.sharedMutator == null) {
            this.instance();
        }
        return this.sharedMutator;
    }

    protected FluentInjector injector() {
        if (this.injector == null) {
            this.instance();
        }
        return this.injector;
    }

    public void before() {
        ((FluentCucumberTest)this.fluentAdapter).start();
    }

    public void after() {
        ((FluentCucumberTest)this.fluentAdapter).finish();
    }
}

