/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.cucumber;

import cucumber.api.TypeRegistryConfigurer;
import cucumber.api.event.Event;
import cucumber.api.event.TestRunFinished;
import cucumber.api.formatter.Formatter;
import cucumber.api.java.ObjectFactory;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.DefaultTypeRegistryConfiguration;
import cucumber.runtime.Reflections;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.java.JavaBackend;
import cucumber.runtime.junit.Assertions;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.model.CucumberFeature;
import io.cucumber.stepexpression.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.fluentlenium.adapter.cucumber.FluentObjectFactory;
import org.fluentlenium.configuration.FluentConfiguration;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class FluentCucumber
extends ParentRunner<FeatureRunner> {
    private final JUnitReporter jUnitReporter;
    private final List<FeatureRunner> children = new ArrayList<FeatureRunner>();
    final Runtime runtime;

    public FluentCucumber(Class clazz) throws InitializationError, IOException {
        super(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        RuntimeOptions runtimeOptions = runtimeOptionsFactory.create();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
        FluentObjectFactory objectFactory = this.getFluentObjectFactory(clazz);
        this.runtime = new Runtime((ResourceLoader)resourceLoader, classLoader, Collections.singletonList(this.getBackend((ClassFinder)classFinder, runtimeOptions, objectFactory)), runtimeOptions);
        Formatter formatter = runtimeOptions.formatter(classLoader);
        JUnitOptions junitOptions = new JUnitOptions(runtimeOptions.getJunitOptions());
        List cucumberFeatures = runtimeOptions.cucumberFeatures((ResourceLoader)resourceLoader, this.runtime.getEventBus());
        this.jUnitReporter = new JUnitReporter(this.runtime.getEventBus(), runtimeOptions.isStrict(), junitOptions);
        this.addChildren(cucumberFeatures);
    }

    private JavaBackend getBackend(ClassFinder classFinder, RuntimeOptions runtimeOptions, FluentObjectFactory objectFactory) {
        Reflections reflections = new Reflections(classFinder);
        TypeRegistryConfigurer typeRegistryConfigurer = (TypeRegistryConfigurer)reflections.instantiateExactlyOneSubclass(TypeRegistryConfigurer.class, MultiLoader.packageName((List)runtimeOptions.getGlue()), new Class[0], new Object[0], (Object)new DefaultTypeRegistryConfiguration());
        return new JavaBackend((ObjectFactory)objectFactory, classFinder, new TypeRegistry(typeRegistryConfigurer.locale()));
    }

    private FluentObjectFactory getFluentObjectFactory(Class clazz) {
        boolean initConfiguration = Optional.ofNullable(clazz.getAnnotation(FluentConfiguration.class)).isPresent();
        if (initConfiguration) {
            return new FluentObjectFactory(clazz);
        }
        return new FluentObjectFactory(null);
    }

    public List<FeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        final Statement features = super.childrenInvoker(notifier);
        return new Statement(){

            public void evaluate() {
                try {
                    features.evaluate();
                }
                catch (Throwable throwable) {
                    throw new RuntimeException("Cannot evaluate statement", throwable);
                }
                FluentCucumber.this.runtime.getEventBus().send((Event)new TestRunFinished(FluentCucumber.this.runtime.getEventBus().getTime()));
            }
        };
    }

    private void addChildren(List<CucumberFeature> cucumberFeatures) throws InitializationError {
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            FeatureRunner featureRunner = new FeatureRunner(cucumberFeature, this.runtime, this.jUnitReporter);
            if (featureRunner.isEmpty()) continue;
            this.children.add(featureRunner);
        }
    }
}

