/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.cucumber.adapter;

import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentAdapter;
import org.fluentlenium.cucumber.adapter.util.SharedDriverHelper;
import org.fluentlenium.cucumber.adapter.util.ShutdownHook;
import org.openqa.selenium.WebDriver;

public class FluentCucumberTest
extends FluentAdapter {
    public static boolean isSharedDriverPerScenario;
    public static WebDriver sharedDriver;

    protected Fluent initFluentWithWebDriver(FluentCucumberTest initializer) {
        return this.initFluentWithWebDriver(initializer, initializer.getDriver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Fluent initFluentWithWebDriver(FluentCucumberTest initializer, WebDriver driver) {
        Class<?> clazz = ((Object)((Object)initializer)).getClass();
        if (SharedDriverHelper.isSharedDriverPerFeature(clazz)) {
            FluentCucumberTest fluentCucumberTest = this;
            synchronized (fluentCucumberTest) {
                if (sharedDriver == null) {
                    this.initSharedDriver(driver);
                    this.killTheBrowserOnShutdown();
                } else {
                    this.initFluentWithExistingDriver();
                }
            }
        } else if (SharedDriverHelper.isSharedDriverPerScenario(clazz) || SharedDriverHelper.isDefaultSharedDriver(clazz)) {
            FluentCucumberTest fluentCucumberTest = this;
            synchronized (fluentCucumberTest) {
                if (!isSharedDriverPerScenario) {
                    this.initSharedDriver(driver);
                    isSharedDriverPerScenario = true;
                } else {
                    this.initFluentWithExistingDriver();
                }
            }
        } else {
            this.initFluentFromDefaultDriver();
        }
        return this;
    }

    private void initSharedDriver(WebDriver driver) {
        if (driver != null) {
            sharedDriver = driver;
            this.initFluentWithExistingDriver();
        } else {
            this.initFluentFromDefaultDriver();
        }
        sharedDriver = this.getDriver();
    }

    protected Fluent initFluent() {
        return this.initFluentWithWebDriver(this);
    }

    protected Fluent initFluent(WebDriver driver) {
        if (sharedDriver == null) {
            sharedDriver = driver;
            this.initFluentWithExistingDriver();
            this.killTheBrowserOnShutdown();
        } else {
            this.initFluentWithExistingDriver();
        }
        return this;
    }

    private void initFluentWithExistingDriver() {
        super.initFluent(sharedDriver).withDefaultUrl(this.getDefaultBaseUrl());
    }

    private void initFluentFromDefaultDriver() {
        super.initFluent(this.getDefaultDriver()).withDefaultUrl(this.getDefaultBaseUrl());
    }

    public void quit() {
        if (isSharedDriverPerScenario) {
            sharedDriver.quit();
            sharedDriver = null;
            isSharedDriverPerScenario = false;
        }
    }

    public void forceQuit() {
        super.quit();
    }

    private void killTheBrowserOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook("fluentlenium", this));
    }

    static {
        sharedDriver = null;
    }

    protected static enum Mode {
        TAKE_SNAPSHOT_ON_FAIL,
        NEVER_TAKE_SNAPSHOT;

    }
}

