/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.AbstractAnnotationListener;
import org.fluentlenium.core.events.ElementListener;
import org.fluentlenium.core.events.EventAnnotationsException;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

class AnnotationElementListener
extends AbstractAnnotationListener
implements ElementListener {
    private final Method method;
    private final String annotationName;
    private final WebElement targetElement;

    AnnotationElementListener(Method method, Object container, String annotationName, int priority, WebElement targetElement) {
        super(container, priority);
        this.method = method;
        this.annotationName = annotationName;
        this.targetElement = targetElement;
    }

    protected Function<Class<?>, Object> getArgsFunction(FluentWebElement element, WebDriver driver) {
        return input -> {
            if (input.isAssignableFrom(FluentWebElement.class)) {
                return element;
            }
            if (input.isAssignableFrom(WebDriver.class)) {
                return driver;
            }
            return null;
        };
    }

    @Override
    public void on(FluentWebElement element, WebDriver driver) {
        if (!(this.targetElement == null || element != null && this.targetElement.equals(element.getElement()))) {
            return;
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(element, driver), parameterTypes);
        try {
            ReflectionUtils.invoke(this.method, this.getContainer(), args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
    }
}

