/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.domain;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.SeleniumDriverControl;
import org.fluentlenium.core.action.Fill;
import org.fluentlenium.core.action.FillSelect;
import org.fluentlenium.core.action.FluentActions;
import org.fluentlenium.core.action.FluentJavascriptActionsImpl;
import org.fluentlenium.core.action.KeyboardElementActions;
import org.fluentlenium.core.action.MouseElementActions;
import org.fluentlenium.core.action.WindowAction;
import org.fluentlenium.core.alert.Alert;
import org.fluentlenium.core.alert.AlertControl;
import org.fluentlenium.core.capabilities.CapabilitiesControl;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.conditions.FluentConditions;
import org.fluentlenium.core.conditions.WebElementConditions;
import org.fluentlenium.core.css.CssControl;
import org.fluentlenium.core.css.CssSupport;
import org.fluentlenium.core.dom.Dom;
import org.fluentlenium.core.domain.Component;
import org.fluentlenium.core.domain.ComponentList;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentListImpl;
import org.fluentlenium.core.events.EventsControl;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.hook.FluentHook;
import org.fluentlenium.core.hook.HookControl;
import org.fluentlenium.core.hook.HookControlImpl;
import org.fluentlenium.core.hook.HookDefinition;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.inject.FluentInjectControl;
import org.fluentlenium.core.label.FluentLabel;
import org.fluentlenium.core.label.FluentLabelImpl;
import org.fluentlenium.core.navigation.NavigationControl;
import org.fluentlenium.core.proxy.FluentProxyState;
import org.fluentlenium.core.proxy.LocatorHandler;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.core.script.FluentJavascript;
import org.fluentlenium.core.script.JavascriptControl;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchControl;
import org.fluentlenium.core.search.SearchFilter;
import org.fluentlenium.core.snapshot.SnapshotControl;
import org.fluentlenium.core.wait.FluentWaitElement;
import org.fluentlenium.utils.SupplierOfInstance;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class FluentWebElement
extends Component
implements WrapsElement,
FluentActions<FluentWebElement, FluentWebElement>,
FluentProxyState<FluentWebElement>,
SearchControl<FluentWebElement>,
HookControl<FluentWebElement>,
FluentLabel<FluentWebElement>,
NavigationControl,
JavascriptControl,
AlertControl,
SnapshotControl,
EventsControl,
SeleniumDriverControl,
CssControl,
FluentInjectControl,
CapabilitiesControl,
ComponentInstantiator {
    private final Search search;
    private final Dom dom;
    private final MouseElementActions mouseActions;
    private final KeyboardElementActions keyboardActions;
    private final WebElementConditions conditions;
    private final HookControlImpl<FluentWebElement> hookControl;
    private final FluentLabel<FluentWebElement> label;
    private final FluentJavascriptActionsImpl<FluentWebElement> javascriptActions;

    public FluentWebElement(WebElement element, FluentControl control, ComponentInstantiator instantiator) {
        super(element, control, instantiator);
        this.hookControl = new HookControlImpl<FluentWebElement>(this, this.webElement, this.control, this.instantiator, () -> {
            LocatorHandler locatorHandler = LocatorProxies.getLocatorHandler(this.getElement());
            ElementLocator locator = locatorHandler.getLocator();
            WebElement noHookElement = LocatorProxies.createWebElement(locator);
            return (FluentWebElement)control.newComponent(this.getClass(), noHookElement);
        });
        this.search = new Search((SearchContext)element, this, this.instantiator, this.control);
        this.dom = new Dom(element, this.instantiator);
        this.mouseActions = new MouseElementActions(this.control.getDriver(), element);
        this.keyboardActions = new KeyboardElementActions(this.control.getDriver(), element);
        this.conditions = new WebElementConditions(this);
        this.label = new FluentLabelImpl<FluentWebElement>(this, () -> this.getElement().toString());
        this.javascriptActions = new FluentJavascriptActionsImpl<FluentWebElement>(this, this.control, new SupplierOfInstance<FluentWebElement>(this));
    }

    private HookControl<FluentWebElement> getHookControl() {
        return this.hookControl;
    }

    private FluentJavascriptActionsImpl<FluentWebElement> getJavascriptActions() {
        return this.javascriptActions;
    }

    public FluentLabel<FluentWebElement> getLabel() {
        return this.label;
    }

    @Override
    public FluentJavascript executeScript(String script, Object ... args) {
        return this.control.executeScript(script, args);
    }

    @Override
    public FluentJavascript executeAsyncScript(String script, Object ... args) {
        return this.control.executeAsyncScript(script, args);
    }

    @Override
    public Alert alert() {
        return this.control.alert();
    }

    @Override
    public void takeHtmlDump() {
        this.control.takeHtmlDump();
    }

    @Override
    public void takeHtmlDump(String fileName) {
        this.control.takeHtmlDump(fileName);
    }

    @Override
    public boolean canTakeScreenShot() {
        return this.control.canTakeScreenShot();
    }

    @Override
    public void takeScreenshot() {
        this.control.takeScreenshot();
    }

    @Override
    public void takeScreenshot(String fileName) {
        this.control.takeScreenshot(fileName);
    }

    @Override
    public EventsRegistry events() {
        return this.control.events();
    }

    @Override
    public <P extends FluentPage> P goTo(P page) {
        return this.control.goTo(page);
    }

    @Override
    public void goTo(String url) {
        this.control.goTo(url);
    }

    @Override
    public void goToInNewTab(String url) {
        this.control.goToInNewTab(url);
    }

    @Override
    public void switchTo(FluentList<? extends FluentWebElement> elements) {
        this.control.switchTo(elements);
    }

    @Override
    public void switchTo(FluentWebElement element) {
        this.control.switchTo(element);
    }

    @Override
    public void switchTo() {
        this.control.switchTo();
    }

    @Override
    public void switchToDefault() {
        this.control.switchToDefault();
    }

    @Override
    public String pageSource() {
        return this.control.pageSource();
    }

    @Override
    public WindowAction window() {
        return this.control.window();
    }

    @Override
    public Set<Cookie> getCookies() {
        return this.control.getCookies();
    }

    @Override
    public Cookie getCookie(String name) {
        return this.control.getCookie(name);
    }

    @Override
    public String url() {
        return this.control.url();
    }

    @Override
    public WebDriver getDriver() {
        return this.control.getDriver();
    }

    @Override
    public CssSupport css() {
        return this.control.css();
    }

    @Override
    public ContainerContext inject(Object container) {
        return this.control.inject(container);
    }

    @Override
    public ContainerContext injectComponent(Object componentContainer, Object parentContainer, SearchContext context) {
        return this.control.injectComponent(componentContainer, parentContainer, context);
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        return this.control.newInstance(cls);
    }

    @Override
    public FluentWebElement newFluent(WebElement element) {
        return this.control.newFluent(element);
    }

    @Override
    public <T> T newComponent(Class<T> componentClass, WebElement element) {
        return this.control.newComponent(componentClass, element);
    }

    @Override
    public FluentList<FluentWebElement> newFluentList() {
        return this.control.newFluentList();
    }

    @Override
    public FluentList<FluentWebElement> newFluentList(FluentWebElement ... elements) {
        return this.control.newFluentList(elements);
    }

    @Override
    public FluentList<FluentWebElement> newFluentList(List<FluentWebElement> elements) {
        return this.control.newFluentList(elements);
    }

    @Override
    public FluentList<FluentWebElement> asFluentList(WebElement ... elements) {
        return this.control.asFluentList(elements);
    }

    @Override
    public FluentList<FluentWebElement> asFluentList(Iterable<WebElement> elements) {
        return this.control.asFluentList(elements);
    }

    @Override
    public FluentList<FluentWebElement> asFluentList(List<WebElement> elements) {
        return this.control.asFluentList(elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass) {
        return this.control.newFluentList(componentClass);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass, T ... elements) {
        return this.control.newFluentList(componentClass, (FluentWebElement[])elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass, List<T> elements) {
        return this.control.newFluentList(componentClass, elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, WebElement ... elements) {
        return this.control.asFluentList(componentClass, elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, Iterable<WebElement> elements) {
        return this.control.asFluentList(componentClass, elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, List<WebElement> elements) {
        return this.control.asFluentList(componentClass, elements);
    }

    @Override
    public <T> ComponentList<T> newComponentList(Class<T> componentClass) {
        return this.control.newComponentList(componentClass);
    }

    @Override
    public <T> ComponentList<T> asComponentList(Class<T> componentClass, WebElement ... elements) {
        return this.control.asComponentList(componentClass, elements);
    }

    @Override
    public <T> ComponentList asComponentList(Class<T> componentClass, Iterable<WebElement> elements) {
        return this.control.asComponentList(componentClass, elements);
    }

    @Override
    public <T> ComponentList<T> asComponentList(Class<T> componentClass, List<WebElement> elements) {
        return this.control.asComponentList(componentClass, elements);
    }

    @Override
    public <T> ComponentList<T> newComponentList(Class<T> componentClass, T ... componentsList) {
        return this.control.newComponentList(componentClass, componentsList);
    }

    @Override
    public <T> ComponentList<T> newComponentList(Class<T> componentClass, List<T> componentsList) {
        return this.control.newComponentList(componentClass, componentsList);
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass) {
        return this.control.newComponentList(listClass, componentClass);
    }

    @Override
    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, WebElement ... elements) {
        return this.control.asComponentList(listClass, componentClass, elements);
    }

    @Override
    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, Iterable<WebElement> elements) {
        return this.control.asComponentList(listClass, componentClass, elements);
    }

    @Override
    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, List<WebElement> elements) {
        return this.control.asComponentList(listClass, componentClass, elements);
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, T ... componentsList) {
        return this.control.newComponentList(listClass, componentClass, componentsList);
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, List<T> componentsList) {
        return this.control.newComponentList(listClass, componentClass, componentsList);
    }

    @Override
    public boolean isComponentClass(Class<?> componentClass) {
        return this.control.isComponentClass(componentClass);
    }

    @Override
    public boolean isComponentListClass(Class<? extends List<?>> componentListClass) {
        return false;
    }

    @Override
    public Capabilities capabilities() {
        return this.control.capabilities();
    }

    @Override
    public FluentWebElement click() {
        this.webElement.click();
        return this;
    }

    @Override
    public FluentWebElement doubleClick() {
        this.mouse().doubleClick();
        return this;
    }

    @Override
    public FluentWebElement contextClick() {
        this.mouse().contextClick();
        return this;
    }

    @Override
    public FluentWebElement waitAndClick() {
        return this.waitAndClick(Duration.ofSeconds(5L));
    }

    @Override
    public FluentWebElement waitAndClick(Duration duration) {
        this.await().atMost(duration).until(this).clickable();
        this.scrollToCenter();
        this.click();
        return this;
    }

    @Override
    public boolean present() {
        return LocatorProxies.present(this.webElement);
    }

    @Override
    public FluentWebElement now() {
        LocatorProxies.now(this.webElement);
        return this;
    }

    @Override
    public FluentWebElement now(boolean force) {
        if (force) {
            this.reset();
        }
        return this.now();
    }

    @Override
    public FluentWebElement reset() {
        LocatorProxies.reset(this.webElement);
        return this;
    }

    @Override
    public boolean loaded() {
        return LocatorProxies.loaded(this.webElement);
    }

    @Deprecated
    public Dom axes() {
        return this.dom;
    }

    public Dom dom() {
        return this.dom;
    }

    public FluentConditions conditions() {
        return this.conditions;
    }

    public FluentWaitElement await() {
        return new FluentWaitElement(this.control.await(), this);
    }

    public MouseElementActions mouse() {
        return this.mouseActions;
    }

    public KeyboardElementActions keyboard() {
        return this.keyboardActions;
    }

    public <T> T as(Class<T> componentClass) {
        T component = this.instantiator.newComponent(componentClass, this.getElement());
        this.control.injectComponent(component, this, (SearchContext)this.getElement());
        return component;
    }

    public FluentWebElement clear() {
        if (!this.isInputOfTypeFile()) {
            this.webElement.clear();
        }
        return this;
    }

    public FluentWebElement clearReactInput() {
        if (this.attribute("value").length() != 0) {
            this.javascriptActions.modifyAttribute("value", "");
        }
        return this;
    }

    @Override
    public FluentWebElement submit() {
        this.webElement.submit();
        return this;
    }

    @Override
    public FluentWebElement write(String ... text) {
        this.clear();
        if (text.length != 0) {
            this.webElement.sendKeys(new CharSequence[]{text[0]});
        }
        return this;
    }

    public String name() {
        return this.webElement.getAttribute("name");
    }

    public String attribute(String name) {
        return this.webElement.getAttribute(name);
    }

    public String cssValue(String propertyName) {
        return this.webElement.getCssValue(propertyName);
    }

    public String id() {
        return this.webElement.getAttribute("id");
    }

    public String text() {
        return this.webElement.getText();
    }

    public String textContent() {
        return this.webElement.getAttribute("textContent");
    }

    public String value() {
        return this.webElement.getAttribute("value");
    }

    public boolean displayed() {
        boolean displayed;
        try {
            displayed = this.webElement.isDisplayed();
        }
        catch (NoSuchElementException e) {
            displayed = false;
        }
        return displayed;
    }

    public boolean enabled() {
        boolean enabled;
        try {
            enabled = this.webElement.isEnabled();
        }
        catch (NoSuchElementException e) {
            enabled = false;
        }
        return enabled;
    }

    public boolean selected() {
        boolean selected;
        try {
            selected = this.webElement.isSelected();
        }
        catch (NoSuchElementException e) {
            selected = false;
        }
        return selected;
    }

    public boolean clickable() {
        boolean clickable;
        try {
            clickable = ExpectedConditions.elementToBeClickable((WebElement)this.getElement()).apply((Object)this.control.getDriver()) != null;
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            clickable = false;
        }
        return clickable;
    }

    public boolean stale() {
        return (Boolean)ExpectedConditions.stalenessOf((WebElement)this.getElement()).apply((Object)this.control.getDriver());
    }

    public String tagName() {
        return this.webElement.getTagName();
    }

    public WebElement getElement() {
        return this.webElement;
    }

    public WebElement getWrappedElement() {
        return this.getElement();
    }

    public Dimension size() {
        return this.webElement.getSize();
    }

    public FluentList<FluentWebElement> asList() {
        return this.instantiator.asComponentList(FluentListImpl.class, FluentWebElement.class, Arrays.asList(this.webElement));
    }

    @Override
    public FluentList<FluentWebElement> find(By locator, SearchFilter ... filters) {
        return this.search.find(locator, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(String selector, SearchFilter ... filters) {
        return this.search.find(selector, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(SearchFilter ... filters) {
        return this.search.find(filters);
    }

    @Override
    public FluentList<FluentWebElement> find(List<WebElement> rawElements) {
        return this.search.find(rawElements);
    }

    @Override
    public FluentWebElement el(WebElement rawElement) {
        return this.search.el(rawElement);
    }

    public String html() {
        return this.webElement.getAttribute("innerHTML");
    }

    @Override
    public Fill<FluentWebElement> fill() {
        return new Fill<FluentWebElement>(this);
    }

    @Override
    public FillSelect<FluentWebElement> fillSelect() {
        return new FillSelect<FluentWebElement>(this);
    }

    @Override
    public FluentWebElement frame() {
        this.control.window().switchTo().frame(this);
        return this;
    }

    @Override
    public Optional<FluentWebElement> optional() {
        if (this.present()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    private boolean isInputOfTypeFile() {
        return "input".equalsIgnoreCase(this.tagName()) && "file".equalsIgnoreCase(this.attribute("type"));
    }

    void setHookRestoreStack(Stack<List<HookDefinition<?>>> hookRestoreStack) {
        this.hookControl.setHookRestoreStack(hookRestoreStack);
    }

    public String toString() {
        return this.label.toString();
    }

    @Override
    public <R> R noHook(Class<? extends FluentHook> hook, Function<FluentWebElement, R> function) {
        return this.getHookControl().noHook(hook, function);
    }

    @Override
    public <O, H extends FluentHook<O>> FluentWebElement withHook(Class<H> hook, O options) {
        return this.getHookControl().withHook(hook, options);
    }

    @Override
    public <O, H extends FluentHook<O>> FluentWebElement withHook(Class<H> hook) {
        return this.getHookControl().withHook(hook);
    }

    @Override
    public FluentWebElement noHook(Class<? extends FluentHook> ... hooks) {
        return this.getHookControl().noHook(hooks);
    }

    @Override
    public <R> R noHook(Function<FluentWebElement, R> function) {
        return this.getHookControl().noHook(function);
    }

    @Override
    public FluentWebElement noHookInstance(Class<? extends FluentHook> ... hooks) {
        return this.getHookControl().noHookInstance(hooks);
    }

    @Override
    public FluentWebElement restoreHooks() {
        return this.getHookControl().restoreHooks();
    }

    @Override
    public FluentWebElement noHookInstance() {
        return this.getHookControl().noHookInstance();
    }

    @Override
    public FluentWebElement noHook() {
        return this.getHookControl().noHook();
    }

    public FluentWebElement scrollToCenter() {
        return this.getJavascriptActions().scrollToCenter();
    }

    public FluentWebElement scrollIntoView() {
        return this.getJavascriptActions().scrollIntoView();
    }

    public FluentWebElement scrollIntoView(boolean alignWithTop) {
        return this.getJavascriptActions().scrollIntoView(alignWithTop);
    }

    public FluentWebElement modifyAttribute(String attributeName, String attributeValue) {
        return this.getJavascriptActions().modifyAttribute(attributeName, attributeValue);
    }

    @Override
    public FluentWebElement withLabelHint(String ... labelHint) {
        return this.getLabel().withLabelHint(labelHint);
    }

    @Override
    public FluentWebElement withLabel(String label) {
        return this.getLabel().withLabel(label);
    }
}

