/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import java.util.List;
import java.util.function.Predicate;
import org.fluentlenium.core.FluentDriver;
import org.fluentlenium.core.conditions.AbstractFluentListConditions;
import org.fluentlenium.core.domain.FluentWebElement;

public class AtLeastOneElementConditions
extends AbstractFluentListConditions {
    public AtLeastOneElementConditions(List<? extends FluentWebElement> elements) {
        super(elements);
    }

    @Override
    public AtLeastOneElementConditions not() {
        AtLeastOneElementConditions negatedConditions = new AtLeastOneElementConditions(this.getElements());
        negatedConditions.setNegation(!this.isNegation());
        return negatedConditions;
    }

    @Override
    public boolean verify(Predicate<FluentWebElement> predicate, boolean defaultValue) {
        if (this.isNegation()) {
            predicate = predicate.negate();
            defaultValue = !defaultValue;
        }
        return this.buildAtLeastOnePredicate(predicate, defaultValue).test(null);
    }

    protected Predicate<FluentDriver> buildAtLeastOnePredicate(Predicate<FluentWebElement> predicate, boolean defaultValue) {
        Predicate<FluentDriver> untilPredicate = fluent -> {
            if (!this.getElements().isEmpty()) {
                for (FluentWebElement fluentWebElement : this.getElements()) {
                    if (!predicate.test(fluentWebElement)) continue;
                    return true;
                }
                return false;
            }
            return defaultValue;
        };
        return untilPredicate;
    }
}

