/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import org.fluentlenium.core.domain.FluentWebElement;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Mouse;

public class MouseElementActions {
    private final WebDriver driver;
    private final WebElement element;

    public MouseElementActions(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
    }

    public MouseElementActions(WebDriver driver, FluentWebElement fluentWebElement) {
        this.driver = driver;
        this.element = fluentWebElement.getElement();
    }

    private Actions actions() {
        return new Actions(this.driver);
    }

    @Deprecated
    public Mouse basic() {
        return ((HasInputDevices)this.driver).getMouse();
    }

    public MouseElementActions clickAndHold() {
        this.actions().clickAndHold(this.element).perform();
        return this;
    }

    public MouseElementActions release() {
        this.actions().release(this.element).perform();
        return this;
    }

    public MouseElementActions click() {
        this.actions().click(this.element).perform();
        return this;
    }

    public MouseElementActions doubleClick() {
        this.actions().doubleClick(this.element).perform();
        return this;
    }

    public MouseElementActions moveToElement() {
        this.actions().moveToElement(this.element).perform();
        return this;
    }

    public MouseElementActions moveToElement(WebElement target) {
        this.actions().moveToElement(target).perform();
        return this;
    }

    public MouseElementActions moveToElement(int xOffset, int yOffset) {
        this.actions().moveToElement(this.element, xOffset, yOffset).perform();
        return this;
    }

    public MouseElementActions moveToElement(WebElement target, int xOffset, int yOffset) {
        this.actions().moveToElement(target, xOffset, yOffset).perform();
        return this;
    }

    public MouseElementActions contextClick() {
        this.actions().contextClick(this.element).perform();
        return this;
    }

    public MouseElementActions dragAndDropFrom(WebElement source) {
        this.actions().dragAndDrop(source, this.element).perform();
        return this;
    }

    public MouseElementActions dragAndDropTo(WebElement target) {
        this.actions().dragAndDrop(this.element, target).perform();
        return this;
    }

    public MouseElementActions dragAndDropBy(int xOffset, int yOffset) {
        this.actions().dragAndDropBy(this.element, xOffset, yOffset).perform();
        return this;
    }

    public MouseElementActions dragAndDropByWithTargetOffset(WebElement target, int xOffset, int yOffset) {
        this.actions().clickAndHold(this.element).moveToElement(target, xOffset, yOffset).release().perform();
        return this;
    }
}

