/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.url;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.fluentlenium.core.url.ParsedUrlTemplate;
import org.fluentlenium.core.url.UrlParameter;

public class UrlTemplate {
    private static final Pattern PARAM_REGEX = Pattern.compile("\\{(.+?)\\}");
    private final String template;
    private final List<String> parameterNames = new ArrayList<String>();
    private final Map<String, UrlParameter> parameters = new LinkedHashMap<String, UrlParameter>();
    private final Map<UrlParameter, String> properties = new LinkedHashMap<UrlParameter, String>();

    public UrlTemplate(String template) {
        this.template = template;
        Matcher matcher = PARAM_REGEX.matcher(template);
        while (matcher.find()) {
            String parameterName;
            String path;
            String match = matcher.group(0);
            String group = matcher.group(1);
            boolean optional = group.startsWith("?");
            int lastIndex = group.lastIndexOf(47);
            if (lastIndex > -1 && lastIndex < group.length()) {
                path = group.substring(optional ? 1 : 0, lastIndex + 1);
                parameterName = group.substring(lastIndex + 1);
            } else if (group.startsWith("?")) {
                path = null;
                parameterName = group.substring(1);
            } else {
                path = null;
                parameterName = group;
            }
            UrlParameter parameter = new UrlParameter(parameterName, group, path, match, optional);
            if (this.parameters.containsKey(parameter.getName())) {
                throw new IllegalStateException(String.format("Multiple parameters are defined with the same name (%s).", parameter.getName()));
            }
            this.parameters.put(parameter.getName(), parameter);
            this.parameterNames.add(parameter.getName());
        }
    }

    public void clear() {
        this.properties.clear();
    }

    public List<UrlParameter> getParameters() {
        return new ArrayList<UrlParameter>(this.parameters.values());
    }

    public UrlTemplate add(String value) {
        this.properties.put(this.parameters.get(this.parameterNames.get(this.properties.size())), value);
        return this;
    }

    public UrlTemplate put(String name, String value) {
        UrlParameter parameter = this.parameters.get(name);
        if (parameter == null) {
            throw new IllegalArgumentException("Invalid parameter name: " + name);
        }
        this.properties.put(parameter, value);
        return this;
    }

    public UrlTemplate addAll(List<String> values) {
        for (String value : values) {
            this.add(value);
        }
        return this;
    }

    public UrlTemplate put(Map<String, String> values) {
        values.forEach(this::put);
        return this;
    }

    public String render() {
        String rendered = this.template;
        for (UrlParameter parameter : this.parameters.values()) {
            String value = this.properties.get(parameter);
            String group = parameter.getGroup();
            if (value == null && !parameter.isOptional()) {
                throw new IllegalArgumentException(String.format("Value for parameter %s is missing.", parameter));
            }
            rendered = rendered.replaceAll(Pattern.quote(String.format("{%s}", group)), this.buildRenderReplacement(parameter, value == null ? null : String.valueOf(value)));
        }
        return rendered;
    }

    private String buildRenderReplacement(UrlParameter parameter, String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        String path = parameter.getPath();
        if (path != null) {
            return path + value;
        }
        return value;
    }

    private String buildParsePattern() {
        Object fixedTemplate = this.template;
        fixedTemplate = ((String)fixedTemplate).startsWith("/") ? ((String)fixedTemplate).replaceFirst("/", "/?") : "/?" + (String)fixedTemplate;
        fixedTemplate = ((String)fixedTemplate).endsWith("/") ? (String)fixedTemplate + "?" : (String)fixedTemplate + "/?";
        for (UrlParameter parameter : this.parameters.values()) {
            Object replacementPattern = "%s([^/]+)";
            if (parameter.isOptional()) {
                replacementPattern = "(?:" + (String)replacementPattern + ")?";
            }
            fixedTemplate = ((String)fixedTemplate).replaceAll(Pattern.quote(parameter.getMatch()), String.format((String)replacementPattern, parameter.getPath() == null ? "" : parameter.getPath()));
        }
        return fixedTemplate;
    }

    public ParsedUrlTemplate parse(String input) {
        String noQueryInput = input;
        ArrayList<NameValuePair> queryParameters = new ArrayList();
        try {
            URIBuilder uriBuilder = new URIBuilder(input);
            queryParameters = uriBuilder.getQueryParams();
            uriBuilder.setCustomQuery(null);
            noQueryInput = uriBuilder.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        Pattern pathRegex = Pattern.compile(this.buildParsePattern());
        Matcher matcher = pathRegex.matcher(noQueryInput);
        boolean matches = matcher.matches();
        LinkedHashMap<String, String> parsedValues = new LinkedHashMap<String, String>();
        if (matches) {
            for (int i = 0; i < this.parameterNames.size() && i < matcher.groupCount(); ++i) {
                String value = matcher.group(i + 1);
                if (value == null) continue;
                parsedValues.put(this.parameterNames.get(i), value);
            }
        }
        return new ParsedUrlTemplate(matches, parsedValues, queryParameters);
    }
}

