/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.domain;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Function;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.action.Fill;
import org.fluentlenium.core.action.FillSelect;
import org.fluentlenium.core.action.FluentActions;
import org.fluentlenium.core.action.FluentJavascriptActionsImpl;
import org.fluentlenium.core.action.KeyboardElementActions;
import org.fluentlenium.core.action.MouseElementActions;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.conditions.FluentConditions;
import org.fluentlenium.core.conditions.WebElementConditions;
import org.fluentlenium.core.dom.Dom;
import org.fluentlenium.core.domain.Component;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentListImpl;
import org.fluentlenium.core.hook.FluentHook;
import org.fluentlenium.core.hook.HookControl;
import org.fluentlenium.core.hook.HookControlImpl;
import org.fluentlenium.core.hook.HookDefinition;
import org.fluentlenium.core.label.FluentLabel;
import org.fluentlenium.core.label.FluentLabelImpl;
import org.fluentlenium.core.proxy.FluentProxyState;
import org.fluentlenium.core.proxy.LocatorHandler;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchControl;
import org.fluentlenium.core.search.SearchFilter;
import org.fluentlenium.core.wait.FluentWaitElement;
import org.fluentlenium.utils.SupplierOfInstance;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class FluentWebElement
extends Component
implements WrapsElement,
FluentActions<FluentWebElement, FluentWebElement>,
FluentProxyState<FluentWebElement>,
SearchControl<FluentWebElement>,
HookControl<FluentWebElement>,
FluentLabel<FluentWebElement> {
    private final Search search;
    private final Dom dom;
    private final MouseElementActions mouseActions;
    private final KeyboardElementActions keyboardActions;
    private final WebElementConditions conditions;
    private final HookControlImpl<FluentWebElement> hookControl;
    private final FluentLabel<FluentWebElement> label;
    private final FluentJavascriptActionsImpl<FluentWebElement> javascriptActions;

    public FluentWebElement(WebElement element, FluentControl control, ComponentInstantiator instantiator) {
        super(element, control, instantiator);
        this.hookControl = new HookControlImpl<FluentWebElement>(this, this.webElement, this.control, this.instantiator, () -> {
            LocatorHandler locatorHandler = LocatorProxies.getLocatorHandler(this.getElement());
            ElementLocator locator = locatorHandler.getLocator();
            WebElement noHookElement = LocatorProxies.createWebElement(locator);
            return (FluentWebElement)this.getFluentControl().newComponent(this.getClass(), noHookElement);
        });
        this.search = new Search((SearchContext)element, this, this.instantiator, this.control);
        this.dom = new Dom(element, this.instantiator);
        this.mouseActions = new MouseElementActions(this.control.getDriver(), element);
        this.keyboardActions = new KeyboardElementActions(this.control.getDriver(), element);
        this.conditions = new WebElementConditions(this);
        this.label = new FluentLabelImpl<FluentWebElement>(this, () -> this.getElement().toString());
        this.javascriptActions = new FluentJavascriptActionsImpl<FluentWebElement>(this, this.control, new SupplierOfInstance<FluentWebElement>(this));
    }

    private FluentControl getFluentControl() {
        return this.control;
    }

    private HookControl<FluentWebElement> getHookControl() {
        return this.hookControl;
    }

    private FluentJavascriptActionsImpl<FluentWebElement> getJavascriptActions() {
        return this.javascriptActions;
    }

    public FluentLabel<FluentWebElement> getLabel() {
        return this.label;
    }

    @Override
    public FluentWebElement click() {
        this.webElement.click();
        return this;
    }

    @Override
    public FluentWebElement doubleClick() {
        this.mouse().doubleClick();
        return this;
    }

    @Override
    public FluentWebElement contextClick() {
        this.mouse().contextClick();
        return this;
    }

    @Override
    public boolean present() {
        return LocatorProxies.present(this.webElement);
    }

    @Override
    public FluentWebElement now() {
        LocatorProxies.now(this.webElement);
        return this;
    }

    @Override
    public FluentWebElement now(boolean force) {
        if (force) {
            this.reset();
        }
        return this.now();
    }

    @Override
    public FluentWebElement reset() {
        LocatorProxies.reset(this.webElement);
        return this;
    }

    @Override
    public boolean loaded() {
        return LocatorProxies.loaded(this.webElement);
    }

    @Deprecated
    public Dom axes() {
        return this.dom;
    }

    public Dom dom() {
        return this.dom;
    }

    public FluentConditions conditions() {
        return this.conditions;
    }

    public FluentWaitElement await() {
        return new FluentWaitElement(this.control.await(), this);
    }

    public MouseElementActions mouse() {
        return this.mouseActions;
    }

    public KeyboardElementActions keyboard() {
        return this.keyboardActions;
    }

    public <T> T as(Class<T> componentClass) {
        T component = this.instantiator.newComponent(componentClass, this.getElement());
        this.getFluentControl().injectComponent(component, this, (SearchContext)this.getElement());
        return component;
    }

    public FluentWebElement clear() {
        if (!this.isInputOfTypeFile()) {
            this.webElement.clear();
        }
        return this;
    }

    public FluentWebElement clearReactInput() {
        if (this.attribute("value").length() != 0) {
            this.javascriptActions.modifyAttribute("value", "");
        }
        return this;
    }

    @Override
    public FluentWebElement submit() {
        this.webElement.submit();
        return this;
    }

    @Override
    public FluentWebElement write(String ... text) {
        this.clear();
        if (text.length != 0) {
            this.webElement.sendKeys(new CharSequence[]{text[0]});
        }
        return this;
    }

    public String name() {
        return this.webElement.getAttribute("name");
    }

    public String attribute(String name) {
        return this.webElement.getAttribute(name);
    }

    public String cssValue(String propertyName) {
        return this.webElement.getCssValue(propertyName);
    }

    public String id() {
        return this.webElement.getAttribute("id");
    }

    public String text() {
        return this.webElement.getText();
    }

    public String textContent() {
        return this.webElement.getAttribute("textContent");
    }

    public String value() {
        return this.webElement.getAttribute("value");
    }

    public boolean displayed() {
        return this.webElement.isDisplayed();
    }

    public boolean enabled() {
        return this.webElement.isEnabled();
    }

    public boolean selected() {
        return this.webElement.isSelected();
    }

    public boolean clickable() {
        return ExpectedConditions.elementToBeClickable((WebElement)this.getElement()).apply((Object)this.control.getDriver()) != null;
    }

    public boolean stale() {
        return (Boolean)ExpectedConditions.stalenessOf((WebElement)this.getElement()).apply((Object)this.control.getDriver());
    }

    public String tagName() {
        return this.webElement.getTagName();
    }

    public WebElement getElement() {
        return this.webElement;
    }

    public WebElement getWrappedElement() {
        return this.getElement();
    }

    public Dimension size() {
        return this.webElement.getSize();
    }

    public FluentList<FluentWebElement> asList() {
        return this.instantiator.asComponentList(FluentListImpl.class, FluentWebElement.class, Arrays.asList(this.webElement));
    }

    @Override
    public FluentList<FluentWebElement> find(By locator, SearchFilter ... filters) {
        return this.search.find(locator, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(String selector, SearchFilter ... filters) {
        return this.search.find(selector, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(SearchFilter ... filters) {
        return this.search.find(filters);
    }

    @Override
    public FluentList<FluentWebElement> find(List<WebElement> rawElements) {
        return this.search.find(rawElements);
    }

    @Override
    public FluentList<FluentWebElement> $(List<WebElement> rawElements) {
        return this.search.$(rawElements);
    }

    @Override
    public FluentWebElement el(WebElement rawElement) {
        return this.search.el(rawElement);
    }

    public String html() {
        return this.webElement.getAttribute("innerHTML");
    }

    @Override
    public Fill fill() {
        return new Fill<FluentWebElement>(this);
    }

    @Override
    public FillSelect fillSelect() {
        return new FillSelect<FluentWebElement>(this);
    }

    @Override
    public FluentWebElement frame() {
        this.getFluentControl().window().switchTo().frame(this);
        return this;
    }

    @Override
    public Optional<FluentWebElement> optional() {
        if (this.present()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    private boolean isInputOfTypeFile() {
        return "input".equalsIgnoreCase(this.tagName()) && "file".equalsIgnoreCase(this.attribute("type"));
    }

    void setHookRestoreStack(Stack<List<HookDefinition<?>>> hookRestoreStack) {
        this.hookControl.setHookRestoreStack(hookRestoreStack);
    }

    public String toString() {
        return this.label.toString();
    }

    @Override
    public <R> R noHook(Class<? extends FluentHook> hook, Function<FluentWebElement, R> function) {
        return this.getHookControl().noHook(hook, function);
    }

    @Override
    public <O, H extends FluentHook<O>> FluentWebElement withHook(Class<H> hook, O options) {
        return this.getHookControl().withHook(hook, options);
    }

    @Override
    public <O, H extends FluentHook<O>> FluentWebElement withHook(Class<H> hook) {
        return this.getHookControl().withHook(hook);
    }

    @Override
    public FluentWebElement noHook(Class<? extends FluentHook> ... hooks) {
        return this.getHookControl().noHook(hooks);
    }

    @Override
    public <R> R noHook(Function<FluentWebElement, R> function) {
        return this.getHookControl().noHook(function);
    }

    @Override
    public FluentWebElement noHookInstance(Class<? extends FluentHook> ... hooks) {
        return this.getHookControl().noHookInstance(hooks);
    }

    @Override
    public FluentWebElement restoreHooks() {
        return this.getHookControl().restoreHooks();
    }

    @Override
    public FluentWebElement noHookInstance() {
        return this.getHookControl().noHookInstance();
    }

    @Override
    public FluentWebElement noHook() {
        return this.getHookControl().noHook();
    }

    public FluentWebElement scrollToCenter() {
        return this.getJavascriptActions().scrollToCenter();
    }

    public FluentWebElement scrollIntoView() {
        return this.getJavascriptActions().scrollIntoView();
    }

    public FluentWebElement scrollIntoView(boolean alignWithTop) {
        return this.getJavascriptActions().scrollIntoView(alignWithTop);
    }

    public FluentWebElement modifyAttribute(String attributeName, String attributeValue) {
        return this.getJavascriptActions().modifyAttribute(attributeName, attributeValue);
    }

    @Override
    public FluentWebElement withLabelHint(String ... labelHint) {
        return this.getLabel().withLabelHint(labelHint);
    }

    @Override
    public FluentWebElement withLabel(String label) {
        return this.getLabel().withLabel(label);
    }
}

