/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import java.util.List;
import java.util.function.Predicate;
import org.fluentlenium.core.conditions.AbstractIntegerConditions;
import org.fluentlenium.core.conditions.Conditions;
import org.fluentlenium.core.conditions.DynamicIntegerConditionsImpl;
import org.fluentlenium.core.conditions.FluentListConditions;
import org.fluentlenium.core.conditions.ListConditionsElements;
import org.fluentlenium.core.conditions.RectangleConditions;
import org.fluentlenium.core.conditions.RectangleListConditionsImpl;
import org.fluentlenium.core.conditions.StringConditions;
import org.fluentlenium.core.conditions.StringListConditionsImpl;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;

public abstract class AbstractFluentListConditions
implements FluentListConditions,
ListConditionsElements {
    private final List<? extends FluentWebElement> elements;
    private boolean negation;

    protected AbstractFluentListConditions(List<? extends FluentWebElement> elements) {
        this.elements = elements;
    }

    @Override
    public boolean size(int size) {
        int elementsSize = this.elements instanceof FluentList ? ((FluentList)this.elements).count() : this.elements.size();
        if (this.negation) {
            return elementsSize != size;
        }
        return elementsSize == size;
    }

    protected boolean isNegation() {
        return this.negation;
    }

    public void setNegation(boolean negation) {
        this.negation = negation;
    }

    protected List<? extends FluentWebElement> getElements() {
        return this.elements;
    }

    @Override
    public List<? extends FluentWebElement> getActualElements() {
        return this.elements;
    }

    @Override
    public AbstractIntegerConditions size() {
        return new DynamicIntegerConditionsImpl(() -> this.elements, this.negation);
    }

    @Override
    public boolean verify(Predicate<FluentWebElement> predicate) {
        return this.verify(predicate, false);
    }

    @Override
    public boolean present() {
        return this.verify(input -> input.conditions().present(), false);
    }

    @Override
    public boolean clickable() {
        return this.verify(input -> input.conditions().clickable(), false);
    }

    @Override
    public boolean stale() {
        return this.verify(input -> input.conditions().stale(), false);
    }

    @Override
    public boolean displayed() {
        return this.verify(input -> input.conditions().displayed(), false);
    }

    @Override
    public boolean enabled() {
        return this.verify(input -> input.conditions().enabled(), false);
    }

    @Override
    public boolean selected() {
        return this.verify(input -> input.conditions().selected(), false);
    }

    @Override
    public boolean attribute(String name, String value) {
        return this.attribute(name).equalTo(value);
    }

    @Override
    public StringConditions attribute(String name) {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, input -> input.attribute(name), input -> input.conditions().attribute(name));
    }

    @Override
    public boolean id(String id) {
        return this.id().equalTo(id);
    }

    @Override
    public StringConditions id() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::id, input -> input.conditions().id());
    }

    @Override
    public StringConditions name() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::name, input -> input.conditions().name());
    }

    @Override
    public boolean name(String name) {
        return this.name().equalTo(name);
    }

    @Override
    public StringConditions tagName() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::tagName, input -> input.conditions().tagName());
    }

    @Override
    public boolean tagName(String tagName) {
        return this.tagName().equalTo(tagName);
    }

    @Override
    public StringConditions value() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::value, input -> input.conditions().value());
    }

    @Override
    public boolean value(String value) {
        return this.value().equalTo(value);
    }

    @Override
    public StringConditions text() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::text, input -> input.conditions().text());
    }

    @Override
    public boolean text(String text) {
        return this.text().equalTo(text);
    }

    @Override
    public StringConditions textContent() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, FluentWebElement::textContent, input -> input.conditions().textContent());
    }

    @Override
    public boolean textContent(String anotherString) {
        return this.textContent().equalTo(anotherString);
    }

    @Override
    public RectangleConditions rectangle() {
        return new RectangleListConditionsImpl(this);
    }

    @Override
    public boolean className(String className) {
        return this.verify(input -> input.conditions().className(className), false);
    }
}

