/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fluentlenium.adapter.FluentControlContainer;
import org.fluentlenium.configuration.WebDrivers;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentControlImpl;
import org.fluentlenium.core.FluentDriver;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.inject.ContainerFluentControl;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public class FluentAdapter
extends FluentControlImpl
implements FluentControl {
    private static final Set<String> IGNORED_EXCEPTIONS = Stream.of("org.junit.internal.AssumptionViolatedException", "org.testng.SkipException").collect(Collectors.toSet());

    public FluentAdapter() {
    }

    public FluentAdapter(FluentControlContainer controlContainer) {
        super(controlContainer);
    }

    public FluentAdapter(FluentControlContainer controlContainer, Class clazz) {
        super(controlContainer, clazz);
    }

    @Override
    public ContainerFluentControl getFluentControl() {
        FluentControlContainer fluentControlContainer = this.getControlContainer();
        if (fluentControlContainer == null) {
            throw new IllegalStateException("FluentControl is not initialized, WebDriver or Configuration issue");
        }
        return (ContainerFluentControl)fluentControlContainer.getFluentControl();
    }

    boolean isFluentControlAvailable() {
        return this.getControlContainer().getFluentControl() != null;
    }

    private void setFluentControl(ContainerFluentControl fluentControl) {
        this.getControlContainer().setFluentControl(fluentControl);
    }

    @Override
    public final WebDriver getDriver() {
        return this.getFluentControl() == null ? null : this.getFluentControl().getDriver();
    }

    public void initFluent(WebDriver webDriver) {
        if (webDriver == null) {
            this.releaseFluent();
            return;
        }
        if (this.getFluentControl() != null) {
            if (this.getFluentControl().getDriver() == webDriver) {
                return;
            }
            if (this.getFluentControl().getDriver() != null) {
                throw new IllegalStateException("Trying to init a WebDriver, but another one is still running");
            }
        }
        ContainerFluentControl adapterFluentControl = new ContainerFluentControl(new FluentDriver(webDriver, this, this));
        this.setFluentControl(adapterFluentControl);
        ContainerContext context = adapterFluentControl.inject(this);
        adapterFluentControl.setContext(context);
    }

    public void releaseFluent() {
        if (this.getFluentControl() != null) {
            ((FluentDriver)this.getFluentControl().getAdapterControl()).releaseFluent();
            this.setFluentControl(null);
        }
    }

    public WebDriver newWebDriver() {
        WebDriver webDriver = WebDrivers.INSTANCE.newWebDriver(this.getWebDriver(), this.getCapabilities(), this);
        if (Boolean.TRUE.equals(this.getEventsEnabled())) {
            webDriver = new EventFiringWebDriver(webDriver);
        }
        return webDriver;
    }

    boolean isIgnoredException(Throwable e) {
        if (e == null) {
            return false;
        }
        Class<?> clazz = e.getClass();
        do {
            if (!IGNORED_EXCEPTIONS.contains(clazz.getName())) continue;
            return true;
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return false;
    }
}

