/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fluentlenium.core.domain.WrapsElements;
import org.fluentlenium.core.proxy.AbstractLocatorAndInvocationHandler;
import org.fluentlenium.core.proxy.ElementInstanceLocator;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class ListHandler
extends AbstractLocatorAndInvocationHandler<List<WebElement>> {
    private static final Method GET_WRAPPED_ELEMENTS = ReflectionUtils.getMethod(WrapsElements.class, "getWrappedElements", new Class[0]);

    public ListHandler(ElementLocator locator) {
        super(locator);
        if (this.locator instanceof WrapsElements) {
            this.fireProxyElementSearch();
            List<Object> foundElements = ((WrapsElements)this.locator).getWrappedElements();
            if (foundElements == null) {
                foundElements = Collections.emptyList();
            }
            this.result = this.wrapElements(foundElements);
            this.fireProxyElementFound(this.result);
        }
    }

    @Override
    public String getMessageContext() {
        return "Elements " + this.toString();
    }

    @Override
    protected List<WebElement> resultToList(List<WebElement> result) {
        return result;
    }

    @Override
    protected WebElement getElement() {
        return null;
    }

    @Override
    public List<WebElement> getInvocationTarget(Method method) {
        return (List)this.result;
    }

    @Override
    public boolean present() {
        return super.present() && ((List)this.result).size() > 0;
    }

    @Override
    protected boolean isStale() {
        if (((List)this.result).size() > 0) {
            try {
                ((WebElement)((List)this.result).get(0)).isEnabled();
            }
            catch (StaleElementReferenceException e) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<WebElement> getLocatorResultImpl() {
        List<WebElement> foundElements = this.getHookLocator().findElements();
        if (foundElements == null) {
            foundElements = Collections.emptyList();
        }
        return this.wrapElements(foundElements);
    }

    private List<WebElement> wrapElements(List<WebElement> foundElements) {
        ArrayList<WebElement> proxyElements = new ArrayList<WebElement>();
        for (WebElement element : foundElements) {
            WebElement proxyElement = LocatorProxies.createWebElement(new ElementInstanceLocator(element));
            LocatorProxies.setHooks(proxyElement, this.hookChainBuilder, this.hookDefinitions);
            proxyElements.add(proxyElement);
        }
        return proxyElements;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (GET_WRAPPED_ELEMENTS.equals(method)) {
            return this.loaded() ? this.getLocatorResult() : proxy;
        }
        return super.invoke(proxy, method, args);
    }

    @Override
    protected String getLazyToString() {
        return "Lazy Element List";
    }
}

