/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.fluentlenium.configuration.BaseConfiguration;
import org.fluentlenium.configuration.CapabilitiesConfigurationPropertyRetriever;
import org.fluentlenium.configuration.ConfigurationDefaults;
import org.fluentlenium.configuration.ConfigurationFactory;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.PropertiesBackend;
import org.openqa.selenium.Capabilities;

public class PropertiesBackendConfiguration
extends BaseConfiguration
implements ConfigurationProperties {
    static final String PROPERTIES_PREFIX = "fluentlenium.";
    private final String[] prefixes;
    private CapabilitiesConfigurationPropertyRetriever capabilitiesRetriever;
    private PropertiesBackend propertiesBackend;

    PropertiesBackendConfiguration(PropertiesBackend propertiesReader) {
        this(propertiesReader, PROPERTIES_PREFIX);
    }

    PropertiesBackendConfiguration(PropertiesBackend propertiesReader, String ... prefixes) {
        if (prefixes.length == 0) {
            throw new IllegalArgumentException("At least one configuration property prefix should be defined.Alternatively you can call the PropertiesBackendConfiguration(PropertiesBackend) constructorto have the default 'fluentlenium.' prefix configured.");
        }
        this.propertiesBackend = propertiesReader;
        this.prefixes = prefixes;
        this.capabilitiesRetriever = new CapabilitiesConfigurationPropertyRetriever();
    }

    PropertiesBackend getPropertiesBackend() {
        return this.propertiesBackend;
    }

    void setPropertiesBackend(PropertiesBackend propertiesBackend) {
        this.propertiesBackend = propertiesBackend;
    }

    private String getPropertyImpl(String propertyName) {
        return this.propertiesBackend.getProperty(propertyName);
    }

    private String getProperty(String propertyName) {
        for (String prefix : this.prefixes) {
            String property = this.getPropertyImpl(prefix + propertyName);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    private boolean isValidProperty(String property) {
        return !StringUtils.isEmpty((CharSequence)property) && !"null".equalsIgnoreCase(property);
    }

    private String getStringProperty(String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property)) {
            return null;
        }
        return property;
    }

    private Long getLongProperty(String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property) || property == null) {
            return null;
        }
        try {
            return Long.parseLong(property);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Boolean getBooleanProperty(String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property) || property == null) {
            return null;
        }
        return Boolean.parseBoolean(property);
    }

    private <T extends Enum<T>> T getEnumProperty(Class<T> enumClass, String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property) || property == null) {
            return null;
        }
        if ("DEFAULT".equalsIgnoreCase(propertyName)) {
            return null;
        }
        return Enum.valueOf(enumClass, property.toUpperCase(Locale.ENGLISH));
    }

    private <T> Class<T> getClassProperty(Class<T> clazz, String propertyName) {
        String property = this.getProperty(propertyName);
        if (!this.isValidProperty(property) || property == null) {
            return null;
        }
        try {
            Class<?> propertyClass = Class.forName(property);
            if (clazz.isAssignableFrom(propertyClass)) {
                return propertyClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Class<? extends ConfigurationFactory> getConfigurationFactory() {
        return this.getClassProperty(ConfigurationFactory.class, "configurationFactory");
    }

    @Override
    public Class<? extends ConfigurationProperties> getConfigurationDefaults() {
        return this.getClassProperty(ConfigurationDefaults.class, "configurationDefaults");
    }

    @Override
    public String getWebDriver() {
        return this.getStringProperty("webDriver");
    }

    @Override
    public String getRemoteUrl() {
        return this.getStringProperty("remoteUrl");
    }

    @Override
    public Capabilities getCapabilities() {
        String capabilities = this.getProperty("capabilities");
        if (this.isValidProperty(capabilities)) {
            return this.capabilitiesRetriever.getCapabilitiesProperty(capabilities, this.getGlobalConfiguration());
        }
        return null;
    }

    @Override
    public ConfigurationProperties.DriverLifecycle getDriverLifecycle() {
        return this.getEnumProperty(ConfigurationProperties.DriverLifecycle.class, "driverLifecycle");
    }

    @Override
    public Long getBrowserTimeout() {
        return this.getLongProperty("browserTimeout");
    }

    @Override
    public Integer getBrowserTimeoutRetries() {
        Long browserTimeout = this.getLongProperty("browserTimeout");
        return browserTimeout == null ? null : Integer.valueOf(browserTimeout.intValue());
    }

    @Override
    public Boolean getDeleteCookies() {
        return this.getBooleanProperty("deleteCookies");
    }

    @Override
    public String getBaseUrl() {
        return this.getStringProperty("baseUrl");
    }

    @Override
    public Boolean getEventsEnabled() {
        return this.getBooleanProperty("eventsEnabled");
    }

    @Override
    public Long getPageLoadTimeout() {
        return this.getLongProperty("pageLoadTimeout");
    }

    @Override
    public Long getImplicitlyWait() {
        return this.getLongProperty("implicitlyWait");
    }

    @Override
    public Long getScriptTimeout() {
        return this.getLongProperty("scriptTimeout");
    }

    @Override
    public Long getAwaitAtMost() {
        return this.getLongProperty("awaitAtMost");
    }

    @Override
    public Long getAwaitPollingEvery() {
        return this.getLongProperty("awaitPollingEvery");
    }

    @Override
    public String getScreenshotPath() {
        return this.getStringProperty("screenshotPath");
    }

    @Override
    public String getHtmlDumpPath() {
        return this.getStringProperty("htmlDumpPath");
    }

    @Override
    public ConfigurationProperties.TriggerMode getScreenshotMode() {
        return this.getEnumProperty(ConfigurationProperties.TriggerMode.class, "screenshotMode");
    }

    @Override
    public ConfigurationProperties.TriggerMode getHtmlDumpMode() {
        return this.getEnumProperty(ConfigurationProperties.TriggerMode.class, "htmlDumpMode");
    }

    @Override
    public String getCustomProperty(String propertyName) {
        return this.getStringProperty(propertyName);
    }

    @VisibleForTesting
    void setCapabilitiesRetriever(CapabilitiesConfigurationPropertyRetriever capabilitiesRetriever) {
        this.capabilitiesRetriever = capabilitiesRetriever;
    }
}

