/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.fluentlenium.adapter.DefaultFluentControlContainer;
import org.fluentlenium.adapter.DefaultSharedMutator;
import org.fluentlenium.adapter.FluentAdapter;
import org.fluentlenium.adapter.FluentControlContainer;
import org.fluentlenium.adapter.SharedMutator;
import org.fluentlenium.adapter.exception.AnnotationNotFoundException;
import org.fluentlenium.adapter.exception.MethodNotFoundException;
import org.fluentlenium.adapter.sharedwebdriver.SharedWebDriver;
import org.fluentlenium.adapter.sharedwebdriver.SharedWebDriverContainer;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentTestRunnerAdapter
extends FluentAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluentTestRunnerAdapter.class);
    private final SharedMutator sharedMutator;
    private static final ThreadLocal<SharedMutator.EffectiveParameters<?>> PARAMETERS_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> TEST_METHOD_NAME = new ThreadLocal();
    private static final ThreadLocal<Class<?>> TEST_CLASS = new ThreadLocal();

    public FluentTestRunnerAdapter() {
        this(new DefaultFluentControlContainer());
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer) {
        this(driverContainer, new DefaultSharedMutator());
    }

    public FluentTestRunnerAdapter(SharedMutator sharedMutator) {
        this((FluentControlContainer)new DefaultFluentControlContainer(), sharedMutator);
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer, SharedMutator sharedMutator) {
        super(driverContainer);
        this.sharedMutator = sharedMutator;
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer, Class clazz, SharedMutator sharedMutator) {
        super(driverContainer, clazz);
        this.sharedMutator = sharedMutator;
    }

    public static void afterClass(Class<?> testClass) {
        List<SharedWebDriver> sharedWebDrivers = SharedWebDriverContainer.INSTANCE.getTestClassDrivers(testClass);
        for (SharedWebDriver sharedWebDriver : sharedWebDrivers) {
            SharedWebDriverContainer.INSTANCE.quit(sharedWebDriver);
        }
    }

    protected Class<?> getTestClass() {
        Class<?> currentTestClass = TEST_CLASS.get();
        if (currentTestClass == null) {
            LOGGER.warn("Current test class is null. Are you in test context?");
        }
        return currentTestClass;
    }

    protected String getTestMethodName() {
        String currentTestMethodName = TEST_METHOD_NAME.get();
        if (currentTestMethodName == null) {
            LOGGER.warn("Current test method name is null. Are you in text context?");
        }
        return currentTestMethodName;
    }

    protected <T extends Annotation> T getClassAnnotation(Class<T> annotation) {
        T definedAnnotation = this.getTestClass().getAnnotation(annotation);
        if (definedAnnotation == null) {
            throw new AnnotationNotFoundException();
        }
        return definedAnnotation;
    }

    protected <T extends Annotation> T getMethodAnnotation(Class<T> annotation) {
        T definedAnnotation;
        try {
            definedAnnotation = this.getTestClass().getDeclaredMethod(this.getTestMethodName(), new Class[0]).getAnnotation(annotation);
        }
        catch (NoSuchMethodException e) {
            throw new MethodNotFoundException(e);
        }
        if (definedAnnotation == null) {
            throw new AnnotationNotFoundException();
        }
        return definedAnnotation;
    }

    protected void starting() {
        this.starting(this.getClass());
    }

    protected void starting(String testName) {
        this.starting(this.getClass(), testName);
    }

    protected void starting(Class<?> testClass) {
        this.starting(testClass, testClass.getName());
    }

    protected void starting(Class<?> testClass, String testName) {
        SharedWebDriver sharedWebDriver;
        PARAMETERS_THREAD_LOCAL.set(this.sharedMutator.getEffectiveParameters(testClass, testName, this.getDriverLifecycle()));
        try {
            sharedWebDriver = this.getSharedWebDriver(PARAMETERS_THREAD_LOCAL.get());
        }
        catch (InterruptedException | ExecutionException e) {
            this.failed(testClass, testName);
            String causeMessage = this.getCauseMessage(e);
            throw new WebDriverException("Browser failed to start, test [ " + testName + " ] execution interrupted." + (StringUtils.isEmpty((CharSequence)causeMessage) ? "" : "\nCaused by: [ " + causeMessage + "]"), (Throwable)e);
        }
        this.initFluent(sharedWebDriver.getDriver());
    }

    private void setTestClassAndMethodValues() {
        Optional.ofNullable(PARAMETERS_THREAD_LOCAL.get()).ifPresent(effectiveParameters -> {
            Optional.ofNullable(effectiveParameters.getTestClass()).ifPresent(TEST_CLASS::set);
            Optional.ofNullable(effectiveParameters.getTestName()).ifPresent(this::setMethodName);
        });
    }

    private void setMethodName(String methodName) {
        String className = StringUtils.substringBefore((String)methodName, (String)"(");
        TEST_METHOD_NAME.set(className);
    }

    private String getCauseMessage(Exception e) {
        String causeMessage = null;
        Throwable cause = e;
        while (cause.getCause() != null && cause.getCause() != cause) {
            if ((cause = cause.getCause()).getLocalizedMessage() == null) continue;
            causeMessage = cause.getLocalizedMessage();
        }
        return causeMessage;
    }

    private SharedWebDriver getSharedWebDriver(SharedMutator.EffectiveParameters<?> parameters) throws ExecutionException, InterruptedException {
        return this.getSharedWebDriver(parameters, null);
    }

    protected SharedWebDriver getSharedWebDriver(SharedMutator.EffectiveParameters<?> parameters, ExecutorService webDriverExecutor) throws ExecutionException, InterruptedException {
        SharedWebDriver sharedWebDriver = null;
        ExecutorService executorService = this.getExecutor(webDriverExecutor);
        for (int retryCount = 0; retryCount < this.getBrowserTimeoutRetries(); ++retryCount) {
            Future<SharedWebDriver> futureWebDriver = this.createDriver(parameters, executorService);
            this.shutDownExecutor(executorService);
            try {
                sharedWebDriver = futureWebDriver.get();
            }
            catch (InterruptedException | ExecutionException e) {
                executorService.shutdownNow();
                throw e;
            }
            if (sharedWebDriver != null) break;
        }
        this.setTestClassAndMethodValues();
        return sharedWebDriver;
    }

    private void shutDownExecutor(ExecutorService executorService) throws InterruptedException {
        executorService.shutdown();
        if (this.didNotExitGracefully(executorService)) {
            executorService.shutdownNow();
        }
    }

    private boolean didNotExitGracefully(ExecutorService executorService) throws InterruptedException {
        return !executorService.awaitTermination(this.getBrowserTimeout(), TimeUnit.MILLISECONDS);
    }

    private Future<SharedWebDriver> createDriver(SharedMutator.EffectiveParameters<?> parameters, ExecutorService executorService) {
        return executorService.submit(() -> SharedWebDriverContainer.INSTANCE.getOrCreateDriver(this::newWebDriver, parameters));
    }

    private ExecutorService getExecutor(ExecutorService webDriverExecutor) {
        if (webDriverExecutor == null) {
            return Executors.newSingleThreadExecutor();
        }
        return webDriverExecutor;
    }

    private void clearThreadLocals() {
        PARAMETERS_THREAD_LOCAL.remove();
        TEST_CLASS.remove();
        TEST_METHOD_NAME.remove();
    }

    protected void finished() {
        this.finished(this.getClass());
    }

    protected void finished(String testName) {
        this.finished(this.getClass(), testName);
    }

    protected void finished(Class<?> testClass) {
        this.finished(testClass, testClass.getName());
    }

    protected void finished(Class<?> testClass, String testName) {
        SharedWebDriver sharedWebDriver;
        block5: {
            block4: {
                ConfigurationProperties.DriverLifecycle driverLifecycle = this.getDriverLifecycle();
                SharedMutator.EffectiveParameters<?> parameters = this.sharedMutator.getEffectiveParameters(testClass, testName, driverLifecycle);
                sharedWebDriver = SharedWebDriverContainer.INSTANCE.getDriver(parameters);
                if (driverLifecycle == ConfigurationProperties.DriverLifecycle.METHOD) break block4;
                if (driverLifecycle != ConfigurationProperties.DriverLifecycle.THREAD) break block5;
            }
            Optional.ofNullable(sharedWebDriver).ifPresent(SharedWebDriverContainer.INSTANCE::quit);
        }
        if (this.getDeleteCookies().booleanValue()) {
            Optional.ofNullable(sharedWebDriver).ifPresent(shared -> shared.getDriver().manage().deleteAllCookies());
        }
        this.clearThreadLocals();
        this.releaseFluent();
    }

    protected void failed() {
        this.failed(this.getClass());
    }

    protected void failed(String testName) {
        this.failed(this.getClass(), testName);
    }

    protected void failed(Class<?> testClass) {
        this.failed(testClass, testClass.getName());
    }

    protected void failed(Class<?> testClass, String testName) {
        this.failed(null, testClass, testName);
    }

    protected void failed(Throwable e, Class<?> testClass, String testName) {
        if (this.isFluentControlAvailable() && !this.isIgnoredException(e)) {
            try {
                if (this.getScreenshotMode() == ConfigurationProperties.TriggerMode.AUTOMATIC_ON_FAIL && this.canTakeScreenShot()) {
                    this.takeScreenshot(testClass.getSimpleName() + "_" + testName + ".png");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.getHtmlDumpMode() == ConfigurationProperties.TriggerMode.AUTOMATIC_ON_FAIL && this.getDriver() != null) {
                    this.takeHtmlDump(testClass.getSimpleName() + "_" + testName + ".html");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

